/*
    Relay -- a tool to record and play Quake2 demos
    Copyright (C) 2000 Conor Davis

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

    Conor Davis
    cedavis@planetquake.com
*/

#include "q2defines.h"

short SwapShort(short l)
{
    byte b1, b2;

    b1 = l & 0xFF;
    b2 = (l>>8) & 0xFF;

    return (b1<<8) + b2;
}

int SwapLong(int l)
{
    byte b1, b2, b3, b4;

    b1 = l & 0xFF;
    b2 = (l>>8) & 0xFF;
    b3 = (l>>16) & 0xFF;
    b4 = (l>>24) & 0xFF;

    return ((int)b1<<24) + ((int)b2<<16) + ((int)b3<<8) + b4;
}

float SwapFloat (float f)
{
    union
    {
        float   f;
        byte    b[4];
    } dat1, dat2;
    
    
    dat1.f = f;
    dat2.b[0] = dat1.b[3];
    dat2.b[1] = dat1.b[2];
    dat2.b[2] = dat1.b[1];
    dat2.b[3] = dat1.b[0];
    return dat2.f;
}
