/*
	Relay -- a tool to record and play Quake2 demos
	Copyright (C) 1999 Conor Davis

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	Conor Davis
	cedavis@epid.org
*/

#ifndef	__EXPORT_H
#define	__EXPORT_H

extern void SpawnEntities (char *mapname, char *entities, char *spawnpoint);
extern void ClientThink (edict_t *ent, usercmd_t *cmd);
extern qboolean ClientConnect (edict_t *ent, char *userinfo);
extern void ClientUserinfoChanged (edict_t *ent, char *userinfo);
extern void ClientDisconnect (edict_t *ent);
extern void ClientBegin (edict_t *ent);
extern void ClientCommand (edict_t *ent);
extern void RunEntity (edict_t *ent);
extern void WriteGame (char *filename, qboolean autosave);
extern void ReadGame (char *filename);
extern void WriteLevel (char *filename);
extern void ReadLevel (char *filename);
extern void InitGame (void);
extern void G_RunFrame (void);
extern void ShutdownGame (void);
extern void ServerCommand (void);

#endif	// __EXPORT_H