/*
	Relay -- a tool to record and play Quake2 demos
	Copyright (C) 1999 Conor Davis

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	Conor Davis
	cedavis@epid.org
*/

#include <windows.h>
#include <stdio.h>

#include "shared.h"
#include "utils.h"

//
// MISCELLANEOUS
//

size_t mstime()
{
	return GetTickCount();
}

char *GamePath(char *dest, char *basedir, char *gamedir)
{
	if (basedir[0])
	{
		strcpy(dest, basedir);
		strcat(dest, "/");
	}

	if (gamedir[0])
		strcat(dest, gamedir);
	else
		strcat(dest, "baseq2");

	return dest;
}

qboolean FileExists(char *filename)
{
	FILE	*f;

	f = fopen(filename, "rb");

	if (!f)
		return false;

	close(f);
	return true;
}

int ExpandString(char *dest, int len, char *src, char format[256][32])
{
	char *o, *s;

	o = dest;
	while (*src && len)
	{
		if (*src == '%')
		{
			src++;
			s = format[*src];
			while (*s && len)
			{
				*o++ = *s++;
				len--;
			}
			src++;
		}
		else
		{
			*o++ = *src++;
			len--;
		}
	}

	if (len)
	{
		*o++ = 0;
		return o - dest;
	}

	return 0;
}

//
// COMMANDS
//

int Argc(char *s)
{
	int		argc = 0;

	while (1)
	{
		while (*s == ' ' || *s == '\t')
			s++;

		if (!*s)
			break;

		argc++;
		if (*s == '\"')
		{
			s++;
			while (*s != '\"')
				s++;
			s++;
		}
		else
		{
			while (*s && *s != ' ' && *s != '\t')
				s++;
		}
	}

	return argc;
}

char *Argv(char *s, int index)
{
	static char	buffer[8][MAX_TOKEN_CHARS];
	static int	buffer_index;
	char		*dest;

	buffer_index = (buffer_index + 1) & 7;

	while(1)
	{
		while (*s == ' ' || *s == '\t')
			s++;

		if (!*s)
			return NULL;

		dest = buffer[buffer_index];

		if (*s == '\"')
		{
			s++;
			while (*s != '\"')
				*dest++ = *s++;
			*dest = 0;
			s++;
		}
		else
		{
			while (*s && *s != ' ' && *s != '\t')
				*dest++ = *s++;
			*dest = 0;
		}
		
		if (!index--)
			return buffer[buffer_index];
	}
}

char *Args(char *s)
{
	while (*s == ' ' || *s == '\t')
		s++;

	if (*s == '\"')
	{
		s++;
		while (*s != '\"')
			s++;
		s++;
	}
	else
	{
		while (*s && *s != ' ' && *s != '\t')
			s++;
	}
	
	while (*s == ' ' || *s == '\t')
		s++;

	return s;
}

// SplitCommandString()
// Takes a compound command, extracts the first command (separated by newline or given delimeter),
// add a null terminator, and returns a pointer to the next command or NULL if no more commands
// NOTE: This overwrites the original string!
char *SplitCommandString(char *in, char c)
{
	char	*s;

	if (!in)
		return NULL;

	s = in;
	while (*s)
	{
		// Skip whitespace
		while (*s == ' ' || *s == '\t')
			s++;

		// treat quoted strings specially
		if (*s == '\"')
		{
			s++;
			while (*s != '\"')
			{
				if (!*s || *s == '\n')
				{
					Com_Printf("Line has unmatched quote, discarded.\n");
					*in = 0;
					return NULL;
				}
				s++;
			}
			s++;
			continue;
		}
		else if (s[0] == '/' && s[1] == '/')		// check for "//" comments
		{
			*s++ = 0;
			while (*s && *s != '\n')
				s++;

			if (!*s)
				return NULL;
			
			s++;
			while (*s == ' ' || *s == '\t' || *s == c || *s == '\n')
				s++;
			if (!*s)
				return NULL;
			return s;
		}
		else										// regular non-quoted, non-commented word
		{
			while (*s != ' ')
			{
				if (!*s)
					return NULL;

				if (*s == c || *s == '\n')
				{
					*s++ = 0;
					while (*s == ' ' || *s == '\t' || *s == c || *s == '\n')
						s++;
					if (!*s)
						return NULL;
					return s;
				}
				s++;
			}
		}
	}

	return NULL;
}
