/*
	Relay -- a tool to record and play Quake2 demos
	Copyright (C) 1999 Conor Davis

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	Conor Davis
	cedavis@epid.org
*/

#ifndef __PROXY_H
#define __PROXY_H

#include <windows.h>

typedef struct
{
	HANDLE			hModule;
	game_export_t	*ge;
} proxy_t;

extern void UnloadGameModule(proxy_t *proxy);
extern qboolean LoadGameModule(proxy_t *proxydata, char *path, game_import_t *import);
extern void LoadNextModule(proxy_t *proxy, game_import_t *import);

#endif // __PROXY_H