/*
	Relay -- a tool to record and play Quake2 demos
	Copyright (C) 1999 Conor Davis

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	Conor Davis
	cedavis@epid.org
*/

#ifndef	__MSG_H
#define	__MSG_H

typedef struct msg_s
{
	int		id;
	void	*data;
	qboolean reliable;
	vec3_t	origin;
	size_t	reference_count;
	struct	msg_s *prev;
	struct	msg_s *next;
} msg_t;

extern msg_t *CreateMessage(int id, void *data, size_t data_size, qboolean reliable);
extern void FreeMessage(msg_t *msg);
extern void AddMessage(msg_t **array, msg_t *msg);
extern void RemoveMessage(msg_t **array, msg_t *msg);
extern void RemoveAllMessages(msg_t **array);
extern void FreeAllMessages();

#endif	// __MSG_H