/*
	Relay -- a tool to record and play Quake2 demos
	Copyright (C) 1999 Conor Davis

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	Conor Davis
	cedavis@epid.org
*/

#include "g_local.h"
#include "q2utils.h"

field_t fields[] =
{
	{"classname", FOFS(classname), F_LSTRING},
	{"origin", FOFS(s.origin), F_VECTOR},
	{"angles", FOFS(s.angles), F_VECTOR},
	{"angle", FOFS(s.angles), F_ANGLEHACK},
	{0, 0, 0, 0}
};

void InitGame (void)
{
	gi.dprintf ("==== InitGame ====\n");

	Swap_Init();

	dedicated = gi.cvar ("dedicated", "0", CVAR_NOSET);
	maxclients = gi.cvar ("maxclients", "4", CVAR_SERVERINFO | CVAR_LATCH);
	maxspectators = gi.cvar ("maxspectators", "4", CVAR_SERVERINFO);
	password = gi.cvar ("password", "", CVAR_USERINFO);
	spectator_password = gi.cvar ("spectator_password", "", CVAR_USERINFO);
	needpass = gi.cvar ("needpass", "0", CVAR_SERVERINFO);
	filterban = gi.cvar ("filterban", "1", 0);
	// flood control
	flood_msgs = gi.cvar ("flood_msgs", "4", 0);
	flood_persecond = gi.cvar ("flood_persecond", "4", 0);
	flood_waitdelay = gi.cvar ("flood_waitdelay", "10", 0);

	// force 1024 maxentities
	//game.maxentities = maxentities->value;
	game.maxentities = 1024;
	g_edicts =  gi.TagMalloc (game.maxentities * sizeof(g_edicts[0]), TAG_GAME);
	globals.edicts = g_edicts;
	globals.max_edicts = game.maxentities;

	// initialize all clients for this game
	game.maxclients = maxclients->value;
	game.clients = gi.TagMalloc (game.maxclients * sizeof(game.clients[0]), TAG_GAME);
//	memset(game.clients, 0, game.maxclients * sizeof(game.clients[0]));
//	globals.num_edicts = game.maxclients+1;
}

void WriteGame (char *filename, qboolean autosave)
{
	gi.dprintf("=== WriteGame ===\n");
}

void ReadGame (char *filename)
{
	gi.dprintf("=== ReadGame ===\n");
}

void WriteLevel (char *filename)
{
	gi.dprintf("=== WriteLevel ===\n");
}

void ReadLevel (char *filename)
{
	gi.dprintf("=== ReadLevel ===\n");
}
