/*
	Relay -- a tool to record and play Quake2 demos
	Copyright (C) 1999 Conor Davis

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	Conor Davis
	cedavis@epid.org
*/

#ifndef	__IMPORT_H
#define	__IMPORT_H

extern void import_bprintf(int printlevel, char *fmt, ...);
extern void import_cprintf(edict_t *ent, int printlevel, char *fmt, ...);
extern void import_centerprintf(edict_t *ent, char *fmt, ...);
extern void import_sound(edict_t *ent, int channel, int soundindex, float volume, float attenuation, float timeofs);
extern void import_positioned_sound(vec3_t origin, edict_t *ent, int channel, int soundindex, float volume, float attenuation, float timeofs);
extern void import_configstring(int num, char *string);
extern int import_modelindex(char *name);
extern int import_soundindex(char *name);
extern int import_imageindex(char *name);
extern void import_setmodel(edict_t *ent, char *name);
extern void import_SetAreaPortalState(int portalnum, qboolean connected);
extern void import_linkentity(edict_t *ent);
extern void import_unlinkentity(edict_t *ent);
extern void import_multicast(vec3_t origin, multicast_t to);
extern void import_unicast(edict_t *ent, qboolean reliable);
extern void import_WriteChar(int c);
extern void import_WriteByte(int c);
extern void import_WriteShort(int c);
extern void import_WriteLong(int c);
extern void import_WriteFloat(float f);
extern void import_WriteString(char *s);
extern void import_WritePosition(vec3_t pos);
extern void import_WriteDir(vec3_t pos);
extern void import_WriteAngle(float f);

#endif	// __IMPORT_H