/*
	Relay -- a tool to record and play Quake2 demos
	Copyright (C) 1999 Conor Davis

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	Conor Davis
	cedavis@epid.org
*/

#include "g_local.h"
#include "export.h"
#include "import.h"

game_import_t	gi;			// exported by quake2.exe to me
game_import_t	my_gi;		// exported by me to game dll

game_export_t	globals;	// exported by game dll to me
game_export_t	*ge;		// exported by me to quake2.exe

cvar_t			*maxclients;

proxy_t			proxydata;

FILE			*outfile;
dm2_t			dm2out;
int				last_frame;
int				current_frame;
block_t			tempblock;
char			tempblock_buffer[MAX_MSGLEN];

block_t			prefix;
char			prefix_buffer[MAX_SVSLEN];
block_t			suffix;
char			suffix_buffer[MAX_SVSLEN];

/*
=================
GetGameAPI

Returns a pointer to the structure with all entry points
and global variables
=================
*/
game_export_t *GetGameAPI (game_import_t *import)
{
	gi = *import;

	my_gi = gi;
	my_gi.bprintf						= import_bprintf;
	my_gi.cprintf						= import_cprintf;
	my_gi.centerprintf					= import_centerprintf;
	my_gi.sound							= import_sound;
	my_gi.positioned_sound				= import_positioned_sound;
	my_gi.configstring					= import_configstring;
	my_gi.modelindex					= import_modelindex;
	my_gi.soundindex					= import_soundindex;
	my_gi.imageindex					= import_imageindex;
	my_gi.setmodel						= import_setmodel;
	my_gi.SetAreaPortalState			= import_SetAreaPortalState;
	my_gi.linkentity					= import_linkentity;
	my_gi.unlinkentity					= import_unlinkentity;
	my_gi.multicast						= import_multicast;
	my_gi.unicast						= import_unicast;
	my_gi.WriteChar						= import_WriteChar;
	my_gi.WriteByte						= import_WriteByte;
	my_gi.WriteShort					= import_WriteShort;
	my_gi.WriteLong						= import_WriteLong;
	my_gi.WriteFloat					= import_WriteFloat;
	my_gi.WriteString					= import_WriteString;
	my_gi.WritePosition					= import_WritePosition;
	my_gi.WriteDir						= import_WriteDir;
	my_gi.WriteAngle					= import_WriteAngle;

	gi.dprintf("\nRelay v" RELAYVERSION " " RELAYSTATUS "\nCopyright (c) 1999, by Conor Davis\ne-mail: cedavis@epid.org\nbased on ProxyMod v1.03 by Avi Rozen (Zung!)\ne-mail: avrozen@ibm.net\n\n");
	LoadNextModule(&proxydata, &my_gi);
	if (!proxydata.ge)
		return NULL;

	ge = proxydata.ge;
	globals = *ge;
	ge->Init							= InitGame;
	ge->Shutdown						= ShutdownGame;
	ge->SpawnEntities					= SpawnEntities;
	// not intercepted by this module
//	ge->WriteGame						= WriteGame;
//	ge->ReadGame						= ReadGame;
//	ge->WriteLevel						= WriteLevel;
//	ge->ReadLevel						= ReadLevel;
//	ge->ClientThink						= ClientThink;
//	ge->ClientConnect					= ClientConnect;
//	ge->ClientUserinfoChanged			= ClientUserinfoChanged;
//	ge->ClientDisconnect				= ClientDisconnect;
//	ge->ClientBegin						= ClientBegin;
//	ge->ClientCommand					= ClientCommand;
	ge->RunFrame						= G_RunFrame;
	ge->ServerCommand					= ServerCommand;

	return ge;
}

void Sys_Error (char *error, ...)
{
	va_list		argptr;
	char		text[1024];

	va_start (argptr, error);
	vsprintf (text, error, argptr);
	va_end (argptr);

	gi.error ("%s", text);
}

void Com_Printf (char *msg, ...)
{
	va_list		argptr;
	char		text[1024];

	va_start (argptr, msg);
	vsprintf (text, msg, argptr);
	va_end (argptr);

	gi.dprintf ("%s", text);
}
