/*
	Relay -- a tool to record and play Quake2 demos
	Copyright (C) 1999 Conor Davis

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	Conor Davis
	cedavis@epid.org
*/

#ifndef	__LOCAL_H
#define	__LOCAL_H

#include <stdio.h>

#include "shared.h"
#include "dm2.h"
#include "proxy.h"

#define RELAYVERSION	"0.01"
#define RELAYPLATFORM	"x86"
#define RELAYSTATUS		"BETA"

#define	EDICT2NUM(x)	((int)((byte *)(x) - (byte *)ge->edicts) / ge->edict_size)
#define	NUM2EDICT(x)	((edict_t *)((byte *)ge->edicts + ge->edict_size*(x)))

extern game_import_t	gi;
extern game_import_t	my_gi;

extern game_export_t	globals;
extern game_export_t	*ge;

extern cvar_t			*maxclients;

extern proxy_t			proxydata;

extern FILE				*outfile;
extern dm2_t			dm2out;
extern int				last_frame;
extern int				current_frame;
extern block_t			tempblock;
extern char				tempblock_buffer[MAX_MSGLEN];
extern block_t			prefix;
extern char				prefix_buffer[MAX_SVSLEN];
extern block_t			suffix;
extern char				suffix_buffer[MAX_SVSLEN];

// the "gameversion" client command will print this plus compile date
#define	GAMEVERSION	"q2server"

#define	FRAMETIME		0.1

// memory tags to allow dynamic memory to be cleaned up
#define	TAG_GAME	765		// clear when unloading the dll
#define	TAG_LEVEL	766		// clear when loading a new level

#endif	// __LOCAL_H
