/*
	Relay -- a tool to record and play Quake2 demos
	Copyright (C) 1999 Conor Davis

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	Conor Davis
	cedavis@epid.org
*/

#ifndef	__BLOCK_H
#define	__BLOCK_H

typedef struct
{
	char	*buffer;
	char	*p;
	char	*end;
	int		size;
	int		maxsize;
} block_t;

extern char ReadChar(block_t *src);
extern void WriteChar(block_t *dest, int a);
extern byte ReadByte(block_t *src);
extern void WriteByte(block_t *dest, int a);
extern short ReadShort(block_t *src);
extern void WriteShort(block_t *dest, int a);
extern long ReadLong(block_t *src);
extern void WriteLong(block_t *dest, int a);
extern float ReadFloat(block_t *src);

extern float ReadAngle(block_t *src);
extern void WriteAngle(block_t *dest, float a);
extern float ReadAngle16(block_t *src);
extern void WriteAngle16(block_t *dest, float a);
extern float ReadCoord(block_t *src);
extern void WriteCoord(block_t *dest, float a);
extern float *ReadPosition(block_t *src, float *vec);
extern void WritePosition(block_t *dest, float *vec);
extern short *ReadShortPosition(block_t *src, short *vec);
extern void WriteShortPosition(block_t *dest, short *vec);
extern char *ReadString(block_t *src, char *buffer, int len);
extern void WriteString(block_t *dest, char *buffer);
extern float *ReadDir(block_t *src, float *a);
extern void WriteDir(block_t *dest, float *a);
extern float *ReadBlendVec(block_t *src, float *a);
extern void WriteBlendVec(block_t *dest, float *a);
extern float *ReadOffsetVec(block_t *src, float *a);
extern void WriteOffsetVec(block_t *dest, float *a);

extern char *ReadBin(block_t *src, void *buffer, size_t size);
extern void WriteBin(block_t *dest, void *buffer, size_t size);
extern char *CopyBlock(block_t *dest, block_t *src, size_t size);
extern void ResetBlock(block_t *block);
extern void InitBlock(block_t *block, char *buffer, size_t maxsize);

#endif	// __BLOCK_H