#include "g_local.h"


// help msg
void RailShowCommands (edict_t *player)
{
	gi.centerprintf(player, "---=== RAIL ARENA v%s ===---\n\n"
		"help........... show the scoreboard\n"
		"inven....... 3 Rail Arena champions\n"
		"credits....... who wrote this crap?\n"
		"bonus [x]... trigger bonuses [1-13]\n"
		"cam......... activate ChaseCam mode\n"
		"id........... Zoid's player id mode\n"
		"servcmd..... Ridah's EraserBot help\n"
		" (e.g. bot_num x, skill [0-3])     \n"
		"tips........ Ridah's EraserBot tips\n"
		"\n"
		"mailto:sumfuka@planetquake.com\n"
		, SUM_VERSION);

}


// ROCK
void RailShowCredits (edict_t *player)
{
	// show the FUNKY scoreboard
	player->client->rail_mycredits = true;
	Cmd_Score_f (player);

	// hehe
	if (player->client->showscores)
		qstuffcmd(player, "play gladiator/railgun\n");
}


// tell the player they should use the railgun !
void RailUseRailMsg(edict_t *player)
{

	gi.centerprintf(player, "This is Rail Arena...\n\nUse the RailGun !\n\n(DUH !)");

}


void RailGiveBonus(edict_t *ent, int n)
{
	char msg[500];
	int i;
	edict_t *joe_bloggs;
	gitem_t		*item;
									 
	// no bonus supplied ?
	if (n==0)
		n = rand() % 13 + 1;

	// rrrreeeooooowwwww
	gi.sound(ent, CHAN_ITEM, gi.soundindex("items/damage.wav"), 1, ATTN_NORM, 0);

	// flash for 5 seconds by default
	ent->client->rail_bonus_framenum = level.framenum + 50;
	ent->client->rail_bonus_type = BONUS_NONE;

	// random bonus :
	switch (n)
	{
		case 1:
			// gimme the quad !
			ent->client->quad_framenum = level.framenum + 300;
			sprintf(msg, "%s scored a bonus :\n\nQUAD FURY\n", ent->client->pers.netname);
			break;

		case 2:
			// gimme the quad !
			ent->client->invincible_framenum = level.framenum + 300;
			sprintf(msg, "%s scored a bonus :\n\nINVINCIBLE\n", ent->client->pers.netname);
			break;

		case 3:
			// gimme the triple fire !
			ent->client->rail_bonus_framenum = level.framenum + 300;
			ent->client->rail_bonus_type = BONUS_THREESOME;
			sprintf(msg, "%s scored a bonus :\n\nTHREESOME\n", ent->client->pers.netname);
			break;

		case 4:
			// double the fire rate
			ent->client->rail_bonus_framenum = level.framenum + 300;
			ent->client->rail_bonus_type = BONUS_SPEEED;
			sprintf(msg, "%s scored a bonus :\n\nSPEEED\n", ent->client->pers.netname);
			break;

		case 5:
			// gimme NOTHING.
			sprintf(msg, "%s scored a null bonus...\n\nNO SOUP FOR YOU\n", ent->client->pers.netname);
			break;

		case 6:	
			// get healthy !
			sprintf(msg, "%s scored a bonus :\n\nHEALTHY LIVING\n", ent->client->pers.netname);
			if (ent->health < 200)
				ent->health = 200;	// hehe you're pretty healthy now.

			break;


		case 7:
			// fuck up everyone else
			sprintf(msg, "%s scored a bonus :\n\nHEALTH JINX\n", ent->client->pers.netname);
			// reduce all other players to 1 health.
			for_each_player (joe_bloggs, i)
			{
				if (joe_bloggs != ent)
				{
					if (joe_bloggs->health > 1)
						joe_bloggs->health = 1;	// hehe you're pretty sick now.
				}
			}
			break;

		case 8:
			// get rich !
			sprintf(msg, "%s scored a bonus :\n\n20 FRAGS\n", ent->client->pers.netname);
			ent->client->resp.score += 20;
			break;

		case 9:
			// give em something to play with !

			item = FindItem("Rockets");
			Add_Ammo (ent, item, 15);

			item = FindItem("Rocket Launcher");
			ent->client->pers.inventory[ITEM_INDEX(item)] ++;
			ent->client->newweapon = item;

			sprintf(msg, "%s scored a bonus :\n\nROCKET JOCKEY\n", ent->client->pers.netname);
			break;

		case 10:
			// give em something to play with !

			item = FindItem("Cells");
			Add_Ammo (ent, item, 150);

			item = FindItem("BFG10K");
			ent->client->pers.inventory[ITEM_INDEX(item)] ++;
			ent->client->newweapon = item;

			sprintf(msg, "%s scored a bonus :\n\nBFG WANKER\n", ent->client->pers.netname);
			break;

		case 11:
			// give em something to play with !

			item = FindItem("Shells");
			Add_Ammo (ent, item, 30);

			item = FindItem("Super Shotgun");
			ent->client->pers.inventory[ITEM_INDEX(item)] ++;
			ent->client->newweapon = item;

			sprintf(msg, "%s scored a bonus :\n\nSHOTTY SLUT\n", ent->client->pers.netname);
			break;

		case 12:
			// give em something to play with !

			item = FindItem("Grenades");
			Add_Ammo (ent, item, 15);

			item = FindItem("Grenade Launcher");
			ent->client->pers.inventory[ITEM_INDEX(item)] ++;
			ent->client->newweapon = item;

			sprintf(msg, "%s scored a bonus :\n\nGRENADE SPAMMER\n", ent->client->pers.netname);
			break;

		case 13:
			// Power shield time !

			item = FindItem("Cells");
			Add_Ammo (ent, item, 150);

			item = FindItem("Power Shield");
			ent->client->pers.inventory[ITEM_INDEX(item)] ++;

			// turn it on if not alrady being used
			if ( !(ent->flags & FL_POWER_ARMOR) )
				Use_PowerArmor(ent, item);

			sprintf(msg, "%s scored a bonus :\n\nPOWER SHIELD PANDA\n", ent->client->pers.netname);
			break;


		default :
			// this should never happen
			sprintf(msg, "%s scored a bonus :\n\nERROR\n", ent->client->pers.netname);
			break;
	}

	// tell everyone about it !
	centerprint_all (msg);
}


// does a player have a bonus ?
qboolean RailHasBonus(edict_t *ent, int doihaveit)
{
	return (ent->client->rail_bonus_framenum > level.framenum &&
			ent->client->rail_bonus_type == doihaveit);
}


// register a shot
void RailFire(edict_t *winner)
{
	// one shot...
	winner->client->resp.rail_shots++;
}


// track hits-in-a-row
void RailHit(edict_t *winner, edict_t *loser)
{

	// one more...
	winner->client->pers.rail_count++;
	winner->client->resp.score++;
	winner->client->resp.rail_hits++;

	// calc accuracy now
	if (winner->client->resp.rail_shots >= 10)
	{
		winner->client->resp.rail_accuracy =
			(winner->client->resp.rail_hits * 100) / winner->client->resp.rail_shots;
	}
	else
	{
		winner->client->resp.rail_accuracy = 0;
	}


	// longest streak ?
	if (winner->client->pers.rail_count > winner->client->resp.rail_maxstreak)
		winner->client->resp.rail_maxstreak = winner->client->pers.rail_count;

	// say something...
	if (winner->client->pers.rail_count >= 3)
	{
		// tell all
		gi.bprintf(PRINT_HIGH, "%s scored %d hits in a row.\n",
			winner->client->pers.netname, winner->client->pers.rail_count);
	}
	else
	{
		// tell me
		// NOT A BLOODY BOT ?
		if (winner->bot_stats == NULL)
			gi.cprintf(winner, PRINT_HIGH, "%d...\n", winner->client->pers.rail_count);
	}

	// bonus time !
	if (winner->client->pers.rail_count % 5 == 0)
	{
		RailGiveBonus(winner, 0);
	}
	
}



// we missed, awww....
void RailMiss(edict_t *winner)
{
	// calc accuracy now
	if (winner->client->resp.rail_shots >= 10)
	{
		winner->client->resp.rail_accuracy =
			(winner->client->resp.rail_hits * 100) / winner->client->resp.rail_shots;
	}
	else
	{
		winner->client->resp.rail_accuracy = 0;
	}

	// ended a long streak ?
	if (winner->client->pers.rail_count >= 5)
		gi.bprintf(PRINT_HIGH, "%s's railing streak is over...\n", winner->client->pers.netname);

	// back to square one.
	winner->client->pers.rail_count = 0;
}


void RailStats (edict_t *player)
{
	// no bots !
	if (player->bot_stats) return;

	// Ta da.
	gi.cprintf(player, PRINT_HIGH, "You hit %d opponents from %d slugs.\n",
		player->client->resp.rail_hits, player->client->resp.rail_shots);
}

