#include "g_local.h"


// defines
#define MOTD_MAX 1000
#define MOTD_FRAMES 30

// global variables 
static char motd[MOTD_MAX];


// read motd from \quake2 directory
void ReadMotd()
{
	FILE *motd_file;
	char line[100];
	int motd_len, line_len;

	motd_len = line_len = 0;

	// can we open the motd.txt file ?
	if ((motd_file = fopen("rail\\motd.txt", "r"))
		|| (motd_file = fopen("motd.txt", "r")))
	{
		while ( fgets(line, 80, motd_file) )
		{
			line_len = strlen(line);

			// check the motd doesnt overflow
			if (motd_len + line_len + 1 < MOTD_MAX)
			{
				// concat into one bug motd string
				strcat(motd, line);
				motd_len = strlen(motd);
			}
		}
		// be good now ! ... close the file
		fclose(motd_file);
	}
	else
	{
		// Couldn't open motd file... set a null message
		gi.dprintf("No motd.txt file found.\n");
		motd[0] = '\0';
	}
}


// show the motd for (say) 3 seconds
void CheckShowMotd(edict_t *player)
{

	if (level.framenum - player->client->resp.enterframe <= MOTD_FRAMES &&
		((level.framenum - player->client->resp.enterframe) & 7)==7 &&
		strlen(motd) )
	{
		// print our message.
		gi.centerprintf (player, motd);
	}

}

