/*
Copyright (C) 2000 QuakeWorld Forever.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
/* qwf.c */

#include "quakedef.h"
#include "qwf.h"
#include "GeneratedData.h"

cvar_t       gl_fogenable = {"gl_fogenable", "0"};
cvar_t       gl_fogstart = {"gl_fogstart", "50.0"};
cvar_t       gl_fogend = {"gl_fogend", "1500.0"};
cvar_t       gl_fogdensity = {"gl_fogdensity", "0.8"};
cvar_t       gl_fogred = {"gl_fogred","0.3"};
cvar_t       gl_fogblue = {"gl_fogblue","0.3"};
cvar_t       gl_foggreen = {"gl_foggreen","0.3"};
cvar_t       gl_fogalpha = {"gl_fogalpha", "0.5"};   
cvar_t       oldsky = {"r_oldsky", "1"};
cvar_t       r_drawversion = {"r_drawversion", "1"};
cvar_t       QWF_Reject = {"qwf_reject", "You can download verified QWF Beta3 clients at http://www.qwforever.com/"};

char skybox[30]; // Skybox name

static byte cipher[CIPHER_LEN];	// A temporary place into which to assemble the ciphers.  Using this avoids malloc()s,
CIPHER_HANDLE encrypter;

/* Converts an array into an ascii string which is the hex representation.
   datalen is the length of the array pointed to by data, the result
   will be put into hexstr.  Note that hexstr must be large enough to hold
   the result, namely 2*datalen+1 since each byte needs two hex digits. */
void data2hexstr(char *hexstr, byte *data, int datalen) {
	int i;
	byte c;

	for (i = 0; i < datalen; i++) {
		c = (byte) data[i];
		sprintf(hexstr + 2*i, "%s%X", (c < 0x10) ? "0":"", c);
	}
}

/* Converts an ascii string which is the hex representation of an array back
   into that array.
   strlen is the length of the string pointed to by hexstr, the result
   will be put into data.  Note that data must be large enough to hold
   the result, namely strlen/2+1 since each byte comes from two hex digits. */
void hexstr2data(byte *data, char *hexstr, int slen) {
	char *str;
	int i, j;
	int datalen;
	int val;

	/* slen must be even. */
	if (slen % 2 != 0) {
		return;
	}
	datalen = slen >> 1;	// Divide by 2.

	str = malloc(sizeof(char)*(slen+2));
	strncpy(str, hexstr, slen);
	for (i = slen-2, j = datalen-1; j >= 0; i -= 2, j--) {
		str[i+2] = '\0';
		sscanf(str+i, "%X", &val);
		data[j] = (byte)val;
	}
}


void Con_Printf_hexdata(byte *data, int datalen) {
	char *hexstr;
        return;

	if (NULL == (hexstr = malloc(sizeof(char)*(2*datalen+1)))) {
		return;
	}

	data2hexstr(hexstr, data, datalen);

//        Con_Printf("0x%s\n", hexstr);
}



int openChallengeCipher(CIPHER_HANDLE *c) {
	*c = cipher_open(CIPHER_ALGO_TWOFISH, CIPHER_MODE_ECB, 0);
	if (!*c) {
//                Con_DPrintf("WARNING: Unable to open cipher method.\n");
		return 0; // false
	}
	return 1; // true
}

int closeChallengeCipher(CIPHER_HANDLE *c) {
	cipher_close(*c);
	return 1; // true
}

/* Having setChallengeCipher1 and setChallengeCipher2 separately wouldn't
   normally be good style (coz of the repeated code), but here it adds
   some security.
   Allowing the key to be selected by an if statement or a parameter to
   a function is a bad idea.
*/
int setChallengeCipher1(CIPHER_HANDLE *c) {
	byte *randombits;
	int rc;

	/* Get the cipher, set it, and then clear it.
	   This is safe - gnupg will take a copy of the cipher. */
	getKey(cipher);
	rc = cipher_setkey(*c, cipher, CIPHER_LEN);
	//memset(cipher, 0, CIPHER_LEN);
	randombits = get_random_bits(CIPHER_LEN*8, 1, 0);
	memcpy(cipher, randombits, CIPHER_LEN);
	m_free(randombits);
	if (rc) {
//                Con_DPrintf("WARNING: Unable to set cipher key.\n");
		return 0; // false
	}
	return 1; // true
}

int setChallengeCipher2(CIPHER_HANDLE *c) {
	byte *randombits;
	int rc;

	/* Get the cipher, set it, and then clear it.
	   This is safe - gnupg will take a copy of the cipher. */
	getKey_2(cipher);
	rc = cipher_setkey(*c, cipher, CIPHER_LEN);
	//memset(cipher, 0, CIPHER_LEN);
	randombits = get_random_bits(CIPHER_LEN*8, 1, 0);
	memcpy(cipher, randombits, CIPHER_LEN);
	m_free(randombits);
	if (rc) {
//                Con_DPrintf("WARNING: Unable to set cipher key.\n");
		return 0; // false
	}
	return 1; // true
}

int encryptChallenge(CIPHER_HANDLE *c, byte *encrypted, byte *plain) {
	fflush(stdout);

	cipher_encrypt(*c, encrypted, plain, CHALLENGE_LEN);
	// check for error

	fflush(stdout);

	return 1; // true
}


int decryptChallenge(CIPHER_HANDLE *c, byte *unencrypted, byte *encrypted) {
	fflush(stdout);
	cipher_decrypt(*c, unencrypted, encrypted, CHALLENGE_LEN);
	fflush(stdout);
	return 1; // true
}


void Qwf_CheckProtected(char *cmd) {
 // in this sub i will check for the vshift code and stuff. honest.
 char *pointer;
 if (strlen(cmd)<2) return;   // Ultimate sanity checking.
 pointer = strtok(cmd, " ");
// Con_DPrintf("Protcheck: %s\n", pointer);
 // Parse command
// if strlwr(cmd)
//        cshift_empty.destcolor[0] = atoi(Cmd_Argv(1));
//        cshift_empty.destcolor[1] = atoi(Cmd_Argv(2));
//        cshift_empty.destcolor[2] = atoi(Cmd_Argv(3));
//        cshift_empty.percent = atoi(Cmd_Argv(4));
}

int Qwf_Digest(byte *message, int messagelen, byte **digest) {
	MD_HANDLE md;

	md = md_open(DIGEST_ALGO_MD5, 0);
	if (!md) {
		fprintf(stderr, "hash: Warning: unable to open message digest algo\n");
		return 0;
	}

	md_write(md, message, messagelen);
	md_final(md);
	*digest = md_read(md, DIGEST_ALGO_MD5);
	md_close(md);

	return 1;
}


int hash(char *s, int cp, int size) {
 unsigned int hash=size;
 int i;

 for (i=hash-1;i >= 0;i--)
  hash=13*hash+(int)s[i];

 return hash%cp;
}

void quakelives(char *data, int len)
{
 int l;
 for (l=0;l<len;l++) data[l]^=0x57;
}

void QWF_sinit(void) { // Server startup
 Cvar_RegisterVariable(&QWF_Reject);
}

#ifdef GLQUAKE
void QWF_sky(void) {
 char modname[256];

 strcpy(modname, Cmd_Argv(1));
 if (strlen(modname) < 3) {
  Con_Print("Format: LoadSky <skymap>\n");
  return;
 }
 R_LoadSkys(modname);
 oldsky.value = 0;
}

void QWF_PreRender(void) {    // Called from GL_Rmain.c, before RenderScene
  GLfloat colors[4] = {(GLfloat) gl_fogred.value, (GLfloat) gl_foggreen.value, (GLfloat) gl_fogblue.value, (GLfloat) gl_fogalpha.value};
  if(gl_fogenable.value) {
   glFogi (GL_FOG_MODE, GL_EXP2);
   glFogfv (GL_FOG_COLOR, colors);
   glFogf (GL_FOG_DENSITY, (GLfloat) gl_fogdensity.value / 100); 
   glEnable (GL_FOG);
  }
}

void QWF_PostRender(void) {   // Called from Gl_Rmain.c, after RenderScene
 GLfloat colors[4] = {(GLfloat) gl_fogred.value, (GLfloat) gl_foggreen.value, (GLfloat) gl_fogblue.value, (GLfloat) gl_fogalpha.value};

 R_DrawWaterSurfaces ();

 if (gl_fogenable.value)
  glDisable(GL_FOG);
}

void QWF_R_Init(void) {        // Called from Gl_Rmisc.c, end of R_init
 Cmd_AddCommand("loadsky", QWF_sky);
 Cmd_AddCommand("r_skybox", QWF_sky); // For QL compatability

 Cvar_RegisterVariable (&gl_fogenable);
 Cvar_RegisterVariable (&gl_fogstart);
 Cvar_RegisterVariable (&gl_fogend);
 Cvar_RegisterVariable (&gl_fogdensity);
 Cvar_RegisterVariable (&gl_fogalpha);
 Cvar_RegisterVariable (&gl_fogred);
 Cvar_RegisterVariable (&gl_fogblue);
 Cvar_RegisterVariable (&gl_foggreen); 
 Cvar_RegisterVariable (&oldsky);
}

#endif
