#!/bin/sh

# Outputs the major libc version (ie. 4, 5, 6) the system builds binaries with.
# Copyright 2000 Kevin Pulo.
# This program is covered by the terms and conditions of the GNU GPL.
# Available at: http://www.gnu.org/copyleft/gpl.html

CC=cc
LDD=ldd
GREP=grep
SED=sed

CFLAGS=
LDFLAGS=

LIBCSTR='libc\.so\.'

TMP=/tmp
SRC=$TMP/libctest.c
BIN=$TMP/libctest

echo "main(){}" > $SRC
$CC $CFLAGS $LDFLAGS $SRC -o $BIN

$LDD $BIN | $GREP $LIBCSTR | sed -e "1 s/^[ 	]*$LIBCSTR\([0-9]*\).*$/\1/"

rm $SRC $BIN

