/*
This Program was Lovingly Created by nailbunny (santiago@myempireofdirt.dropbear.id.au)
17/1/2000

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include <stdio.h>
#include "quakedef.h"
#include "crc.h"

/* Doesn't yet take having both libc5/glibc2 binaries into account. */
static char *client_executables[] = { "../qwfcl.exe", "../glqwfcl.exe",
				"../qwfcl.x11", "../qwfcl.svga", "../glqwfcl.glx", "" };

int main(int argc, char **argv)
{
    unsigned long crc=0;
	FILE *out;
	int i, num;

	if(argc < 2) {
		out = fopen("qwfcrc.h", "wb");
		if(!out) return 0;

		fprintf(out, "/*\nGenerated by QuakeWorld Forever Client CRC Generation Program\n%s\n", argv[0]);
		fprintf(out, "*/\n\n");
		num = 0;
		for (i = 0; client_executables[i][0] != '\0'; i++) {
			num++;
		}
		fprintf(out, "#define clientcrcs %d\n\n", num);
		fprintf(out, "static unsigned long clientcrctable[clientcrcs] =\n{\n");
		for (i = 0; client_executables[i][0] != '\0'; i++) {
			fprintf(out, "\t0x%x%s\n", CRC2_File_Check(client_executables[i]), (i < num-1)?",":"");
		}
		fprintf(out, "};\n\n");
		fclose(out);
	} else {
		for (i = 1; i < argc; i++) {
			/* printf("%s\n", argv[i]); */
			crc = CRC2_File_Check(argv[i]);
			/* printf("CRC Decimal:%u Hex: %X\n", crc, crc); */
			printf("0x%X\n", crc);
		}
	}
	return crc;
}

