/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
/* qwf.c */

#include "quakedef.h"
#include "qwf.h"
#include "GeneratedData.h"


/* Converts an array into an ascii string which is the hex representation.
   datalen is the length of the array pointed to by data, the result
   will be put into hexstr.  Note that hexstr must be large enough to hold
   the result, namely 2*datalen+1 since each byte needs two hex digits. */
void data2hexstr(char *hexstr, byte *data, int datalen) {
	int i;
	byte c;

	for (i = 0; i < datalen; i++) {
		c = (byte) data[i];
		sprintf(hexstr + 2*i, "%s%X", (c < 0x10) ? "0":"", c);
	}
}

/* Converts an ascii string which is the hex representation of an array back
   into that array.
   strlen is the length of the string pointed to by hexstr, the result
   will be put into data.  Note that data must be large enough to hold
   the result, namely strlen/2+1 since each byte comes from two hex digits. */
void hexstr2data(byte *data, char *hexstr, int slen) {
	char *str;
	int i, j;
	int datalen;
	int val;

	/* slen must be even. */
	if (slen % 2 != 0) {
		return;
	}
	datalen = slen >> 1;	// Divide by 2.

	str = malloc(sizeof(char)*(slen+2));
	strncpy(str, hexstr, slen);
	for (i = slen-2, j = datalen-1; j >= 0; i -= 2, j--) {
		str[i+2] = '\0';
                //Con_DPrintf("%s ", str+i);
		sscanf(str+i, "%X", &val);
		data[j] = (byte)val;
                //Con_DPrintf("%X ", (byte) data[j]);
	}
        //Con_DPrintf("\n");
}


void Con_Printf_hexdata(byte *data, int datalen) {
	char *hexstr;

	if (NULL == (hexstr = malloc(sizeof(char)*(2*datalen+1)))) {
		return;
	}

	data2hexstr(hexstr, data, datalen);

        Con_DPrintf("0x%s", hexstr);
}



int openChallengeCipher(CIPHER_HANDLE *c) {
        Con_DPrintf("DEBUG: openChallengeCipher()\n");

	*c = cipher_open(CIPHER_ALGO_TWOFISH, CIPHER_MODE_ECB, 0);
	if (!*c) {
                Con_DPrintf("WARNING: Unable to open cipher method.\n");
		return 0; // false
	}
	return 1; // true
}

int closeChallengeCipher(CIPHER_HANDLE *c) {
        Con_DPrintf("DEBUG: closeChallengeCipher()\n");
	cipher_close(*c);
	return 1; // true
}

/* Having setChallengeCipher1 and setChallengeCipher2 separately wouldn't
   normally be good style (coz of the repeated code), but here it adds
   some security.
   Allowing the key to be selected by an if statement or a parameter to
   a function is a bad idea.
*/
int setChallengeCipher1(CIPHER_HANDLE *c) {
	byte *cipher;
	byte *randombits;
	int rc;

        Con_DPrintf("DEBUG: setChallengeCipher()\n");

	/* Get the cipher, set it, and then clear it.
	   This is safe - gnupg will take a copy of the cipher. */
	if (NULL == (cipher = malloc(sizeof(byte)*CIPHER_LEN))) {
                Con_DPrintf("WARNING: Unable to allocate memory for cipher.\n");
		return 0; // false
	}
	getKey(cipher);
	rc = cipher_setkey(*c, cipher, CIPHER_LEN);
	//memset(cipher, 0, CIPHER_LEN);
	randombits = get_random_bits(CIPHER_LEN*8, 1, 0);
	memcpy(cipher, randombits, CIPHER_LEN);
	m_free(randombits);
	free(cipher);
	if (rc) {
                Con_DPrintf("WARNING: Unable to set cipher key.\n");
		return 0; // false
	}
	return 1; // true
}

int setChallengeCipher2(CIPHER_HANDLE *c) {
	byte *cipher;
	byte *randombits;
	int rc;

        Con_DPrintf("DEBUG: setChallengeCipher()\n");

	/* Get the cipher, set it, and then clear it.
	   This is safe - gnupg will take a copy of the cipher. */
	if (NULL == (cipher = malloc(sizeof(byte)*CIPHER_LEN))) {
                Con_DPrintf("WARNING: Unable to allocate memory for cipher.\n");
		return 0; // false
	}
	getKey_2(cipher);
	rc = cipher_setkey(*c, cipher, CIPHER_LEN);
	//memset(cipher, 0, CIPHER_LEN);
	randombits = get_random_bits(CIPHER_LEN*8, 1, 0);
	memcpy(cipher, randombits, CIPHER_LEN);
	m_free(randombits);
	free(cipher);
	if (rc) {
                Con_DPrintf("WARNING: Unable to set cipher key.\n");
		return 0; // false
	}
	return 1; // true
}

int encryptChallenge(CIPHER_HANDLE *c, byte *encrypted, byte *plain) {
        Con_DPrintf("DEBUG: encryptChallenge()\n");
        Con_DPrintf("DEBUG: plain = ");
        Con_Printf_hexdata(plain, CHALLENGE_LEN);
        Con_DPrintf("\n");
	fflush(stdout);

	cipher_encrypt(*c, encrypted, plain, CHALLENGE_LEN);
	// check for error

        Con_DPrintf("DEBUG: encrypted = ");
        Con_Printf_hexdata(encrypted, CHALLENGE_LEN);
        Con_DPrintf("\n");
	fflush(stdout);

	return 1; // true
}


int decryptChallenge(CIPHER_HANDLE *c, byte *unencrypted, byte *encrypted) {
        Con_DPrintf("DEBUG: decryptChallenge()\n");
        Con_DPrintf("DEBUG: encrypted = ");
        Con_Printf_hexdata(encrypted, CHALLENGE_LEN);
        Con_DPrintf("\n");
	fflush(stdout);

	cipher_decrypt(*c, unencrypted, encrypted, CHALLENGE_LEN);
	// check for error

        Con_DPrintf("DEBUG: unencrypted = ");
        Con_Printf_hexdata(unencrypted, CHALLENGE_LEN);
        Con_DPrintf("\n");
	fflush(stdout);

	return 1; // true
}


void Qwf_CheckProtected(char *cmd) {
 // in this sub i will check for the vshift code and stuff. honest.
 char *pointer;
 pointer = strtok(cmd, " ");
 Con_DPrintf("Protcheck: %s\n", pointer);
 // Parse command
// if strlwr(cmd)
//        cshift_empty.destcolor[0] = atoi(Cmd_Argv(1));
//        cshift_empty.destcolor[1] = atoi(Cmd_Argv(2));
//        cshift_empty.destcolor[2] = atoi(Cmd_Argv(3));
//        cshift_empty.percent = atoi(Cmd_Argv(4));
}
