
#include <stdio.h>
#include <windows.h>
#include "cmdlib.h"
#include "dyna1.h"




#define DYNARRAY_INCREMENT_MIN    8192
#define DYNARRAY_INITIAL_MAX      4096



int total_used_memory;


void VirtualCommit(void *data, int size)
{
  void *result = VirtualAlloc(data, size, MEM_COMMIT, PAGE_READWRITE);
  if (!result)
    Error ("Sorry, I'm running out of memory...");
  if (result != data)
    Error ("VirtualAlloc : consistency error");
}


void *SetupDynArray(int base, int max, char *name)
{
  int i;
  arrayheader_t *data = (arrayheader_t*)VirtualAlloc(NULL, headersize+base*max, MEM_RESERVE, PAGE_READWRITE);
  //printf ("SetupDynArray %d %d %s\n", base, max, name);
  if (!data)
  {
    printf ("Cannot start the program - not enough memory addresses in the process !\n");
    exit(1);
  }
  VirtualCommit(data, DYNARRAY_INITIAL_MAX);
  data->count = (DYNARRAY_INITIAL_MAX-headersize) / base;
  data->base_size = base;
  data->max_count = max;
  data->max_name = name;
  for (i=0; (base<<i) < DYNARRAY_INCREMENT_MIN; i++);
  data->incr_mask = 1<<i;
  return headersize+(char*)data;
}


void ExtendDynArray(arrayheader_t *data, int ncount)
{
  int old_total_used_memory = total_used_memory;

  //printf ("ExtendDynArray %d %s... ", ncount, data->max_name);
  ncount = (ncount+data->incr_mask) & ~(data->incr_mask-1);
  if (ncount > data->max_count) ncount = data->max_count;
  if (ncount <= data->count)
    Error ("Reached the limit %s (%d), cannot continue...", data->max_name, data->max_count);
  VirtualCommit(data, headersize+data->base_size*ncount);
  total_used_memory += data->base_size*(ncount-data->count);
  if ((total_used_memory>>20) != (old_total_used_memory>>20))
    printf ("\n                                                    (BSP data size: %d MB)\n",
            total_used_memory>>20);
  data->count = ncount;
  //printf ("%d Ok\n", ncount);
}


void ClearArray(void *array)
{
  arrayheader_t header;
  arrayheader_t *data = (arrayheader_t*)((byte*)array-headersize);
  //printf ("ClearArray %s\n", data->max_name);
  if (data->count)
  {
    memcpy(&header, data, sizeof(arrayheader_t));
    VirtualFree(data, data->base_size*data->count, MEM_DECOMMIT);
    VirtualCommit(data, DYNARRAY_INITIAL_MAX);
    header.count = (DYNARRAY_INITIAL_MAX-headersize) / header.base_size;
    memcpy(data, &header, sizeof(arrayheader_t));
  }
}

#ifndef _MSC_VER
inline 
#endif
void ExtendArray(void *array, int ncount)
{
  arrayheader_t *data = (arrayheader_t*)((byte*)array-headersize);
  if (data->count <= ncount)
    ExtendDynArray(data, ncount);
}

void NeedArrayBytes(void *array, int size)
{
  arrayheader_t *data = (arrayheader_t*)((byte*)array-headersize);
  if (size)
    ExtendArray(array, (size-1) / data->base_size);
}

