(**************************************************************************
QuArK -- Quake Army Knife -- 3D game editor
Copyright (C) 1996-99 Armin Rigo

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author Armin Rigo by e-mail: arigo@planetquake.com
or by mail: Armin Rigo, La Cure, 1854 Leysin, Switzerland.
See also http://www.planetquake.com/quark
**************************************************************************)

unit ObjProp;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  QkForm, TB97, StdCtrls, ExtCtrls, QkObjects, QkFileObjects;

type
  TFormObjProp = class(TQkForm)
    Image1: TImage;
    Bevel1: TBevel;
    Label1: TLabel;
    Bevel2: TBevel;
    Label2: TLabel;
    Label3: TLabel;
    Bevel3: TBevel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    ListBox1: TListBox;
    PasteBtn: TToolbarButton97;
    OkBtn: TToolbarButton97;
    SaveBtn: TToolbarButton97;
    Button1: TButton;
    Button2: TButton;
    procedure FormCreate(Sender: TObject);
    procedure OkBtnClick(Sender: TObject);
    procedure PasteBtnClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SaveBtnClick(Sender: TObject);
  private
    Q: QObject;
    PasteTo: TQkForm;
  public
  end;

 {------------------------}

procedure ObjectProperties(nQ: QObject; nPasteTo: TQkForm);

 {------------------------}

implementation

uses Qk1, QkGroup, Quarkx, PyImages, Python;

{$R *.DFM}

 {------------------------}

procedure ObjectProperties(nQ: QObject; nPasteTo: TQkForm);
var
 FormObjProp: TFormObjProp;
 I, Chk: Integer;
 ConvertClass: QFileObjectClass;
 Info: TFileObjectClassInfo;
 E: TDisplayDetails;
 Sz: TPoint;
begin
 FormObjProp:=TFormObjProp.Create(Application);
 with FormObjProp do
  begin
   nQ.DisplayDetails(True, E);
   if E.Icon<>Nil then
    try
     Sz:=PyImage1(E.Icon)^.GetSize;
     Image1.Picture.Bitmap.Width:=Sz.X;
     Image1.Picture.Bitmap.Height:=Sz.Y;
     with Image1.Picture.Bitmap.Canvas do
      begin
      {Brush.Color:=clBtnFace;
       FillRect(Rect(0,0, Sz.X, Sz.Y));}
       PyImage1(E.Icon)^.Draw(Handle, 0,0, ColorToRGB(clBtnFace));
      end;
    finally
     Py_DECREF(E.Icon);
    end;
   Label1.Caption:=nQ.Name;
   Label5.Caption:=FmtLoadStr1(5392, [(nQ.GetObjectSize(Nil, False)+512) div 1024]);
   SaveBtn.Enabled:=nQ is QFileObject;
   if nQ is QFileObject then
    begin
     QFileObject(nQ).FileObjectClassInfo(Info);
     Label4.Caption:=Info.NomClasseEnClair + '   ';
     Chk:=-1;
     I:=1;
     repeat
      ConvertClass:=QFileObject(nQ).TestConversionType(I);
      if ConvertClass=Nil then Break;
      ConvertClass.FileObjectClassInfo(Info);
      ListBox1.Items.Add(Info.NomClasseEnClair);
      if ConvertClass=nQ.ClassType then
       Chk:=I-1;
      Inc(I);
     until False;
     ListBox1.ItemIndex:=Chk;
    end;
   Label4.Caption:=Label4.Caption+'[ '+nQ.TypeInfo+' ]';
   if ListBox1.Items.Count=0 then
    begin
     Label6.Font.Color:=clGrayText;
     ListBox1.Color:=clBtnFace;
     ListBox1.Enabled:=False;
    end;
  {ListBox1Click(Nil);}
   Q:=nQ;
   Q.AddRef(+1);
   if Assigned(nPasteTo) then
    begin
     PasteTo:=nPasteTo;
     PasteBtn.Caption:=LoadStr1(5393);
     Caption:=LoadStr1(5396);

     Chk:=nPasteTo.ProcessEditMsg(edEdEnable);
     PasteBtn.Enabled:=Chk and edPasteObj = edPasteObj;
    end;
   Show;
  end;
end;

 {------------------------}

procedure TFormObjProp.FormCreate(Sender: TObject);
begin
 MarsCap.ActiveBeginColor:=clGreen;
 MarsCap.ActiveEndColor:=clTeal;
 UpdateMarsCap;
{SetFormIcon(}
end;

procedure TFormObjProp.OkBtnClick(Sender: TObject);
begin
 Close;
end;

procedure TFormObjProp.PasteBtnClick(Sender: TObject);
var
 Gr: QExplorerGroup;
 ConvertClass: QFileObjectClass;
begin
 Gr:=ClipboardGroup;
 Gr.AddRef(+1); try
 if ListBox1.ItemIndex>=0 then
  begin
   ConvertClass:=(Q as QFileObject).TestConversionType(ListBox1.ItemIndex+1);
   if ConvertClass=Nil then
    begin
     MessageBeep(0);
     Exit;
    end;
   Gr.SousElements.Add(ConvertClass.Create(Q.Name, Gr));
   if not QFileObject(Gr.SousElements[0]).ConversionFrom(QFileObject(Q)) then
    Raise EError(5538);
  end
 else
  Gr.SousElements.Add(Q);

  { copy to clipboard }
 Gr.CopierObjets(False);
 finally Gr.AddRef(-1); end;

 if PasteTo<>Nil then
  begin   { paste }
   ActivateNow(PasteTo);
   PasteTo.ProcessEditMsg(edPasteObj);
   Close;
  end;
end;

procedure TFormObjProp.FormDestroy(Sender: TObject);
begin
 Q.AddRef(-1);
end;

{procedure TFormObjProp.ListBox1Click(Sender: TObject);
begin
 PasteBtn.Enabled:=ListBox1.ItemIndex>=0;
end;}

procedure TFormObjProp.SaveBtnClick(Sender: TObject);
begin
 SaveObject(Q as QFileObject, fm_SaveAsFile, ListBox1.ItemIndex+1, Nil)
  .AddRef(-1);
end;

end.
