unit QMPak;

interface

uses Objects, Strings, QkUI;

const
 SignaturePACK = $4B434150;
 SignatureQuArKPAK1 = $51202F2F;
 SignatureQuArKPAK2 = $4B724175;

 ProgsDatSignature  = 6;
 ProgsDatFichier    = $3A435253;
 ProgsDatSourceDir  = $3A524944;
 ProgsDatDefault    = $2E464544;

type
 TIntroPak = record
              Signature : Longint;
              Position, NbEntrees : Longint;
             end;

var
 QuakeDir: String;
 SourceDir, GameDir, CmdLine1, PackFile: String;
 Impulse0: LongInt;
 TmpBspFiles: Integer;
{ImageBin: Pointer;
 ImageBinSize: Integer;}

procedure LoadQuakeDir(const SetTo: String);
function OpenQuakeEntry(const Name, FirstSource: String; var Fr: PStream) : LongInt;
function OutputFile(Path: String) : String;
procedure InitQContext{(const Entry: String)};
procedure Add2Pack;
function ExtractPath(const S: String) : Integer;
procedure DOSFileName(var S: OpenString);
function UniqueFile(const Path, S, Ext: String) : String;

implementation

uses QMObj, Textures, QPAcc, QkQme;

const
 TailleNomFich = 56;

type
 PEntreePak = ^TEntreePak;
 TEntreePak = record
               NomFich : array[0..TailleNomFich-1] of Byte;
               Position, Taille : Longint;
              end;

{var
 FInitOk: Boolean;
 FSearchEntry: PString;}

function ScanPak(const NomFich, Nom: String; var Fr: PStream) : Boolean;
var
 F: PBufStream;
 Intro: TIntroPak;
 I: Integer;
 Entree: TEntreePak;
begin
 ScanPak:=False;
 New(F, Init(NomFich, stOpenRead, 1024));
 F^.Read(Intro, SizeOf(Intro));
 if (F^.Status<>stOk) or (Intro.Signature<>SignaturePACK) then
  begin
   Dispose(F, Done);
   Exit;
  end;
 Intro.NbEntrees:=Intro.NbEntrees div SizeOf(TEntreePak);
 F^.Seek(Intro.Position);
 for I:=1 to Intro.NbEntrees do
  begin
   F^.Read(Entree, SizeOf(Entree));
   if CompareText(CharToPas(Entree.NomFich), Nom) = 0 then
    begin
     F^.Seek(Entree.Position);
     Fr:=F;
     ScanPak:=True;
     Exit;
    end;
  end;
 Dispose(F, Done);
end;

function OpenQuakeEntry(const Name, FirstSource: String; var Fr: PStream) : LongInt;

  procedure LookInto(const Rep: String);
  var
   I, J: Integer;
   Test: String;
   F: PBufStream;
   IntroEx: record
             Intro: TIntroPak;
             S1, S2: LongInt;
            end;
   PakDir, P: PEntreePak;
  begin
   J:=0;
   Test:=QuakeDir+'\'+Rep+'\PAK';
   while FileExists(Test+IntToStr(J)+'.PAK') do
    Inc(J);
   while J>0 do
    begin
     Dec(J);
     Test:=QuakeDir+'\'+Rep+'\PAK'+IntToStr(J)+'.PAK';
     New(F, Init(Test, stOpenRead, 512));
     F^.Read(IntroEx, SizeOf(IntroEx));
     if (F^.Status<>stOk)
     or (IntroEx.Intro.Signature<>SignaturePACK)
     or ((IntroEx.S1=SignatureQuArKPAK1) and (IntroEx.S2=SignatureQuArKPAK2)) then
      {don't use this file}
     else
      with IntroEx do
       begin
        F^.Seek(Intro.Position);
        GetMem(PakDir, Intro.NbEntrees);
        F^.Read(PakDir^, Intro.NbEntrees);
        P:=PakDir;
        I:=Intro.NbEntrees div SizeOf(TEntreePak);
        while (I>0) and (CompareText(CharToPas(P^.NomFich), Name)<>0) do
         begin
          Inc(P);
          Dec(I);
         end;
        if I>0 then
         begin
          F^.Seek(P^.Position);
          OpenQuakeEntry:=P^.Taille;
          Fr:=F;
         end;
        FreeMem(PakDir, Intro.NbEntrees);
        if I>0 then Exit;
       end;
     Dispose(F, Done);
    end;
   Test:=QuakeDir+'\'+Rep+'\'+Name;
   while Pos('/', Test)<>0 do
    Test[Pos('/', Test)]:='\';
   if FileExists(Test) then
    begin
     Fr:=New(PBufStream, Init(Test, stOpenRead, 512));
     OpenQuakeEntry:=Fr^.GetSize;
    end;
  end;

begin
{if not FInitOk then
  InitQContext('');}
 Fr:=Nil;
 if FirstSource='' then
  begin
   if (SourceDir<>'') and (CompareText(SourceDir, 'Id1')<>0) then
    LookInto(SourceDir);
   if Fr=Nil then
    LookInto('Id1');
  end
 else
  LookInto(FirstSource);
 if Fr=Nil then
  Error('Quake file not found: '+Name);
end;

function OutputFile;
var
 P, I: Integer;
 Result: String;
begin
 if Pos('..', Path)<>0 then
  Error('Security check : ".." not allowed in '+Path);
 Result:=QuakeDir+'\tmpQuArK\'+Path;
 P:=Length(QuakeDir)+1;
 repeat
  Inc(P);
  if Result[P]='/' then
   Result[P]:='\';
  if Result[P]='\' then
   begin
    {$I-}
    MkDir(Copy(Result, 1, P-1));
    {$I+}
    I:=IOResult;
   end;
 until P=Length(Result);
 OutputFile:=Result;
end;

PROCEDURE LoadQuakeDir(const SetTo: String);

VAR
 Fich    : TEXT;
 Line,L2 : STRING;
 Modify  : BOOLEAN;
 I       : INTEGER;
 Temp    : TStringCollection;

BEGIN
 ASSIGN(Fich, 'QKDOSRT.TEX');
 {$I-}
 RESET(Fich);
 {$I+}
 IF IOResult<>0 THEN
  Error('File not found : QKDOSRT.TEX. Reinstall this program.');
 READLN(Fich, QuakeDir);
 Modify:=(SetTo<>'') AND (SetTo<>QuakeDir);
 IF Modify THEN
  QuakeDir:=SetTo;
 REPEAT
  IF (QuakeDir='') AND (QuakeDir[Length(QuakeDir)]='\') THEN
   Dec(Byte(QuakeDir[0]));
  IF FileExists(QuakeDir+'\QUAKE.EXE') THEN
   Break;
  IF Modify THEN
   BEGIN
    Line:=' Wrong input. File not found :';
    L2:='  '+QuakeDir+'\QUAKE.EXE'
   END
  ELSE
   BEGIN
    Modify:=True;
    Line:=' Where is Quake ?';
    L2:=' Please enter the path of program QUAKE.EXE.';
   END;
  if not Prompt(Line, L2, QuakeDir) then Halt(2);
 UNTIL False;
 IF Modify THEN
  BEGIN
   Temp.Init(128,128);
   WHILE NOT EOF(Fich) DO
    BEGIN
     READLN(Fich, Line);
     Temp.AtInsert(Temp.Count, NewStr(Line));
    END;
   CLOSE(Fich);
   REWRITE(Fich);
   WRITELN(Fich, QuakeDir);
   FOR I:=0 TO Temp.Count-1 DO
    WRITELN(Fich, PString(Temp.At(I))^);
   CLOSE(Fich);
   Temp.Done;
  END;
END;

procedure QContextProcess(const FileName: String; var Entree: TEntreeRepQM);
far;
var
 S,nNom: String;
 I: Integer;
 L: LongInt;
 Buffer, P: PChar;
 EnteteBsp: TEnteteBsp;
 EnteteTex: TEnteteTex;
 F: PStream;
begin
 if Entree.InfoType = qmQContext then
  begin
   S:=NXFString(Entree, 'GameDir');
   if S<>'' then
    GameDir:=S;
   S:=NXFString(Entree, 'SourceDir');
   if S<>'' then
    SourceDir:=S;
   S:=NXFString(Entree, 'CmdLine');
   if S<>'' then
    CmdLine1:=CmdLine1 + S + ' ';
   if OpenNXFEntry(Entree, 'Impulse0')>=SizeOf(Impulse0) then
    SourceFile^.Read(Impulse0, SizeOf(Impulse0));
  {if FSearchEntry^<>'' then
    begin
     I:=OpenNXFEntry(Entree, FSearchEntry^);
     if I>=0 then
      begin
       if ImageBin<>Nil then
        FreeMem(ImageBin, ImageBinSize);
       ImageBinSize:=I;
       GetMem(ImageBin, ImageBinSize);
       SourceFile^.Read(ImageBin^, ImageBinSize);
      end;
    end;}
   I:=0;
   repeat
    nNom:=#255;
    L:=SearchDdEntry(Entree, nNom, I);   { texture entries }
    if L<0 then Break;
    if L>=65520 then Error('Too many texture links');
    Inc(I);
    GetMem(Buffer, L+1);
    SourceFile^.Read(Buffer^, L);
    Buffer[L]:=#0;
    P:=Buffer;
    while P^<>#0 do
     begin
      S[0]:=#0;
      while not (P^ in [#0,#10,#13]) do
       begin
        Inc(Byte(S[0]));
        S[Length(S)]:=P^;
        Inc(P);
       end;
      LowerCase(S);
      AllTextures^.AtInsert(AllTextures^.Count, NewStr(S+#13+SourceDir));
      while P^ in [#13,#10] do
       Inc(P);
     end;
    FreeMem(Buffer, L+1);
   until False;
  end
 else
  if Entree.InfoType = qmTextureDef then
   begin
    S:='tmp~qk'+IntToStr(TmpBspFiles);
    Inc(TmpBspFiles);
    EnteteBsp.Signature:=SignatureBSP_private;
    EnteteBsp.Entrees[eMipTex].Position:=SizeOf(EnteteBsp);
    EnteteBsp.Entrees[eMipTex].Taille:=OpenNXFEntry(Entree, 'Data');
    F:=New(PDosStream, Init(OutputFile('maps/'+S+'.bsp'), stCreate));
    F^.Write(EnteteBsp, SizeOf(EnteteBsp));
    F^.CopyFrom(SourceFile^, EnteteBsp.Entrees[eMipTex].Taille);
    F^.Seek(SizeOf(EnteteBsp));
    F^.Read(L, 4);
    for I:=1 to L do
     begin
      F^.Seek(SizeOf(EnteteBsp)+I*4);
      F^.Read(L, 4);
      if L>0 then
       begin
        F^.Seek(SizeOf(EnteteBsp)+L);
        F^.Read(EnteteTex, SizeOf(EnteteTex));
        nNom:=CharToPas(EnteteTex.Nom);
        LowerCase(nNom);
        AllTextures^.AtInsert(AllTextures^.Count,
         NewStr(nNom+'='+S+#13'tmpQuArK'));
       end;
     end;
    Dispose(F, Done);
   end;
end;

procedure InitQContext{(const Entry: String)};
var
 Fich: Text;
 Line: String;
 I: Integer;
begin
 New(AllTextures, Init(640,128));
 Assign(Fich, 'QKDOSRT.TEX');
 Reset(Fich);
 Readln(Fich, Line);
 while not Eof(Fich) do
  begin
   Readln(Fich, Line);
   if Line<>'' then
    AllTextures^.AtInsert(AllTextures^.Count, NewStr(Line+#13'Id1'));
  end;
 Close(Fich);
 TmpBspFiles:=0;
{FSearchEntry:=@Entry;}
 Impulse0:=Impulse0Def;
 SourceDir:='';
 GameDir:='';
 CmdLine1:='';
 ProcessQuArKFiles(QContextProcess, False);
{FInitOk:=True;}
end;

procedure Add2Pack;
type
 PRepertoire = ^TRepertoire;
 TRepertoire = array[0..99] of TEntreePak;
var
 Intro0, nIntro: TIntroPak;
 Pak, Source: File;
 Taille, SizeOfDir: Word;
 Entrees0: PRepertoire;
 Chaine: array[0..263] of Char;
 I, J, K, Ancien: Integer;
 nAncien: Boolean;
 P: PEntreePak;
 Tampon: array[0..511] of Byte;
 PosSource, AnciennePosition, Delta: LongInt;
 PC, Nom: PChar;

  function ChercherFin : LongInt;
  var
   Fin, Test: LongInt;
   P: PEntreePak;
   I: Integer;
  begin
   Fin:=SizeOf(TIntroPak);
   P:=PEntreePak(Entrees0);
   for I:=0 to Intro0.NbEntrees-1 do
    begin
     Test:=P^.Position + P^.Taille;
     if Test>Fin then
      Fin:=Test;
     Inc(P);
    end;
   ChercherFin:=(Fin+3) and not 3;
  end;

  procedure Ecrire(var Fichier: File; var Tampon; Taille: Integer);
  var
   Resultat: Word;
  begin
   BlockWrite(Fichier, Tampon, Taille, Resultat);
   if Resultat<>Taille then Error('file write error (disk full ?)');
  end;

begin
 Assign(Pak, ParamStr(2));
 {$I-} Reset(Pak,1); {$I+}
 if IOResult<>0 then
  begin
   WriteLn('Creating: ', ParamStr(2));
   Rewrite(Pak,1);  { create file }
   Intro0.Signature:=SignaturePACK;
   Intro0.Position:=SizeOf(Intro0);
   Intro0.NbEntrees:=0;
   BlockWrite(Pak, Intro0, SizeOf(Intro0));
  end
 else
  begin
   WriteLn('Updating: ', ParamStr(2));
   BlockRead(Pak, Intro0, SizeOf(Intro0), Taille);
   if (Taille<>SizeOf(Intro0)) or (Intro0.Signature<>SignaturePACK) then
    Error('not a PACK file');
  end;
 Seek(Pak, Intro0.Position);
 SizeOfDir:=Intro0.NbEntrees+ParamCount*SizeOf(TEntreePak);
 GetMem(Entrees0, SizeOfDir);
 BlockRead(Pak, Entrees0^, Intro0.NbEntrees, Taille);
 if Taille<>Intro0.NbEntrees then
  Error('file format error');
 Intro0.NbEntrees:=Intro0.NbEntrees div SizeOf(TEntreePak);
 Seek(Pak, 0);
 FillChar(nIntro, SizeOf(nIntro), 0);
 Ecrire(Pak, nIntro, SizeOf(nIntro));
 for J:=3 to ParamCount do
  begin
   PC:=StrPCopy(Chaine, ParamStr(J));
   repeat
    case PC^ of
     #0: Break;
     '\': PC^:='/';
     'A'..'Z': Inc(Byte(PC^), 32);
    end;
    Inc(PC);
    if PC-Chaine=TailleNomFich then Error('file path and name too long (max. 56 characters)');
   until False;
   Ancien:=-1;
   P:=PEntreePak(Entrees0);
   for I:=0 to Intro0.NbEntrees-1 do
    begin
     PC:=Chaine;
     Nom:=PChar(P);
     for K:=1 to TailleNomFich do
      begin
       nAncien:=Upcase(PC^)=Upcase(Nom^);
       if not nAncien or (PC^=#0) then Break;
       Inc(PC);
       Inc(Nom);
      end;
     if nAncien then
      Ancien:=I;
     Inc(P);
    end;
   if Ancien>=0 then
    begin
     WriteLn('removing: ', Chaine);
     with Entrees0^[Ancien] do
      begin
       PosSource:=Position;
       AnciennePosition:=Position;
       Delta:=Taille;
      end;
     repeat
      Seek(Pak, PosSource+Delta);
      BlockRead(Pak, Tampon, SizeOf(Tampon), Taille);
      Seek(Pak, PosSource);
      Ecrire(Pak, Tampon, Taille);
      Inc(PosSource, SizeOf(Tampon));
     until Taille<>SizeOf(Tampon);
     Dec(Intro0.NbEntrees);
     Move(Entrees0^[Ancien+1], Entrees0^[Ancien], (Intro0.NbEntrees-Ancien)*SizeOf(TEntreePak));
     P:=PEntreePak(Entrees0);
     for I:=0 to Intro0.NbEntrees-1 do
      begin
       if P^.Position > AnciennePosition then
        Dec(P^.Position, Delta);
       Inc(P);
      end;
    end;
   with Entrees0^[Intro0.NbEntrees] do
    begin
     FillChar(NomFich, SizeOf(NomFich), 0);
     Move(Chaine, NomFich, StrLen(Chaine));
    end;
   Assign(Source, ParamStr(J));
   {$I-} Reset(Source,1); {$I+}
   if IOResult=0 then
    begin
     WriteLn('  adding: ', Chaine);
     PosSource:=ChercherFin;
     Seek(Pak, PosSource);
     Delta:=0;
     repeat
      BlockRead(Source, Tampon, SizeOf(Tampon), Taille);
      Ecrire(Pak, Tampon, Taille);
      Inc(Delta, Taille);
     until Taille<>SizeOf(Tampon);
     Close(Source);
     with Entrees0^[Intro0.NbEntrees] do
      begin
       Position:=PosSource;
       Taille:=Delta;
      end;
     Inc(Intro0.NbEntrees);
    end;
  end;
 Intro0.Position:=ChercherFin;
 Intro0.NbEntrees:=Intro0.NbEntrees*SizeOf(TEntreePak);
 Seek(Pak, Intro0.Position);
 Ecrire(Pak, Entrees0^, Intro0.NbEntrees);
 FreeMem(Entrees0, SizeOfDir);
 Truncate(Pak);
 Seek(Pak, 0);
 Ecrire(Pak, Intro0, SizeOf(Intro0));
 Close(Pak);
end;

function ExtractPath(const S: String) : Integer;
var
 Result: Integer;
begin
 Result:=Length(S);
 while (Result>0) and (S[Result]<>'\') do
  Dec(Result);
 ExtractPath:=Result;
end;

procedure DOSFileName(var S: OpenString);
var
 I,J: Integer;
begin
 J:=0;
 for I:=1 to Length(S) do
  if S[I] in ['a'..'z', 'A'..'Z', '0'..'9', '_'] then
   begin
    Inc(J);
    S[J]:=S[I];
    if J=8 then Break;
   end;
 S[0]:=Chr(J);
end;

function UniqueFile(const Path, S, Ext: String) : String;
var
 I: Integer;
 S1, Result: String[15];
begin
 Result:=S;
 DOSFileName(Result);
 I:=1;
 while FileExists(Path+Result+Ext) do
  begin
   Inc(I);
   Str(I,S1);
   Result:=Copy(S,1,8-Length(S1))+S1;
  end;
 UniqueFile:=Result;
end;

BEGIN
 QuakeDir:='';
{SourceDir:='';
 GameDir:='';
 FInitOk:=False;}
END.