unit QMObj;
{$N+}

interface

uses qmath, Objects, Strings, QkUI;

const
 SignatureQM = $50414D51;
 qmDescription = 0;
 qmCarte       = 1;
 qmPatchQC     = 2;
 qmBSP0        = 3;
 qmTextureDef  = 4;
 qmFileDef     = 5;
 qmQContext    = 6;
 qmFileLnk     = 7;
 qmModel       = 8;

 mapEntity     = 0;
 mapBrush      = 1;
 mapPoly       = 2;
 mapGroup      = 3;
 mapDuplicator = 4;

 MaxNomEntreeQM = 52;
 TailleNomTex   = 24;

 VersionNXF    = 3;

 NomWadTmp     = 'gfx/QuArK.wad';
 NomMapDefaut  = 'NoName';

type
 TIntroQM = record
             Signature : LongInt;
             PositionRep, TailleRep: LongInt;
            end;
 PEntreeRepQM = ^TEntreeRepQM;
 TEntreeRepQM = record
                 Nom: array[0..MaxNomEntreeQM-1] of Byte;
                 InfoType, Version: Word;
                 Position1, Taille: LongInt;
                end;
 PRepertoireQM = ^TRepertoireQM;
 TRepertoireQM = array[0..0] of TEntreeRepQM;
 PEnteteNXF = ^TEnteteNXF;
 TEnteteNXF = record
               Taille: LongInt;
               TailleId: Word;
               Reserve: Byte;
               Format: Byte;
              end;
 TNomTex  = String[TailleNomTex-1];
 PSurface = ^TSurface;
 TSurface = record
             Normale: TVect;
             Dist: Reel;
             Params: array[1..5] of Reel;
             NomTex: TNomTex;
            end;

const
 TailleSurfDef  = SizeOf(TVect)+6*SizeOf(Reel);
 TailleSurfPlan = SizeOf(TVect)+SizeOf(Reel);
 TailleSurfParm = TailleSurfDef - TailleSurfPlan;
 TailleSurfVis  = TailleSurfParm + TailleNomTex;

type
 PTransfertTreeMap = ^TTransfertTreeMap;
 TTransfertTreeMap = record
                      Tampon: array[0..31, 0..TailleSurfVis-1] of Byte;
                      PositionTampon: Integer;
                     end;

var
 SourceFile: PStream;
 TexturesUtilisees: PStringCollection;

function CharToPas(C: array of Byte) : String;
procedure PasToChar(var C: array of Byte; const S: String);
procedure ExtraireMap(var Entree: TEntreeRepQM; const NomFich: String);
function OpenNXFEntry(const Entree: TEntreeRepQM; EntryId: String) : LongInt;
procedure ReadNXFEntry(const Entree: TEntreeRepQM; const EntryId: String);
function ReadFileName(const Entree: TEntreeRepQM) : String;
function NXFString(const Entree: TEntreeRepQM; const EntryId: String) : String;
function SearchDdEntry(const Entree: TEntreeRepQM; var EntryId: String; Index: Integer) : LongInt;

 (************************************************************)

implementation

uses QMPak;

 (************************************************************)

var
 TTF: PTransfertTreeMap;

procedure TreeMapEntity(var Source: TStream; Dest, Brush: PStream; ParentPos: LongInt; Transf: PTransformation);
far; forward;

procedure TreeMapGroup(var Source: TStream; Dest, Brush: PStream; ParentPos: LongInt; Transf: PTransformation);
far; forward;

procedure TreeMapBrush(var Source: TStream; Dest, Brush: PStream; ParentPos: LongInt; Transf: PTransformation);
far; forward;

procedure TreeMapPolyhedron(var Source: TStream; Dest, Brush: PStream; ParentPos: LongInt; Transf: PTransformation);
far; forward;

procedure TreeMapDuplicator(var Source: TStream; Dest, Brush: PStream; ParentPos: LongInt; Transf: PTransformation);
far; forward;

 {----------------------}

const
 TreeMapObj : array[mapEntity..mapDuplicator] of
               procedure(var Source: TStream; Dest, Brush: PStream; ParentPos: LongInt; Transf: PTransformation) =
  (TreeMapEntity, TreeMapBrush, TreeMapPolyhedron, TreeMapGroup, TreeMapDuplicator);

 {----------------------}

var
 RemplaceWad: Boolean;

procedure SauverSpec(var Source: TStream; Dest: PStream; Transf: PTransformation);
var
 Taille: Word;
 Tampon, P: PChar;
 Chaine: String;
 J: Integer;
 F: PTransformation;
 Origin: TVect;
begin
 Source.Read(Taille, SizeOf(Taille));
 GetMem(Tampon, Taille);
 Source.Read(Tampon^, Taille);
 if Dest<>Nil then
  begin
   Chaine:='{'#13#10;
   Dest^.Write(Chaine[1], 3);
   P:=Tampon;
   Chaine:=' "';
   J:=Taille;
   repeat
    while J>0 do
     begin
      case P^ of
       #13, #10 : Chaine:=' "';
       '='      : Break;
       else Chaine:=Chaine+P^;
      end;
      Dec(J);
      Inc(P);
     end;
    if J=0 then Break;
    Chaine:=Chaine+'" "';
    Dec(J);
    Inc(P);
    while (J>0) and not (P^ in [#13, #10]) do
     begin
      Chaine:=Chaine+P^;
      Dec(J);
      Inc(P);
     end;
    if (Transf<>Nil)
    and (CompareText(Copy(Chaine, 2, 8), '"origin"') = 0)
    and LireVecteur(Copy(Chaine, 12, 255), Origin) then
     begin
      F:=Transf;
      while F<>Nil do
       begin
        if F^.ModeDeplacement<>mdDeplacement then
         begin
          Origin.X:=Origin.X-F^.Clic.X;
          Origin.Y:=Origin.Y-F^.Clic.Y;
          Origin.Z:=Origin.Z-F^.Clic.Z;
          AppliqueVecteur(Origin, F);
         end;
        Origin.X:=Origin.X+F^.Clic.X;
        Origin.Y:=Origin.Y+F^.Clic.Y;
        Origin.Z:=Origin.Z+F^.Clic.Z;
        F:=F^.Suivant;
       end;
      Chaine:=' "origin" "' + ftos(Origin.X) + ' ' + ftos(Origin.Y) + ' ' + ftos(Origin.Z);
     end;
    if RemplaceWad and (Copy(Chaine,2,7) = '"wad" "') then
     begin
      Chaine:=' "wad" "'+NomWadTmp;
      RemplaceWad:=False;
     end;
    if not (Chaine[3] in ['"',';']) then
     begin
      Chaine:=Chaine+'"'#13#10;
      Dest^.Write(Chaine[1], Length(Chaine));
     end;
   until False;
   if RemplaceWad then
    begin
     Chaine:=' "wad" "'+NomWadTmp+'"'#13#10;
     Dest^.Write(Chaine[1], Length(Chaine));
     RemplaceWad:=False;
    end;
  end;
 FreeMem(Tampon, Taille);
end;

procedure TreeMapEntity(var Source: TStream; Dest, Brush: PStream; ParentPos: LongInt; Transf: PTransformation);
var
 Chaine: String[5];
begin
 SauverSpec(Source, Dest, Transf);
 Chaine:='}'#13#10;
 Dest^.Write(Chaine[1], 3);
end;

procedure SauverGroupe(var Source: TStream; Dest, Brush: PStream; Transf: PTransformation);
var
 Nombre, I: Word;
 InfoTypes, P: PChar;
 ParentPos: LongInt;
begin
 ParentPos:=Source.GetPos;
 Source.Read(Nombre, SizeOf(Nombre));
 if Nombre>0 then
  begin
   GetMem(InfoTypes, Nombre);
   Source.Read(InfoTypes^, Nombre);
   P:=InfoTypes;
   for I:=1 to Nombre do
    begin
     if Ord(P^) > High(TreeMapObj) then
      Error('Invalid datas');
     TreeMapObj[Ord(P^)] (Source, Dest, Brush, ParentPos, Transf);
     Inc(P);
    end;
   FreeMem(InfoTypes, Nombre);
  end;
end;

procedure TreeMapGroup(var Source: TStream; Dest, Brush: PStream; ParentPos: LongInt; Transf: PTransformation);
begin
 SauverSpec(Source, Nil, Transf);
 SauverGroupe(Source, Dest, Brush, Transf);
end;

procedure TreeMapBrush(var Source: TStream; Dest, Brush: PStream; ParentPos: LongInt; Transf: PTransformation);
var
 D: TMemoryStream;
 Chaine: String[5];
 SizeOfD: LongInt;
begin
 SauverSpec(Source, Dest, Transf);
 D.Init(256,256);
 SauverGroupe(Source, @D, Dest, Transf);
 Chaine:='}'#13#10;
 Dest^.Write(Chaine[1], 3);
 SizeOfD:=D.GetPos;
 D.Position:=0;
 Dest^.CopyFrom(D, SizeOfD);
 D.Done;
end;

procedure TroisPointsDansFace(const S: TSurface; var Pt, Pt2, Pt3: TVect);
const
 EchellePrecision = 512;
var
 V: TVect;
begin
 with S do
  begin
   Pt.X:=Normale.X*Dist;
   Pt.Y:=Normale.Y*Dist;
   Pt.Z:=Normale.Z*Dist;
   if Abs(Normale.Z) > 0.5 then
    begin
     V.X:=0;
     V.Y:=-Normale.Z*EchellePrecision;
     V.Z:=Normale.Y*EchellePrecision;
    end
   else
    begin
     V.X:=-Normale.Y*EchellePrecision;
     V.Y:=Normale.X*EchellePrecision;
     V.Z:=0;
    end;
   Pt2.X:=Pt.X+V.X;
   Pt2.Y:=Pt.Y+V.Y;
   Pt2.Z:=Pt.Z+V.Z;
   Cross(V, Normale, Pt3);
   Pt3.X:=Pt.X+Pt3.X;
   Pt3.Y:=Pt.Y+Pt3.Y;
   Pt3.Z:=Pt.Z+Pt3.Z;
  end;
end;

procedure TreeMapPolyhedron(var Source: TStream; Dest, Brush: PStream; ParentPos: LongInt; Transf: PTransformation);
var
 S: String;
 I, J, K: Integer;
 Pts: array[1..3] of TVect;

  function ftos(const X: Reel) : String;
  var
   R: Integer;
   S: String[15];
  begin
   R:=Round(X);
   if Abs(X-R) < rien then
    Str(R, S)
   else
    Str(X:7:5, S);
   ftos:=S;
  end;

var
 NbFaces: Word;
 Face: PSurface;
 Codes: PChar;
 F: PTransformation;
 Abr: Byte;
 Inv: Boolean;
begin
 S:=' {'#13#10;
 Brush^.Write(S[1], 4);
 Source.Read(NbFaces, SizeOf(NbFaces));
 GetMem(Codes, NbFaces * (1+SizeOf(TSurface)));
 Source.Read(Codes^, NbFaces);
 Face:=PSurface(Codes+NbFaces);
 for J:=0 to NbFaces-1 do
  begin
   Abr:=Ord(Codes[J]);
   if Abr<8 then
    begin
     FillChar(Face^.NomTex, TailleNomTex, 0);
     Source.Read(Face^.Params, TailleSurfParm+1);
     if Length(Face^.NomTex) >= TailleNomTex then
      Error('Texture name too long');
     Source.Read(Face^.NomTex[1], Length(Face^.NomTex));
     LowerCase(Face^.NomTex);
     if not TexturesUtilisees^.Search(@Face^.NomTex, K) then
      TexturesUtilisees^.AtInsert(K, NewStr(Face^.NomTex));
     Move(Face^.Params, TTF^.Tampon[TTF^.PositionTampon], TailleSurfVis);
     TTF^.PositionTampon:=(TTF^.PositionTampon+1) and 31;
    end
   else
    Move(TTF^.Tampon[Abr and 31], Face^.Params, TailleSurfParm+TailleNomTex);
   Inc(Face);
  end;
 Face:=PSurface(Codes+NbFaces);
 for J:=0 to NbFaces-1 do
  begin
   Abr:=Ord(Codes[J]);
   if Abr>=8 then
    Abr:=Abr shr 5;
   if Abr=7 then
    Source.Read(Face^.Normale, SizeOf(TVect)+SizeOf(Reel))
   else
    begin
     Face^.Normale:=Origine;
     case Abr of
      1 : Face^.Normale.X:=-1;
      2 : Face^.Normale.X:=1;
      3 : Face^.Normale.Y:=-1;
      4 : Face^.Normale.Y:=1;
      5 : Face^.Normale.Z:=-1;
      6 : Face^.Normale.Z:=1;
     end;
     Source.Read(Face^.Dist, SizeOf(Reel));
    end;

   TroisPointsDansFace(Face^, Pts[1], Pts[2], Pts[3]);
   Inv:=False;
   F:=Transf;
   while F<>Nil do
    begin
     for I:=1 to 3 do
      begin
       if F^.ModeDeplacement<>mdDeplacement then
        begin
         Pts[I].X:=Pts[I].X-F^.Clic.X;
         Pts[I].Y:=Pts[I].Y-F^.Clic.Y;
         Pts[I].Z:=Pts[I].Z-F^.Clic.Z;
         AppliqueVecteur(Pts[I], F);
         Inv:=Inv xor (F^.ModeDeplacement=mdLineaireNegatif);
        end;
       Pts[I].X:=Pts[I].X+F^.Clic.X;
       Pts[I].Y:=Pts[I].Y+F^.Clic.Y;
       Pts[I].Z:=Pts[I].Z+F^.Clic.Z;
      end;
     F:=F^.Suivant;
    end;
   S:='  ';
   for I:=1 to 3 do
    begin
     if (I>1) and Inv then
      K:=5-I
     else
      K:=I;
     with Pts[K] do
      S:=S+'( '+ftos(X)+' '+ftos(Y)+' '+ftos(Z)+' ) ';
    end;
   S:=S+Face^.NomTex;
   for I:=1 to 5 do
    S:=S+' '+ftos(Face^.Params[I]);
   S:=S+#13#10;
   Brush^.Write(S[1], Length(S));
   Inc(Face);
  end;
 FreeMem(Codes, NbFaces * (1+SizeOf(TSurface)));
 S:=' }'#13#10;
 Brush^.Write(S[1], 4);
end;

procedure TreeMapDuplicator(var Source: TStream; Dest, Brush: PStream; ParentPos: LongInt; Transf: PTransformation);
var
 Tampon, P, Egal, Fin, InfoTypes: PChar;
 Taille, SousEl, Bidon: Word;
{Angle: Reel;}
 Offset, Centre: TVect;
 Code, Count, I, J: Integer;
 CurPos: LongInt;
{F: ^PTransformation;}
{Rotation,} Deplacement, {Sym} Lineaire: PTransformation;
{Symetries: String[7];}
 Matrice, Produit: TMatriceTransformation;
 MatriceR: array[1..9] of Reel absolute Matrice;
 UtiliseMatrice, VieuxStyle: Boolean;
begin
 Source.Read(Taille, SizeOf(Taille));
 GetMem(Tampon, Taille+1);
 Source.Read(Tampon^, Taille);
 Tampon[Taille]:=#0;
 P:=Tampon;
{Angle:=0;}
 Offset:=Origine;
 Centre:=Origine;
 UtiliseMatrice:=False;
 VieuxStyle:=False;
 Count:=1;
{F:=@Transf;
 while F^<>Nil do
  F:=@F^^.Suivant;}
 while P^<>#0 do
  begin
   Egal:=StrScan(P, '=');
   if Egal=Nil then Break;
   Fin:=StrScan(Egal+1, #13);
   if Fin=Nil then Fin:=StrEnd(Egal+1);
   Egal^:=#0;
   Fin^:=#0;
   if StrIComp(P, 'origin') = 0 then
    begin
     if not LireVecteur(StrPas(Egal+1), Centre) then
      Centre:=Origine;
    end
   else
    if StrIComp(P, 'offset') = 0 then
     begin
      if not LireVecteur(StrPas(Egal+1), Offset) then
       Offset:=Origine;
     end
    else
     if StrIComp(P, 'count')=0 then
      begin
       Val(StrPas(Egal+1), Count, Code);
       if Code<>0 then
        Count:=1;
      end
     else
      if StrIComp(P, 'linear') = 0 then
       UtiliseMatrice:=LireReels(StrPas(Egal+1), MatriceR)
      else
       if (StrIComp(P, 'angle') = 0) or (StrIComp(P, 'sym')=0) then
        VieuxStyle:=True;
      {if StrIComp(P, 'angle') = 0 then
        begin
         Val(StrPas(Egal+1), Angle, Code);
         if Code<>0 then
          Angle:=0;
        end
       else
        if StrIComp(P, 'sym')=0 then
         Symetries:=StrPas(Egal+1);}

   P:=Fin+1;
   if P^=#10 then
    Inc(P);
  end;
 FreeMem(Tampon, Taille+1);
 if VieuxStyle then
  begin
   Writeln('WARNING: old style Duplicators are not supported');
   VieuxStyle:=False;
   Count:=0;
  end;
 if (Offset.X<>0) or (Offset.Y<>0) or (Offset.Z<>0) then
  begin
   New(Deplacement);
   Deplacement^.Suivant:=Transf;
   Transf:=Deplacement;
   Deplacement^.ModeDeplacement:=mdDeplacement;
  end
 else
  Deplacement:=Nil;
{if Angle<>0 then
  begin
   New(Rotation);
   Rotation^.Suivant:=F^;
   F^:=Rotation;
   Rotation^.ModeDeplacement:=mdRotZ;
   Rotation^.Clic:=Centre;
   Angle:=Angle * (pi/180);
  end
 else
  Rotation:=Nil;}
 if UtiliseMatrice then
  begin
   New(Lineaire);
   Lineaire^.Suivant:=Transf;
   Transf:=Lineaire;
   if Determinant(Matrice)<0 then
    Lineaire^.ModeDeplacement:=mdLineaireNegatif
   else
    Lineaire^.ModeDeplacement:=mdLineairePositif;
   Lineaire^.Clic:=Centre;
   Lineaire^.Matrice:=Matrice;
  end
 else
  Lineaire:=Nil;
 CurPos:=Source.GetPos;
 Source.Seek(ParentPos);
 Source.Read(SousEl, SizeOf(SousEl));
 if SousEl>0 then
  begin
   GetMem(InfoTypes, SousEl);
   Source.Read(InfoTypes^, SousEl);
   for J:=1 to Count do
    begin
    {if Rotation<>Nil then
      begin
       Rotation^.Facteur:=Cos(Angle*J);
       Rotation^.Facteur2:=Sin(Angle*J);
      end;}
     if Deplacement<>Nil then
      begin
       Deplacement^.Clic.X:=Offset.X*J;
       Deplacement^.Clic.Y:=Offset.Y*J;
       Deplacement^.Clic.Z:=Offset.Z*J;
      end;
   (*Sym:=Nil;
     for I:=Length(Symetries) downto 1 do
      if J and (1 shl Pred(I)) <> 0 then
       case Upcase(Symetries[I]) of
        'X': begin
              New(Sym);
              Sym^.Suivant:=F^;
              F^:=Sym;
              Sym^.ModeDeplacement:=mdSymYZ;
              Sym^.Clic:=Centre;
             end;
        'Y': begin
              New(Sym);
              Sym^.Suivant:=F^;
              F^:=Sym;
              Sym^.ModeDeplacement:=mdSymXZ;
              Sym^.Clic:=Centre;
             end;
        'Z': begin
              New(Sym);
              Sym^.Suivant:=F^;
              F^:=Sym;
              Sym^.ModeDeplacement:=mdSymXY;
              Sym^.Clic:=Centre;
             end;
       end;*)
     Source.Seek(ParentPos + SizeOf(SousEl) + SousEl);
     P:=InfoTypes;
     for I:=1 to SousEl do
      begin
       if Ord(P^) > High(TreeMapObj) then
        Error('Invalid datas');
       if Ord(P^) = mapDuplicator then
        begin
         Source.Read(Bidon, SizeOf(Bidon));
         Source.Seek(Source.GetPos + Bidon);
        end
       else
        TreeMapObj[Ord(P^)] (Source, Dest, Brush, -1, Transf);
       Inc(P);
      end;
   (*while (F^<>Nil) and (F^^.ModeDeplacement in [mdSymXY, mdSymXZ, mdSymYZ]) do
      begin
       Sym:=F^^.Suivant;
       Dispose(F^);
       F^:=Sym;
      end;*)
     if Lineaire<>Nil then
      begin
       MultiplieMatrices(Lineaire^.Matrice, Matrice, Produit);
       Lineaire^.Matrice:=Produit;
      end;
    end;
   FreeMem(InfoTypes, SousEl);
  end;
 Source.Seek(CurPos);
 if Deplacement<>Nil then
  Dispose(Deplacement);
 if Lineaire<>Nil then
  Dispose(Lineaire);
{F^:=Nil;}
end;

 (************************************************************)

procedure ExtraireMap(var Entree: TEntreeRepQM; const NomFich: String);
var
 Fich: PBufStream;
begin
 if TexturesUtilisees=Nil then
  New(TexturesUtilisees, Init(8,8));
 ReadNXFEntry(Entree, 'Map');
 New(Fich, Init(NomFich, stCreate, 1024));
 RemplaceWad:=True;
 New(TTF);
 FillChar(TTF^, SizeOf(TTransfertTreeMap), 0);
 TreeMapBrush(SourceFile^, Fich, Nil, 0, Nil);
 Dispose(TTF);
 Dispose(Fich, Done);
end;

 (************************************************************)

function CharToPas(C: array of Byte) : String;
var
 I: Integer;
 S: String;
begin
 I:=0;
 while (I<=High(C)) and (C[I]<>0) do
  Inc(I);
 S[0]:=Chr(I);
 Move(C, S[1], I);
 CharToPas:=S;
end;

procedure PasToChar(var C: array of Byte; const S: String);
begin
 if Length(S) <= High(C) then
  begin
   Move(S[1], C, Length(S));
   FillChar(C[Length(S)], High(C)+1-Length(S), 0);
  end
 else
  Move(S[1], C, High(C)+1);
end;

function OpenNXFEntry(const Entree: TEntreeRepQM; EntryId: String) : LongInt;
begin
 OpenNXFEntry:=SearchDdEntry(Entree, EntryId, -1);
end;

function SearchDdEntry(const Entree: TEntreeRepQM; var EntryId: String; Index: Integer) : LongInt;
var
 Count, Pos0: LongInt;
 Entries, P: PEnteteNXF;
 I, SizeIds, SizeEntries: Integer;
 Strings, PS: PChar;
 Id, SearchFor: String[255];
begin
 SearchDdEntry:=-1;
 SourceFile^.Seek(Entree.Position1);
 SourceFile^.Read(Count, 4);
 SizeEntries:=Count*SizeOf(TEnteteNXF);
 GetMem(Entries, SizeEntries);
 SourceFile^.Read(Entries^, SizeEntries);
 SizeIds:=0;
 P:=Entries;
 for I:=1 to Count do
  begin
   Inc(SizeIds, P^.TailleId);
   Inc(P);
  end;
 GetMem(Strings, SizeIds);
 SourceFile^.Read(Strings^, SizeIds);
 PS:=Strings;
 P:=Entries;
 I:=0;
 Pos0:=SourceFile^.GetPos;
 while I<Count do
  begin
   Id[0]:=Chr(P^.TailleId);
   Move(PS^, Id[1], Length(Id));
   if (Index>=0) and (Id[1]=':') then
    if Index=0 then
     EntryId:=Id  { search for the "index"th entry beginning with ":" }
    else
     Inc(Index);
   if CompareText(Id, EntryId)=0 then
    begin
     SourceFile^.Seek(Pos0);
     SearchDdEntry:=P^.Taille;
     I:=MaxInt;
    end
   else
    begin
     Inc(Pos0, P^.Taille);
     Inc(PS, Length(Id));
     Inc(P);
     Inc(I);
    end;
  end;
 FreeMem(Strings, SizeIds);
 FreeMem(Entries, SizeEntries);
end;

procedure ReadNXFEntry(const Entree: TEntreeRepQM; const EntryId: String);
begin
 if OpenNXFEntry(Entree, EntryId)<0 then
  Error('NXF entry expected : '+EntryId);
end;

function NXFString(const Entree: TEntreeRepQM; const EntryId: String) : String;
var
 I: Integer;
 Result: String;
begin
 I:=OpenNXFEntry(Entree, EntryId);
 if I<0 then
  NXFString:=''
 else
  begin
   Result[0]:=Chr(I);
   SourceFile^.Read(Result[1], Length(Result));
   NXFString:=Result;
  end;
end;

function ReadFileName(const Entree: TEntreeRepQM) : String;
var
 Result: String;
begin
 Result:=NXFString(Entree, 'FileName');
 if Result<>'' then
  ReadFileName:=Result
 else
  ReadFileName:=NomMapDefaut;
end;

(*procedure AddString(var C: PStringCollection; const S: String);
var
 P: PStringCollection;
begin
 GetMem(P, 5+Length(S));
 P^.Next:=C;
 P^.S:=S;
 C:=P;
end;

procedure DeleteColl(C: PStringCollection);
var
 P: PStringCollection;
begin
 while C<>Nil do
  begin
   P:=C^.Next;
   FreeMem(C, 5+Length(C^.S));
   C:=P;
  end;
end;

function StringInColl(C: PStringCollection; const S: String) : PStringCollection;
begin
 while (C<>Nil) and (CompareText(C^.S, S)<>0) do
  C:=C^.Next;
 StringInColl:=C;
end;*)

end.