PROGRAM QuArKDosRuntime;
{$N+,E-}

(*************************************************************)
(******                                                 ******)
(*****           DOS Run-time for QuArK 3.7              *****)
(******                                                 ******)
(*************************************************************)

(* Quake Army Knife (QuArK) and this program are
      (c) Armin Rigo, 1997
          arigo@alphanet.ch           *)

USES Objects, QkQme, QmObj, QmPak, QPAcc, QkUI, Textures;

const
 Banner = 'Quake Army Knife (QuArK) DOS Run-Time - version 3.7, by Armin Rigo';

var
 QuakeCCode : ^Text;
 FirstMap   : String[31];

function Init : Char;
var
 S : string[3];
begin
 S:=ParamStr(1);
 if (ParamCount<2) or (Length(S)>1) then
  begin
   WRITELN(Banner);
   WRITELN('  For basic information type QK');
   WRITELN('  For advanced operations, use one of the following commands :');
   WRITELN('QKDOSRT u <batch name> <file(s)...>');
   WRITELN('  Extract the qme or map file(s) and creates a batch file with all');
   WRITELN('  the Dos commands required to prepare it and run Quake.');
   WRITELN('  Option : "-game dir" works like with Quake.');
   WRITELN('QKDOSRT p <pack file> <file(s)...>');
   WRITELN('  Add the files to the pack file.');
  {WRITELN('QKDOSRT e <pack file> <file(s)...>');
   WRITELN('  Extract the files from the pack file. (default: extract all files)');}
   WRITELN('QKDOSRT c <original progs.dat file>');
   WRITELN('  Compile the QuakeC code in the current directory as specified by the');
   WRITELN('  file Progs.src. Option : "-f" don''t ask for keys, use default ones.');
   WRITELN('QKDOSRT q <quake path>');
   WRITELN('  Set the path to Quake');
   HALT;
  end;
 Init:=Upcase(S[1]);
end;

procedure CompilerEx;
var
 Source: PStream;
 Patch, Keys: TStringCollection;
 ProgsSrc: Text;
 Line, Target: String[127];
 Code: Integer;
 P: PString;
begin
 Source:=New(PDosStream, Init(CmdLineText1(2), stOpenRead));
 if Source^.Status<>stOk then
  Error('Could not open source compiled data : '+CmdLineText1(2));
 Assign(ProgsSrc, 'Progs.src');
 {$I-} Reset(ProgsSrc); {$I+}
 if IOResult<>0 then
  Error('Could not open file Progs.src');
 Patch.Init(4,4);
 Target:='';
 Impulse0:=Impulse0Def;
 while not Eof(ProgsSrc) do
  begin
   Readln(ProgsSrc, Line);
   if Pos('//', Line)<>0 then Line[0]:=Chr(Pos('//',Line)-1);
   while (Line<>'') and (Line[Length(Line)]=' ') do
    Dec(Byte(Line[0]));
   if Line<>'' then
    if CompareText(Copy(Line,1,9), 'Impulse0 ')=0 then
     Val(Copy(Line,10,255), Impulse0, Code)
    else
     if Target='' then
      Target:=Line
     else
      Patch.AtInsert(Patch.Count, NewStr(Line));
  end;
 if Target='' then
  Error('Invalid Progs.src');
 Keys.Init(4,4);
 Compiler(@Patch, Source, Target, Keys, Impulse0);
 Patch.Done;
 if not CmdLineOption('f') then
  EditKeys(Keys, ' Key selection ', 0);
 Assign(ProgsSrc, Copy(Target,1,ExtractPath(Target)) + 'quark.cfg');
 Rewrite(ProgsSrc);
 Code:=0;
 while Code<Keys.Count do
  begin
   P:=PString(Keys.At(Code));
   if P<>Nil then
    if P^[1]=#255 then
     begin
      Writeln(ProgsSrc, 'bind ', Copy(P^,2,255), ' "', PString(Keys.At(Code+2))^, '"');
      Inc(Code,2);
     end
    else
     Writeln(ProgsSrc, P^);
   Inc(Code);
  end;
 Close(ProgsSrc);
 Keys.Done;
end;

procedure MainProcess(const FileName: String; var Entree: TEntreeRepQM); far;
var
 S, Path: String;
 Source: PStream;
 Dest: TDosStream;
 L, Signature: LongInt;
 I: Integer;
 F: File;
begin
 case Entree.InfoType of
  qmDescription : RecallBatch('0', '');
  qmCarte       : if OpenNXFEntry(Entree, 'Models')<0 then
                   begin
                    S:=UniqueFile(OutputFile('maps/'), ReadFileName(Entree), '.map');
                    ExtraireMap(Entree, OutputFile('maps/'+S+'.map'));
                    RecallBatch('1', S);
                    if FirstMap='' then
                     FirstMap:=S;
                   end;
  qmPatchQC     : begin
                   L:=OpenNXFEntry(Entree, 'Data');
                   if L<0 then Error('QC code not found');
                   S:=UniqueFile(OutputFile('source/'), CharToPas(Entree.Nom), '.qc');
                   RecallBatch('2', S);
                   S:=S+'.qc';
                   Dest.Init(OutputFile('source/'+S), stCreate);
                   Dest.CopyFrom(SourceFile^, L);
                   Dest.Done;
                   if QuakeCCode=Nil then
                    begin
                     New(QuakeCCode);
                     Assign(QuakeCCode^, OutputFile('source/progs.src'));
                     Rewrite(QuakeCCode^);
                     Writeln(QuakeCCode^, '..\progs.dat');
                    end;
                   Writeln(QuakeCCode^, S);
                  end;
  qmBSP0        : begin
                   S:=UniqueFile(OutputFile('maps/'), ReadFileName(Entree), '.bsp');
                   PreparerBSP(OutputFile('maps/'+S+'.bsp'), Entree);
                   RecallBatch('3', S);
                   if FirstMap='' then
                    FirstMap:=S;
                  end;
  qmTextureDef  : RecallBatch('4', '');
  qmFileDef     : begin
                   Path:=NXFString(Entree, 'Path');
                   I:=0;
                   repeat
                    S:=#255;
                    L:=SearchDdEntry(Entree, S, I);   { file entries }
                    if L<0 then Break;
                    Inc(I);
                    S:=Path+Copy(S,2,255);
                    Dest.Init(OutputFile(S), stCreate);
                    Dest.CopyFrom(SourceFile^, L);
                    Dest.Done;
                    RecallBatch('5', S);
                   until False;
                  end;
  qmQContext    : begin
                   L:=OpenNXFEntry(Entree, 'progsdat');
                   if L>=SizeOf(Signature) then
                    begin
                     SourceFile^.Read(Signature, SizeOf(Signature));
                     Source:=Nil;
                     if Signature=ProgsDatSignature then
                      begin
                       Dest.Init(OutputFile('source/original.dat'), stCreate);
                       Dest.Write(Signature, SizeOf(Signature));
                       Dest.CopyFrom(SourceFile^, L-4);
                       Dest.Done;
                      end
                     else if Signature=ProgsDatFichier then
                      begin
                       S[0]:=Chr(L-4);
                       SourceFile^.Read(S[1], Length(S));
                       Source:=New(PDosStream, Init(S, stOpenRead));
                       if Source^.Status<>stOk then
                        begin
                         Writeln('WARNING: file not found: ', S);
                         Dispose(Source, Done);
                         Source:=Nil;
                        end
                       else
                        L:=Source^.GetSize;
                      end
                     else if Signature=ProgsDatSourceDir then
                      begin
                       S[0]:=Chr(L-4);
                       SourceFile^.Read(S[1], Length(S));
                       L:=OpenQuakeEntry('progs.dat', S, Source);
                      end
                     else if Signature=ProgsDatDefault then
                      begin
                       Assign(F, OutputFile('source/original.dat'));
                       {$I-} Erase(F); {$I+}
                       I:=IOResult;
                      end
                     else
                      Writeln('WARNING: invalid internal Progs.dat');
                     if Source<>Nil then
                      begin
                       Dest.Init(OutputFile('source/original.dat'), stCreate);
                       Dest.CopyFrom(Source^, L);
                       Dest.Done;
                       Dispose(Source, Done);
                      end;
                    end;
                   RecallBatch('6', '');
                  end;
  qmFileLnk     : begin
                   S:=NXFString(Entree, 'FileName');
                   Writeln('File Link : ', S, '.qme');
                   RecallBatch('7', S);
                  end;
  qmModel       : begin
                   S:=ReadFileName(Entree);
                   L:=OpenNXFEntry(Entree, 'Mdl');
                   if L<0 then
                    Error('Invalid Model definition');
                   Dest.Init(OutputFile('progs/'+S+'.mdl'), stCreate);
                   Dest.CopyFrom(SourceFile^, L);
                   Dest.Done;
                   RecallBatch('8', S);
                  end;
 else
  Writeln('WARNING: unknown entry type (', Entree.InfoType, ')');
 end;
end;

procedure ProcessU;
type
 TIntroPakEx = record
                Intro: TIntroPak;
                S1,S2: LongInt;
               end;
var
 I: Integer;
 F: File;
 Source: PStream;
 Dest: TDosStream;
 IntroPak: TIntroPakEx;
 S: String;
 L: LongInt;
begin
 WRITELN(Banner);
 if ParamCount<3 then Error('Too few arguments');
 S:=CmdLineText1(2);
 if FileExists(S) then Error('Destination batch file already exists ('+S+')');
 LoadQuakeDir('');
 Empty(QuakeDir+'\tmpQuArK\');
 InitQContext;
 Writeln(AllTextures^.Count, ' textures ready.');
 for I:=2 to ParamCount-1 do
  if CompareText(ParamStr(I), '-game')=0 then
   begin
    GameDir:=ParamStr(I+1);
    SourceDir:=GameDir;
   end;
 if GameDir='' then
  begin
   PackFile:='';
   CmdLine1:='-game tmpquark '+CmdLine1;
  end
 else
  begin
   Writeln('Game directory : ', GameDir);
   I:=0;
   while FileExists(QuakeDir+'\'+GameDir+'\PAK'+IntToStr(I)+'.PAK') do
    Inc(I);
   if I>0 then
    begin
     Assign(F, QuakeDir+'\'+GameDir+'\PAK'+IntToStr(I-1)+'.PAK');
     {$I-}
     Reset(F,1);
     BlockRead(F, IntroPak, SizeOf(TIntroPakEx));
     Close(F);
     {$I+}
     if (IOResult=0) and (IntroPak.Intro.Signature=SignaturePACK)
     and (IntroPak.S1=SignatureQuArKPAK1) and (IntroPak.S2=SignatureQuArKPAK2) then
      Dec(I);  { reuse this file }
    end;
   PackFile:=QuakeDir+'\'+GameDir+'\PAK'+IntToStr(I)+'.PAK';
   CmdLine1:='-game '+GameDir+' '+CmdLine1;
  end;
 New(DestBatch);
 Assign(DestBatch^, S);
 Rewrite(DestBatch^);
 RecallBatch('begin', '');
 FirstMap:='';
 QuakeCCode:=Nil;
 TexturesUtilisees:=Nil;
 ProcessQuArKFiles(MainProcess, True);
 if QuakeCCode<>Nil then
  begin
   if Impulse0<>Impulse0Def then
    Writeln(QuakeCCode^, 'Impulse0 ', Impulse0);
   Close(QuakeCCode^);
   Dispose(QuakeCCode);
   S:=OutputFile('source/original.dat');
   if not FileExists(S) then
    begin
     L:=OpenQuakeEntry('progs.dat', '', Source);
     Dest.Init(S, stCreate);
     Dest.CopyFrom(Source^, L);
     Dest.Done;
     Dispose(Source, Done);
    end;
  end;
 if FirstMap<>'' then
  begin
   LowerCase(FirstMap);
   CmdLine1:=CmdLine1+'+map '+FirstMap;
  end;
 Writeln(DestBatch^, QkDosRtPath, '\QK.BAT /end ', QkDosRtPath, ' ', QuakeDir, ' ', CmdLine1);
 Close(DestBatch^);
 Dispose(DestBatch);
 if TexturesUtilisees<>Nil then
  begin
   ExtraireTextures(TexturesUtilisees, OutputFile(NomWadTmp));
   Dispose(TexturesUtilisees, Done);
  end;
 for I:=TmpBspFiles-1 downto 0 do
  begin
   Assign(F, OutputFile('maps/'+'tmp~qk'+IntToStr(I)+'.bsp'));
   Erase(F);
  end;
 Writeln('Done.');
end;

begin
 case Init of
  'C': CompilerEx;
  'P': Add2Pack;
  'Q': begin
        LoadQuakeDir(CmdLineText1(2));
        Writeln('Quake path is now ', QuakeDir);
       end;
  'U': ProcessU;
  else Error('Unknown command '+ParamStr(1));
 end;
end.