(**************************************************************************
QuArK -- Quake Army Knife -- 3D game editor
Copyright (C) 1996-99 Armin Rigo

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Contact the author Armin Rigo by e-mail: arigo@planetquake.com
or by mail: Armin Rigo, La Cure, 1854 Leysin, Switzerland.
See also http://www.planetquake.com/quark
**************************************************************************)

unit QkMapObjects;

interface

uses Windows, SysUtils, Classes, Graphics, QkObjects, qmath,
     QkExplorer, QkFileObjects, QkForm, qmatrices, CommCtrl,
     Menus, Controls, Qk3D, QkMdlObjects, Python;

{$DEFINE RemoveEmptySpecs}

const
 vfGrayedout        = 1;
 vfHidden           = 2;
 vfIgnoreToBuildMap = 4;
 vfHideOn3Dview     = 8;
 vfCantSelect       = 16;

 soSelOnly        = 1;
 soIgnoreToBuild  = 2;
 soDisableEnhTex  = 4;
 soDisableFPCoord = 8;
 soDirectDup         = $04000000;
 soBSP               = $08000000;
 soOutsideWorldspawn = $10000000;
 soAddTo3DScene      = $20000000;
 soNonParcourirSel   = $40000000;
 soErrorMessageFlags = soDisableEnhTex;

 SpecClassname = 'classname';
 ClassnameWorldspawn = 'worldspawn';
 ContentsOrigin = 16777216;

 NegativeGlobal = 'g';

type
 TBBoxInfo = array[0..6] of Single;
 TTreeMap = class;
 TTreeMapClass = class of TTreeMap;
 TTreeMap = class(Q3DObject)   { all objects in a map }
            private
             {procedure SetOrigin(const nOrigin: TVect);
              function GetHasOrigin: Boolean;
              function GetOrigin1: TVect;}
              function GetNegative: String;
              procedure SetNegative(const Neg: String);
            protected
             {procedure ResultatAnalyseClic(var Liste: PAnalyseClic; nH: Reel);}
             {function GetTreeView(var M: TMapExplorer) : Boolean;}
            public
             {procedure Dessiner; virtual;
              procedure PreDessinerSel; virtual;
              procedure PostDessinerSel; virtual;}
              function DernierOrigineSel(var Pt: TVect) : TTreeMap;
             {function GetOrigin(var Pt: TVect) : Boolean; virtual;
              function AnalyserClic(ModeAnalyse: Integer) : TTreeMap;}
              procedure AnalyseClic(Liste: PyObject); override;
              procedure Deplacement(const PasGrille: Reel); override;
             {property Origin: TVect read GetOrigin1 write SetOrigin;
              property HasOrigin: Boolean read GetHasOrigin;}
              procedure ChercheExtremites(var Min, Max: TVect); override;
              procedure FindTextures(SortedList: TStringList); virtual;
              function ReplaceTexture(const Source, Dest: String; U: Boolean) : Integer; virtual;
             {function VisuallySelected : Boolean; virtual;}
              procedure ListePolyedres(Polyedres, Negatif: TQList; Flags: Integer; Brushes: Integer); virtual;
              procedure ListeEntites(Entites: TQList); virtual;
              procedure SauverTexte(Negatif: TQList; Texte: TStrings; Flags: Integer; HxStrings: TStrings); virtual;
              function GetFormName : String; virtual;
             {function AjouterRef(Liste: TList; Niveau: Integer) : Integer; override;}
             {procedure RefreshColor(Plan: Pointer); virtual;}
              procedure OpDansScene(Aj: TAjScene; PosRel: Integer); override;
             { function GetObjectMenu(Control: TControl) : TPopupMenu; override;
              function GetTMMenuState(Item: Integer) : Integer; dynamic;}
              procedure SetSelFocus; dynamic;
              procedure AddTo3DScene; override;
              property Negative: String read GetNegative write SetNegative;
              function PyGetAttr(attr: PChar) : PyObject; override;
            end;
 TTreeMapSpec = class(TTreeMap)
                protected
                  procedure SauverSpec(Dest, HxStrings: TStrings; Flags: Integer);
                 {procedure DessinePoignee(const Pts0: TPoint); virtual;}
                  procedure CouleurDessin(var C: TColor); virtual;
                public
                 {function CalculePosAngle(var V: TVect) : Integer;
                  function CalculePosEcran(var P: TPoint; var V: TVect) : Integer;
                  function VecteurNormalDirection(var V: TVect) : Boolean;
                  function ModeAngle(var S: String) : Integer;}
                  procedure Deplacement(const PasGrille: Reel); override;
                 {procedure PreDessinerSel; override;
                  procedure PostDessinerSel; override;}
                end;
 TTreeMapEntity = class(TTreeMapSpec)
                  private
                    FOrigin: TVect;
                    FHasOrigin: Boolean;
                    procedure SetOrigin(const nOrigin: TVect);
                  protected
                    function RegleOrigine(Ancien: Boolean) : Boolean;
                   {procedure DessinePoignee(const Pts0: TPoint); override;
                    procedure Display3DModel(L: TQList);}
                    function AddModelTo3DScene : Boolean;
                    function GetBBoxInfo(var BBox: TBBoxInfo) : Boolean;
                  public
                    class function TypeInfo: String; override;
                    procedure EtatObjet(var E: TEtatObjet); override;
                    procedure AnalyseClic(Liste: PyObject); override;
                    procedure FixupReference; override;
                   {procedure OpDansScene(Aj: TAjScene; PosRel: Integer); override;}
                    function GetOrigin(var Pt: TVect) : Boolean; override;
                    property Origin: TVect read FOrigin write SetOrigin;
                    property HasOrigin: Boolean read FHasOrigin;
                    procedure ChercheExtremites(var Min, Max: TVect); override;
                    procedure PreDessinerSel; override;
                    procedure Dessiner; override;
                    procedure Deplacement(const PasGrille: Reel); override;
                    procedure ListeEntites(Entites: TQList); override;
                    procedure SauverTexte(Negatif: TQList; Texte: TStrings; Flags: Integer; HxStrings: TStrings); override;
                    function GetFormName : String; override;
                   {function AjouterRef(Liste: TList; Niveau: Integer) : Integer; override;}
                    procedure AddTo3DScene; override;
                    function PyGetAttr(attr: PChar) : PyObject; override;
                  end;
 TTreeMapGroup = class(TTreeMapSpec)
                 private
                   function GetViewFlags: Integer;
                   procedure SetViewFlags(Flags: Integer);
                 public
                   SelectedObject: QObject;
                   SelectedIndex: Integer;
                   procedure Dessiner; override;
                   class function TypeInfo: String; override;
                   procedure EtatObjet(var E: TEtatObjet); override;
                   function IsExplorerItem(Q: QObject) : TIsExplorerItem; override;
                   property ViewFlags: Integer read GetViewFlags write SetViewFlags;
                   procedure ListePolyedres(Polyedres, Negatif: TQList; Flags: Integer; Brushes: Integer); override;
                   procedure ListeEntites(Entites: TQList); override;
                   procedure SauverTexte(Negatif: TQList; Texte: TStrings; Flags: Integer; HxStrings: TStrings); override;
                   procedure AddTo3DScene; override;
                   procedure AnalyseClic(Liste: PyObject); override;
                  {function SingleLevel: Boolean; virtual;}
                 protected
                   procedure Compute3DDiggers;
                 end;
 TTreeMapBrush = class(TTreeMapGroup)
                 protected
                   procedure CouleurDessin(var C: TColor); override;
                 public
                   Form4: TQkForm;
                   class function TypeInfo: String; override;
                   procedure EtatObjet(var E: TEtatObjet); override;
                   procedure ListePolyedres(Polyedres, Negatif: TQList; Flags: Integer; Brushes: Integer); override;
                   procedure ListeEntites(Entites: TQList); override;
                   procedure SauverTexte(Negatif: TQList; Texte: TStrings; Flags: Integer; HxStrings: TStrings); override;
                   function GetFormName : String; override;
                   function IsExplorerItem(Q: QObject) : TIsExplorerItem; override;
                   function PyGetAttr(attr: PChar) : PyObject; override;
                   procedure AddTo3DScene; override;
                 end;

 {------------------------}

(*const   { for GetTMMenuState }
 tms_Specifics        = 0;
 tms_MultipleSpec     = 1;
 tms_Texture          = 2;
 tms_Movements        = 3;
 tms_DissociateImages = 4;
 tms_MakeDiggerPerm   = 5;
 tms_Subtract         = 7;
 tms_Intersect        = 8;
 tms_MakeRoom         = 9;
 tms_AlignerGrille    = 11;
 tms_Cut              = 13;
 tms_Copy             = 14;
 tms_PasteIntoGroup   = 15;
 tms_Delete           = 16;*)

 {------------------------}

{procedure PoigneeRouge(const Pts0: TPoint);}
procedure SetupWhiteOnBlack(WhiteOnBlack: Boolean);
{function GetMapIcons: HImageList;
procedure ReleaseMapIcons;
function LongueurVectNormal : Single;}
procedure CheckTreeMap(Racine: TTreeMap);

 {------------------------}

implementation

uses Setup, QkMapPoly, Undo, FormCfg,
     QkMdl, Game, QkMacro, Ed3DFX, Quarkx, PyMath,
     PyMapView, PyObjects, QkImages;

 {------------------------}

(*procedure PoigneeRouge(const Pts0: TPoint);
var
 R: TRect;
 Brush: HBrush;
 Code: Integer;
begin
 if CCoord.CheckVisible(Pts0) then
  with Pts0 do
   begin
    if Info.BasePen=White_pen then
     Code:=Whiteness
    else
     Code:=Blackness;
    PatBlt(Info.DC, X-3, Y-3, 7, 7, Code);
    R:=Bounds(X-2, Y-2, 5, 5);
    Brush:=CreateSolidBrush(MapColors(lcTag));
    FillRect(Info.DC, R, Brush);
    DeleteObject(Brush);
   end;
end;*)

procedure SetupWhiteOnBlack(WhiteOnBlack: Boolean);
begin
 if WhiteOnBlack then
  begin
   Info.BasePen:=White_Pen;
   Info.BaseR2:=R2_White;
   Info.MaskR2:=R2_MergePen;
  end
 else
  begin
   Info.BasePen:=Black_Pen;
   Info.BaseR2:=R2_Black;
   Info.MaskR2:=R2_MaskPen;
  end;
end;

(*function GetMapIcons: HImageList;
begin
 if Info.MapIcons=0 then
  Info.MapIcons:=ImageList_LoadImage(HInstance,
   MakeIntResource(105+Ord(Info.BasePen=White_Pen)),
   16, 1, clAqua, IMAGE_BITMAP, 0);
 Result:=Info.MapIcons;
end;

procedure ReleaseMapIcons;
begin
 if Info.MapIcons<>0 then
  begin
   ImageList_Destroy(Info.MapIcons);
   Info.MapIcons:=0;
  end;
end;

function LongueurVectNormal : Single;
begin
 Result:=SetupSubSet(ssMap, 'Display').
  GetFloatSpec('NormalVector', 40);
end;*)

procedure CheckTreeMap(Racine: TTreeMap);

  procedure Check1(Q: QObject);
  var
   I: Integer;
  begin
   if not (Q is TTreeMap) then
    ListeActions.Add(TQObjectUndo.Create('', Q, Nil))  { unsupported }
   else
    begin
     Q.Acces;
     Q.Flags:=Q.Flags or ofTvSousElement;
     for I:=0 to Q.SousElements.Count-1 do
      Check1(Q.SousElements[I]);
    end;
  end;

var
 I: Integer;
begin
 Racine.Acces;
 DebutAction;
 for I:=0 to Racine.SousElements.Count-1 do
  Check1(Racine.SousElements[I]);
 if ListeActions.Count=0 then
  AnnuleAction
 else
  begin
   GlobalWarning(FmtLoadStr1(5566, [ListeActions.Count]));
   FinAction(Racine, LoadStr1(CannotUndo));
  end;
end;

 {------------------------}

{procedure TTreeMap.PreDessinerSel;
var
 Pt: TVect;
begin
 if DernierOrigineSel(Pt)<>Nil then
  with CCoord.Proj(Pt) do
   PatBlt(Info.DC, X-2, Y-2, 5, 5, Blackness);
end;}

{function TTreeMap.GetOrigin(var Pt: TVect) : Boolean;
var
 S: String;
begin
 S:=Specifics.Values['origin'];
 if S='' then
  Result:=False
 else
  try
   Pt:=LireVecteur(S);
   Result:=True;
  except
   Result:=False;
  end;
end;}

function TTreeMap.DernierOrigineSel(var Pt: TVect) : TTreeMap;
begin
 Result:=Self;
 repeat
  if Result.GetOrigin(Pt) then
   Exit;
  if Result.SousElements.Count=0 then
   begin
    Result:=Nil;
    Exit;
   end;
  Result:=TTreeMap(Result.SousElements.Last);
 until False;
end;

procedure TTreeMap.Deplacement(const PasGrille: Reel);
var
 I: Integer;
begin
 for I:=0 to SousElements.Count-1 do
  TTreeMap(SousElements[I]).Deplacement(PasGrille);
end;

(*function TTreeMap.AjouterRef(Liste: TList; Niveau: Integer) : Integer;
var
 I: Integer;
begin
 Result:=0;
 for I:=0 to SousElements.Count-1 do
  Inc(Result, TTreeMap(SousElements[I]).AjouterRef(Liste, Niveau+1));
end;*)

procedure TTreeMap.AddTo3DScene;
var
 I: Integer;
 T: TTreeMap;
begin
 for I:=0 to SousElements.Count-1 do
  begin
   T:=TTreeMap(SousElements[I]);
   if not Odd(T.SelMult) or (mdParcourirSel in Info.ModeDessin) then
    T.AddTo3DScene;
  end;
end;

procedure TTreeMap.ChercheExtremites(var Min, Max: TVect);
var
 I: Integer;
begin
 for I:=0 to SousElements.Count-1 do
  TTreeMap(SousElements[I]).ChercheExtremites(Min, Max);
end;

procedure TTreeMap.AnalyseClic;
var
 I: Integer;
begin
 for I:=0 to SousElements.Count-1 do
  TTreeMap(SousElements[I]).AnalyseClic(Liste);
end;

(*function TTreeMap.GetOrigin1: TVect;
begin
 if not GetOrigin(Result) then
  Result:=Origine;  { 0 0 0 }
end;

function TTreeMap.GetHasOrigin: Boolean;
begin
 Result:=Specifics.Values['origin']<>'';
end;

procedure TTreeMap.SetOrigin;
begin
 Specifics.Values['origin']:=vtos(nOrigin);
end;*)

(*procedure TTreeMap.Deplacement(const PasGrille: Reel);
var
 Pt: TVect;
begin
 if GetOrigin(Pt) then
  begin
   if Info.ModeDeplacement > mdDeplacementGrille then
    begin
     Pt.X:=Pt.X-Info.Clic.X;
     Pt.Y:=Pt.Y-Info.Clic.Y;
     Pt.Z:=Pt.Z-Info.Clic.Z;
     if Info.ModeDeplacement in [mdLineaire, mdLineaireCompat] then
      TransformationLineaire(Pt);
    end;
   Pt.X:=Pt.X+Info.Clic.X;
   Pt.Y:=Pt.Y+Info.Clic.Y;
   Pt.Z:=Pt.Z+Info.Clic.Z;
   if Info.ModeDeplacement in [mdDeplacementGrille, mdDeplacementGrilleFort] then
    AjusteGrille1(Pt, PasGrille);
   Origin:=Pt;
  end;
end;*)

procedure TTreeMap.SetSelFocus;
begin
end;

procedure TTreeMap.OpDansScene;
begin
 if PosRel=0 then
  begin
   if Aj=asAjoute then
    CheckTreeMap(Self);
   Info.TreeMapStatus:=Info.TreeMapStatus or tms_TreeMapChanged;
  end;
 inherited;
end;

procedure TTreeMap.FindTextures(SortedList: TStringList);
var
 I: Integer;
begin
 for I:=0 to SousElements.Count-1 do
  TTreeMap(SousElements[I]).FindTextures(SortedList);
end;

function TTreeMap.ReplaceTexture;
var
 I: Integer;
begin
 Result:=0;
 for I:=0 to SousElements.Count-1 do
  Inc(Result, TTreeMap(SousElements[I]).ReplaceTexture(Source, Dest, U));
end;

(*function TTreeMap.GetTreeView(var M: TMapExplorer) : Boolean;
var
 E: TQkExplorer;
begin
 E:=ExplorerFromObject(Self);
 Result:=(E<>Nil) and (E is TMapExplorer);
 if Result then
  M:=TMapExplorer(E);
end;*)

procedure TTreeMap.ListePolyedres;
begin
end;

procedure TTreeMap.ListeEntites;
begin
end;

procedure TTreeMap.SauverTexte;
begin
end;

function TTreeMap.GetFormName : String;
begin
 Result:=DefaultForm+TypeInfo;
end;

(*function TTreeMap.GetTMMenuState(Item: Integer) : Integer;
begin
 case I of
  tms_Specifics, tms_MultipleSpecifics
 else
  Result:=0;
 end;
end;*)

(*function TTreeMap.GetObjectMenu(Control: TControl) : TPopupMenu;
var
 Form4: TForm4;
 B: Boolean;
 Opt: TOptionsSelection;
begin
 Form4:=GetForm4(Self);
 if Form4<>Nil then
  with Form4 do
   begin
    Opt:=OptionsSelection;
    Details1.Visible:=osSpec in Opt;
    SpecSousEl3.Visible:=osGrAuto in Opt;
    B:=(osGrAuto in Opt) and (SpecSousElPossible>0);
    SpecSousEl3.Enabled:=B;
    B:=B and not (osBrush in Opt);
    SpecSousEl3.Default:=B;
    Details1.Default:=(osSpec in Opt) and not B and not ((osGr in Opt) and not (osBrush in Opt));
    CopieDuplicator1.Visible:=osDuplicator in Opt;
    DiggerPerm1.Visible:=osDigger in Opt;

    B:=(osPoly in Opt) or (osGrAuto in Opt);
    SoustraitPoly2.Visible:=B;
    IntersectPoly2.Visible:=B;
    CreusePoly2.Visible:=B;
    N15.Visible:=B;
    Texture6.Visible:=B;
   {CouperFace3.Visible:=B;
    if B then
     CouperFace3.Enabled:=PlanSelDist<PlanSel_Aucun;}
    IntersectPoly2.Enabled:=osGrAuto in Opt;

    B:=osFocus in Opt;
    Alignersurlagrille3.Visible:=B;
   {TagPoint.Visible:=B;
    Glue3.Visible:=B;}
    N7.Visible:=B;
    if B then
     begin
      Alignersurlagrille3.Caption:=LoadStr1(87 + Ord(osGrAuto in Opt))+#9'F';  { FIXME }
      Alignersurlagrille3.Enabled:=PasGrille>0;
     {B:=osFocusOrigin in Opt;
      TagPoint.Enabled:=B;
      Glue3.Enabled:=B and (PlanSelDist <> PlanSel_Aucun);}
     end;

   {GriserGroupe2.Visible:=osGr in Opt;
    CacherGroupe2.Visible:=osGr in Opt;
    N25.Visible:=osGr in Opt;
    if osGr in Opt then
     begin
      B:=(Info.SelectionVisuelle<>Nil) and (Info.SelectionVisuelle=TMSelUnique);
      GriserGroupe2.Checked:=B and GriserGroupe1.Checked;
      CacherGroupe2.Checked:=B and CacherGroupe1.Checked;
     end;}

    B:={BoutonCorbeille.Enabled} TvParent<>Nil;
    Couper2.Enabled:=B;
    SupprElement2.Enabled:=B;
    CollerGroupe1.Visible:=osGr in Opt;
    if osGr in Opt then
     CollerGroupe1.Enabled:=IsClipboardFormatAvailable(CF_QObjects);

    Result:=PopupTreeMap;
  (*for I:=0 to Result.Items.Count-1 do
     begin
      J:=GetTMMenuState(I);
      Result.Items[I].Visible:=J>=0;
      Result.Items[I].Enabled:=J>0;
     end;* )
   end
 else
  Result:=Nil;
end;*)

function TTreeMap.GetNegative: String;
begin
 Result:=Specifics.Values['neg'];
end;

procedure TTreeMap.SetNegative(const Neg: String);
begin
 Specifics.Values['neg']:=Neg;
end;

 {------------------------}

(*function qTextures(self, args: PyObject) : PyObject; cdecl;
var
 L: TStringList;
 I: Integer;
begin
 try
  L:=TStringList.Create; try
  L.Sorted:=True;
  (QkObjFromPyObj(self) as TTreeMap).FindTextures(L);
  Result:=PyList_New(L.Count);
  for I:=0 to L.Count-1 do
   PyList_SetItem(Result, I, PyString_FromString(PChar(L[I])));
  finally L.Free; end;
 except
  EBackToPython;
  Result:=Nil;
 end;
end;*)

function qReplaceTex(self, args: PyObject) : PyObject; cdecl;
var
 tOld, tNew: PChar;
 u: PyObject;
begin
 try
  Result:=Nil;
  u:=Nil;
  if not PyArg_ParseTupleX(args, 'ss|O', [@tOld, @tNew, @u]) then
   Exit;
  with QkObjFromPyObj(self) as TTreeMap do
   begin
    ToutCharger;
    Result:=PyInt_FromLong(ReplaceTexture(tOld, tNew, (u<>Nil) and PyObject_IsTrue(u)));
   end;
 except
  EBackToPython;
  Result:=Nil;
 end;
end;

function qRebuildAll(self, args: PyObject) : PyObject; cdecl;
var
 InvPoly, InvFaces: Integer;
begin
 try
  InvPoly:=0;
  InvFaces:=0;
  BuildPolyhedronsNow(QkObjFromPyObj(self), InvPoly, InvFaces);
  Result:=Py_BuildValueX('ii', [InvPoly, InvFaces]);
 except
  EBackToPython;
  Result:=Nil;
 end;
end;

const
 MethodTable: array[0..1] of TyMethodDef =
  ({(ml_name: 'textures';     ml_meth: qTextures;     ml_flags: METH_VARARGS),}
   (ml_name: 'replacetex';   ml_meth: qReplaceTex;   ml_flags: METH_VARARGS),
   (ml_name: 'rebuildall';   ml_meth: qRebuildAll;   ml_flags: METH_VARARGS));

function TTreeMap.PyGetAttr(attr: PChar) : PyObject;
var
 I: Integer;
begin
 Result:=inherited PyGetAttr(attr);
 if Result<>Nil then Exit;
 for I:=Low(MethodTable) to High(MethodTable) do
  if StrComp(attr, MethodTable[I].ml_name) = 0 then
   begin
    Result:=PyCFunction_New(MethodTable[I], @PythonObj);
    Exit;
   end;
end;

 {------------------------}

(*function TTreeMapSpec.ModeAngle(var S: String) : Integer;
begin
 Result:=0;
 if Specifics.Values['angle']<>'' then
  begin
   if Specifics.Values['light']='' then
    begin
     S:='angle';
     Result:=1;
    end;
  end
 else
  if Specifics.Values['mangle']<>'' then
   begin
    S:='mangle';
    Result:=3;
   end
  else
   if Specifics.Values['angles']<>'' then
    begin
     S:='angles';
     Result:=3;
    end;
end;

function TTreeMapSpec.CalculePosAngle(var V: TVect) : Integer;
var
 S: String;
 Code: Integer;
 Angle, Rapport: Reel;
 Origin: TVect;
begin
 Result:=0;
 if DernierOrigineSel(Origin)<>Nil then
  case ModeAngle(S) of
   1: begin
       S:=Specifics.Values[S];
       Val(S, Angle, Code);
       if Code=0 then
        if Angle=-1 then
         Result:=-1
        else
         if Angle=-2 then
          Result:=-2
         else
          begin
           Angle:=Angle*(pi/180);
           Rapport:=LongueurVectNormal/pProjZ;
           V.X:=Origin.X+Cos(Angle)*Rapport;
           V.Y:=Origin.Y+Sin(Angle)*Rapport;
           V.Z:=Origin.Z;
           Result:=1;
          end;
      end;
   3: try
       S:=Specifics.Values[S];
       with CalculeMAngle(LireVecteur(S)) do
        begin
         Rapport:=LongueurVectNormal/pProjZ;
         V.X:=Origin.X+X*Rapport;
         V.Y:=Origin.Y+Y*Rapport;
         V.Z:=Origin.Z+Z*Rapport;
        end;
       Result:=2;
      except
       {rien}
      end;
  end;
end;

function TTreeMapSpec.CalculePosEcran(var P: TPoint; var V: TVect) : Integer;
var
 Origin: TVect;
begin
 Result:=CalculePosAngle(V);
 case Result of
  -2: begin
       DernierOrigineSel(Origin);
       P:=CCoord.Proj(Origin);
       P.Y:=P.Y+12;
      end;
  -1: begin
       DernierOrigineSel(Origin);
       P:=CCoord.Proj(Origin);
       P.Y:=P.Y-12;
      end;
   0: ;
 else P:=CCoord.Proj(V);
 end;
end;

function TTreeMapSpec.VecteurNormalDirection(var V: TVect) : Boolean;
var
 Origin: TVect;
begin
 case CalculePosAngle(V) of
  -2: begin
       V.X:=0; V.Y:=0; V.Z:=-1;
       Result:=True;
      end;
  -1: begin
       V.X:=0; V.Y:=0; V.Z:=+1;
       Result:=True;
      end;
   0: Result:=False;
 else begin
       DernierOrigineSel(Origin);
       V.X:=V.X-Origin.X;
       V.Y:=V.Y-Origin.Y;
       V.Z:=V.Z-Origin.Z;
       Normalise(V);
       Result:=True;
      end;
 end;
end;*)

procedure TTreeMapSpec.Deplacement(const PasGrille: Reel);
var
 mx: PyObject;
begin
 inherited;
 if Info.ModeDeplacement=mdLineaire then
  begin
   mx:=MakePyMatrix(Info.Matrice); try
   Py_XDECREF(CallMacroEx(Py_BuildValueX('OO', [@PythonObj, mx]),
    'applylinear'));
   finally Py_DECREF(mx); end;
  end;
end;
{var
 V, Dest: TVect;
 AnglePlat: Integer;
 Spec, Chaine: String;}
(* if (Info.ModeDeplacement=mdLineaire)
 and VecteurNormalDirection(V) then
  begin
   TransformationLineaire(V);
   AnglePlat:=Round(Round(AngleXY(V.X,V.Y) * (180/pi)));
   case ModeAngle(Spec) of
    1: begin
        if Sqr(V.Z) > Sqr(V.X)+Sqr(V.Y) then
         if V.Z>0 then
          AnglePlat:=-1
         else
          AnglePlat:=-2
        else
         while AnglePlat<=0 do
          Inc(AnglePlat, 360);
        Specifics.Values[Spec]:=IntToStr(AnglePlat);
       end;
    3: begin
        Chaine:=Specifics.Values[Spec];
        Dest:=LireVecteur(Chaine);
        Dest.X:=Round(AngleXY(Sqrt(Sqr(V.X)+Sqr(V.Y)), V.Z) * (-180/pi));
        Dest.Y:=AnglePlat;
        Specifics.Values[Spec]:=vtos(Dest);
       end;
   end;
  end; *)

(*procedure TTreeMapSpec.PreDessinerSel;
var
 Form4: TForm4;
begin
 Form4:=GetForm4(Self);
 if Form4<>Nil then
  DrawMapMacros(Self, Form4.GetDrawMap, Form4.GetEntityList);
end;*)
(*procedure TTreeMapSpec.PreDessinerSel;
var
 Spec, Arg: String;
 Origin: TVect;
 OriginPt: TPoint;
 Direct: Boolean;
 OriginPen{, Pen}: HPen;
 Pen: array[Boolean] of HPen;
 Racine, Test: TTreeMap;

  procedure Parcourir(T: TTreeMap);
  var
   I: Integer;
   T1: TTreeMap;
   O2: TVect;
   O2Pt, Demi: TPoint;
   SelPen: HPen;
  begin
   for I:=0 to T.SousElements.Count-1 do
    begin
     T1:=TTreeMap(T.SousElements[I]);
     if T1 is TTreeMapSpec then
      begin
       if (CompareText(TTreeMapSpec(T1).Specifics.Values[Spec], Arg) = 0)
       and (T1.DernierOrigineSel(O2)<>Nil) and ProjEx(O2, O2Pt) then
        begin
         if Pen[False]=0 then
          Pen[False]:=CreatePen(ps_Solid, 3, MapColors(lcAxes));
         if Pen[True]=0 then
          Pen[True]:=CreatePen(ps_Solid, 2, MapColors(lcAxes));
         SelPen:=SelectObject(Info.DC, Pen[not Direct]);
         if OriginPen=0 then
          OriginPen:=SelPen;
         Demi.X:=(OriginPt.X+O2Pt.X) div 2;
         Demi.Y:=(OriginPt.Y+O2Pt.Y) div 2;
         Line16(Info.DC, OriginPt, Demi);
         SelectObject(Info.DC, Pen[Direct]);
         Line16(Info.DC, Demi, O2Pt);

        {if Pen=0 then
          begin
           Pen:=CreatePen(ps_Solid, 0, MapColors[lcAxes]);
           OriginPen:=SelectObject(Info.DC, Pen);
          end
         else
          SelectObject(Info.DC, Pen);
         Line16(Info.DC, OriginPt, O2Pt);
         Demi.X:=(OriginPt.X+O2Pt.X) div 2;
         Demi.Y:=(OriginPt.Y+O2Pt.Y) div 2;
         if PointVisible16(Demi) then
          begin
           MoveToEx(Info.DC, Demi.X, Demi.Y, Nil);
           LineTo(Info.DC,
          end;}
        end;
      {if T1 is TTreeMapGroup then}
        Parcourir(T1);
      end;
    end;
  end;

begin
 if (DernierOrigineSel(Origin)<>Nil) and ProjEx(Origin, OriginPt) then
  begin
   Test:=Self;
   repeat
    Racine:=Test;
    Test:=TTreeMap(Racine.TvParent);
   until Test=Nil;
   OriginPen:=0; Pen[False]:=0; Pen[True]:=0; {Pen:=0;}
   try
    Direct:=True;
    Arg:=Specifics.Values['target'];
    Spec:='targetname';
    if Arg<>'' then Parcourir(Racine);
    Direct:=False;
    Arg:=Specifics.Values['targetname'];
    Spec:='target';
    if Arg<>'' then Parcourir(Racine);
   finally
    if OriginPen<>0 then
     SelectObject(Info.DC, OriginPen);
    if Pen[False]<>0 then
     DeleteObject(Pen[False]);
    if Pen[True]<>0 then
     DeleteObject(Pen[True]);
   {if Pen<>0 then
     DeleteObject(Pen);}
   end;
  end;
end;*)

(*procedure TTreeMapSpec.PostDessinerSel;
var
 Pts: array[0..1] of TPoint;
 N, Origin: TVect;
 Vecteur, I,J: Integer;
 Brush: HBrush;
 R: TRect;
begin
 if DernierOrigineSel(Origin)=Nil then Exit;
 Pts[0]:=CCoord.Proj(Origin);
 if not PointVisible16(Pts[0]) then Exit;
 Vecteur:=CalculePosAngle(N);
 if Vecteur>0 then
  begin
   if Profondeur(Origin) < Profondeur(N) then
    begin
     I:=2;
     J:=-1;
    end
   else
    begin
     I:=0;
     J:=1;
    end;
   Pts[1]:=CCoord.Proj(N);
   if not PointVisible16(Pts[1]) then Exit;
  end
 else
  begin
   case Vecteur of
    -1: ImageList_Draw(GetMapIcons, 0, Info.DC, Pts[0].X-8, Pts[0].Y-24, ILD_NORMAL);
    -2: ImageList_Draw(GetMapIcons, 1, Info.DC, Pts[0].X-8, Pts[0].Y+8,  ILD_NORMAL);
   end;
   I:=0;
   J:=-1;
  end;
 repeat
  case I of
   0: DessinePoignee(Pts[0]);
   1: begin
       MoveToEx(Info.DC, Pts[0].X, Pts[0].Y, Nil);
       LineTo(Info.DC, Pts[1].X, Pts[1].Y);
      end;
   2: begin
       if Vecteur=1 then
        Brush:=GetStockObject(Gray_brush)
       else
        Brush:=CreateSolidBrush(clBlue);
       R:=Bounds(Pts[1].X-2, Pts[1].Y-1, 5, 3);
       FillRect(Info.DC, R, Brush);
       R:=Bounds(Pts[1].X-1, Pts[1].Y-2, 3, 5);
       FillRect(Info.DC, R, Brush);
       DeleteObject(Brush);
      end;
   else Break;
  end;
  Inc(I, J);
 until False;
end;

procedure TTreeMapSpec.DessinePoignee;
var
 Pt: TVect;
begin
 if DernierOrigineSel(Pt)<>Nil then
  PoigneeRouge(CCoord.Proj(Pt));
end;*)

procedure TTreeMapSpec.SauverSpec;
const
 LineStarts: array[Boolean] of String = (' "', '"');
var
 S, Msg, LineStart: String;
 P1, I, J, P: Integer;
begin
 Dest.Add('{');
 LineStart:=LineStarts[Flags and soBSP <> 0];
 Dest.Add(LineStart+SpecClassname+'" "'+Name+'"');
 for J:=0 to Specifics.Count-1 do
  begin
   S:=Specifics[J];
   if (S<>'') and (S[1]<>';') and (Ord(S[1])<chrFloatSpec) then
    begin
     P:=Pos('=', S);
     Msg:=Copy(S, P+1, 255);
     if (S[1]='#') and (HxStrings<>Nil) then
      begin
       I:=0;
       while (I<HxStrings.Count) and (Msg<>HxStrings[I]) do
        Inc(I);
       if I=HxStrings.Count then
        HxStrings.Add(Msg);
       Msg:=IntToStr(I+1);
       P1:=2;
       Dec(P);
      end
     else
      P1:=1;
    {$IFDEF RemoveEmptySpecs}
     if Msg<>'' then
    {$ENDIF}
      Dest.Add(LineStart+Copy(S, P1, P-1)+'" "'+Msg+'"');
    end;
  end;
end;

procedure TTreeMapSpec.CouleurDessin;
var
 S: String;
begin
 S:=Specifics.Values['_color'];
 if S<>'' then
  begin
   if Info.BasePen=White_pen then
    C:=clWhite
   else
    C:=clBlack;
   try
    C:=vtocol(LireVecteur(S));
   except
    {rien}
   end;
  end;
end;

 {------------------------}

class function TTreeMapEntity.TypeInfo: String;
begin
 TypeInfo:=':e';
end;

procedure TTreeMapEntity.EtatObjet;
begin
 inherited;
 E.IndexImage:=iiEntity;
end;

function TTreeMapEntity.GetOrigin(var Pt: TVect) : Boolean;
begin
 Result:=HasOrigin;
 if Result then
  Pt:=Origin;
end;

procedure TTreeMapEntity.SetOrigin;
begin
 Specifics.Values['origin']:=vtos(nOrigin);
 FOrigin:=nOrigin;
 FHasOrigin:=True;
end;

function TTreeMapEntity.RegleOrigine(Ancien: Boolean) : Boolean;
var
 S: String;
 Nouveau: TVect;
begin
 S:=Specifics.Values['origin'];
 Result:=(S<>'') xor (Ancien and FHasOrigin);
 FHasOrigin:=S<>'';
 if FHasOrigin then
  try
   Nouveau:=LireVecteur(S);
   Result:=Result
    or (Nouveau.X<>Origin.X)
    or (Nouveau.Y<>Origin.Y)
    or (Nouveau.Z<>Origin.Z);
   FOrigin:=Nouveau;
  except
   FHasOrigin:=False;
  end;
end;

procedure TTreeMapEntity.FixupReference;
begin
 Acces;
 RegleOrigine(False);
end;

procedure TTreeMapEntity.AnalyseClic;
var
 Pts: TPointProj;
begin
 if HasOrigin and (ModeProj < Vue3D) then
  begin
   Pts:=CCoord.Proj(Origin);
   CCoord.CheckVisible(Pts);
   if (Pts.OffScreen=0) and (Abs(Info.X-Pts.X) < 4) and (Abs(Info.Y-Pts.Y) < 4) then
    begin
   (*ModeProj:=TModeProj(1-Ord(ModeProj));
     Pts:=Proj(Origin);
     ModeProj:=TModeProj(1-Ord(ModeProj));
     if not PtInRect(Info.VisibleRect, Pts) then Exit;
     if not CCoord.Visible(Origin) then Exit;*)
     ResultatAnalyseClic(Liste, Pts, Nil);
    end;
  end;
 inherited; 
end;

(*procedure TTreeMapEntity.OpDansScene(Aj: TAjScene; PosRel: Integer);
var
 TreeView1: TMapExplorer;
begin
 inherited;
 if Aj in [asRetire, asDeplace1, asModifie] then
  RetireDeScene3D(Self);
 if Aj in [asAjoute, asDeplace2, asModifie] then
  begin
   if Aj in [asAjoute, asModifie] then
    if RegleOrigine(Aj=asModifie) and GetTreeView(TreeView1) then
     TreeView1.InvalidatePaintBoxes(0);
  {if (PosRel=0) and (Flags and ofTvNode <> 0) then
    GetNode.MakeVisible;}
   AjouteDansScene3D(Self);
  end;
end;*)

procedure TTreeMapEntity.ListeEntites(Entites: TQList);
begin
 Entites.Add(Self);
end;

procedure TTreeMapEntity.SauverTexte;
begin
 SauverSpec(Texte, HxStrings, Flags);
 Texte.Add('}');
end;

procedure TTreeMapEntity.ChercheExtremites;
var
 O: TVect;
begin
 if HasOrigin then
  begin
   O:=Origin;
   if Min.X > O.X then Min.X:=O.X;
   if Min.Y > O.Y then Min.Y:=O.Y;
   if Min.Z > O.Z then Min.Z:=O.Z;
   if Max.X < O.X then Max.X:=O.X;
   if Max.Y < O.Y then Max.Y:=O.Y;
   if Max.Z < O.Z then Max.Z:=O.Z;
  end;
end;

procedure TTreeMapEntity.Deplacement(const PasGrille: Reel);
var
 Pt: TVect;
begin
 RegleOrigine(False);
 if HasOrigin then
  begin
   Pt:=Origin;
   if Info.ModeDeplacement > mdDeplacementGrille then
    begin
     Pt.X:=Pt.X-Info.Clic.X;
     Pt.Y:=Pt.Y-Info.Clic.Y;
     Pt.Z:=Pt.Z-Info.Clic.Z;
     if Info.ModeDeplacement in [mdLineaire, mdLineaireCompat] then
      TransformationLineaire(Pt);
    end;
   Pt.X:=Pt.X+Info.Clic.X;
   Pt.Y:=Pt.Y+Info.Clic.Y;
   Pt.Z:=Pt.Z+Info.Clic.Z;
   if Info.ModeDeplacement in [mdDeplacementGrille, mdDeplacementGrilleFort] then
    AjusteGrille1(Pt, PasGrille);
   Origin:=Pt;
  end;
 inherited;
end;

{const
 NoCode: array[0..3] of Byte = (1,4,4,1);}

const
 NoCodeCubeX: array[0..5, 0..2] of Byte = ((0,0,3), (0,3,0), (0,3,0), (0,0,3), (0,0,0), (3,3,3));
 NoCodeCubeY: array[0..5, 0..2] of Byte = ((1,4,1), (1,1,4), (1,1,1), (4,4,4), (1,1,4), (1,4,1));
 NoCodeCubeZ: array[0..5, 0..2] of Byte = ((2,2,2), (5,5,5), (2,2,5), (2,5,2), (2,5,2), (2,2,5));

function TTreeMapEntity.GetBBoxInfo(var BBox: TBBoxInfo) : Boolean;
var
 S: String;
 Q: QObject;
 J: Integer;
begin
 Result:=False;
 S:={QuakeClassname}GetFormName;
 if S='' then Exit;
 Q:=CurrentMapView.EntityForms.FindLastShortName(S);
 if Q=Nil then Exit;
 Q.Acces;
 J:=Q.GetFloatsSpecPartial('BBox', BBox);
 case J of
  6: Result:=True;
  7: begin
      S:=Specifics.Values['scale'];
      if S<>'' then
       try
        BBox[6]:=StrToFloat(S);
       except
        {rien}
       end;
      if BBox[6]<>1.0 then
       for J:=0 to 5 do
        BBox[J]:=BBox[J]*BBox[6];
      Result:=True;
     end;
 end;
end;

procedure TTreeMapEntity.Dessiner;
var
 Pts: TPointProj;
 BBox: TBBoxInfo;
 V: TVect;
 R, {Max,} I, J, X1, Y1, X2, Y2: Integer;
{Facteur: Reel;
 Trait: TPoint;
 Form4: TForm4;}
 Vs: array[0..2] of TVect;
begin
 if HasOrigin then
  begin
  {OldPen:=0;}
   Pts:=CCoord.Proj(Origin);
   if not CCoord.CheckVisible(Pts) then Exit;
   if Info.PinceauSelection<>0 then
    begin
     SelectObject(Info.DC, Info.PinceauSelection);
     SetROP2(Info.DC, Info.BaseR2);
    end
   else
    if (Info.Restrictor=Nil) or (Info.Restrictor=Self) then   { True if object is not to be greyed out }
     if Info.ModeAff>0 then
      begin
       if Pts.OffScreen=0 then
        begin
         SelectObject(Info.DC, Info.PinceauNoir);
         SetROP2(Info.DC, R2_CopyPen);
        end
       else
        begin
         if Info.ModeAff=2 then
          Exit;
         SelectObject(Info.DC, Info.PinceauGris);
         SetROP2(Info.DC, Info.MaskR2);
        end;
      end
     else
     {if Info.ModeAff=0 then}
       begin
        SelectObject(Info.DC, Info.PinceauNoir);
        SetROP2(Info.DC, R2_CopyPen);
       end
    else
     begin   { Restricted }
      SelectObject(Info.DC, Info.PinceauGris);
      SetROP2(Info.DC, Info.MaskR2);
     end;
   X1:=Round(Pts.x);
   Y1:=Round(Pts.y);
   MoveToEx(Info.DC, X1-3, Y1, Nil);
   LineTo  (Info.DC, X1+4, Y1);
   MoveToEx(Info.DC, X1, Y1-2, Nil);
   LineTo  (Info.DC, X1, Y1+3);
   if Info.PinceauSelection<>0 then
    begin
     SelectObject(Info.DC, Info.PinceauSelection);
     SetROP2(Info.DC, R2_CopyPen);
     Ellipse(Info.DC, X1-7, Y1-7, X1+8, Y1+7);
    end;
  {else}
    if (Info.DessinerBBox and (BBox_Actif or BBox_Cadre)
                            = (BBox_Actif or BBox_Cadre))
    or (Odd(SelMult) and
       (Info.DessinerBBox and (BBox_Actif or BBox_Selection)
                            = (BBox_Actif or BBox_Selection))) then
     begin
      if not GetBBoxInfo(BBox) then Exit;

       { object has a BBox }
      if CCoord.Orthogonal then
       begin
        with Origin do
         begin
          V.X:=X+BBox[0];
          V.Y:=Y+BBox[1];
          V.Z:=Z+BBox[2];
          Pts:=CCoord.Proj(V);
          X1:=Round(Pts.x);
          Y1:=Round(Pts.y);
          V.X:=X+BBox[3];
          V.Y:=Y+BBox[4];
          V.Z:=Z+BBox[5];
          Pts:=CCoord.Proj(V);
          X2:=Round(Pts.x);
          Y2:=Round(Pts.y);
         end;
        if X1>X2 then begin R:=X1; X1:=X2; X2:=R; end;
        if Y1>Y2 then begin R:=Y1; Y1:=Y2; Y2:=R; end;
        MoveToEx(Info.DC, X1+3, Y1, Nil);
        LineTo  (Info.DC, X1, Y1);
        LineTo  (Info.DC, X1, Y1+3);
        MoveToEx(Info.DC, X2-3, Y1, Nil);
        LineTo  (Info.DC, X2, Y1);
        LineTo  (Info.DC, X2, Y1+3);
        MoveToEx(Info.DC, X1+3, Y2, Nil);
        LineTo  (Info.DC, X1, Y2);
        LineTo  (Info.DC, X1, Y2-3);
        MoveToEx(Info.DC, X2-3, Y2, Nil);
        LineTo  (Info.DC, X2, Y2);
        LineTo  (Info.DC, X2, Y2-3);
       end
      else
       with Origin do
        for I:=0 to 5 do
         begin
          for J:=0 to 2 do
           begin
            Vs[J].X:=X+BBox[NoCodeCubeX[I,J]];
            Vs[J].Y:=Y+BBox[NoCodeCubeY[I,J]];
            Vs[J].Z:=Z+BBox[NoCodeCubeZ[I,J]];
           end;
          CCoord.Rectangle3D(Vs[0], Vs[1], Vs[2], False);
         end;
      (*with Origin do
         begin
          V.Z:=Z+BBox[2];
          for R:=0 to 3 do
           begin
            V.X:=X+BBox[3*(R shr 1)];
            V.Y:=Y+BBox[NoCode[R]];
            Pts[R]:=CCoord.Proj(V);
           end;
         end;
        case ModeProj of
         VueXY: begin
                 MoveToEx(Info.DC, Pts[0].X, Pts[0].Y, Nil);
                 for R:=0 to 3 do
                  with Pts[Succ(R) and 3] do
                   begin
                    Facteur:=Sqr(X-Pts[R].X)+Sqr(Y-Pts[R].Y);
                    if Facteur<rien2 then Exit;
                    Facteur:=3.5/Sqrt(Facteur);
                    Trait.X:=Round(Facteur*(X-Pts[R].X));
                    Trait.Y:=Round(Facteur*(Y-Pts[R].Y));
                    LineTo(Info.DC, Pts[R].X + Trait.X, Pts[R].Y + Trait.Y);
                    MoveToEx(Info.DC, X - Trait.X, Y - Trait.Y, Nil);
                    LineTo(Info.DC, X,Y);
                   end;
                 Exit;
                end;
         VueXZ: begin
                 Max:=-MaxInt;
                 for R:=0 to 3 do
                  begin
                   if Pts[R].X>Max then Max:=Pts[R].X;
                   if Pts[R].X<Pts[0].X then Pts[0].X:=Pts[R].X;
                  end;
                 Pts[1].X:=Max;
                 V.Z:=Origin.Z+BBox[5];
                 Pts[0].Y:=CCoord.Proj(V).Y;
                end;
         else Exit;
        end;
       end;*)
     end;
  end;
end;

procedure TTreeMapEntity.PreDessinerSel;
{const
 FacteurCorrectionLumiere = 0.9;}
var
 Pts: TPointProj;
 BBox: TBBoxInfo;
 V: TVect;
 R{, Min,Max}: Integer;
{Brush: HBrush;
 Pen: HPen;
 Rayon: Reel;}
 OriginPt: TPointProj;
{Form4: TForm4;}
 I, J, X1, Y1, X2, Y2: Integer;
 Vs: array[0..2] of TVect;
begin
 inherited;
 if HasOrigin then
  begin
   OriginPt:=CCoord.Proj(Origin);
 (*S:=Specifics.Values['light'];
   if S<>'' then
    try
     Rayon:=StrToFloat(S)*pProjZ*SetupGameSet.GetFloatSpec('LightFactor', 0.9);
     if (Rayon > 1.5) and (Rayon < 8192) then
      begin
       Pts[1].X:=Round(Rayon);
       Brush:=SelectObject(Info.DC, GetStockObject(Null_brush));
       Pen:=SelectObject(Info.DC, CreatePen(ps_Solid, 2, MapColors(lcAxes)));
       Ellipse(Info.DC, OriginPt.X-Pts[1].X, OriginPt.Y-Pts[1].X,
                        OriginPt.X+Pts[1].X+1, OriginPt.Y+Pts[1].X+1);
       DeleteObject(SelectObject(Info.DC, Pen));
       SelectObject(Info.DC, Brush);
      end;
    except
     {rien}
    end;*)
   if Info.DessinerBBox and (BBox_Actif or BBox_Selection)
                          = (BBox_Actif or BBox_Selection) then
    if GetBBoxInfo(BBox) then
     begin
        { object has a BBox }
      if CCoord.Orthogonal then
       begin
        with Origin do
         begin
          V.X:=X+BBox[0];
          V.Y:=Y+BBox[1];
          V.Z:=Z+BBox[2];
          Pts:=CCoord.Proj(V);
          X1:=Round(Pts.x);
          Y1:=Round(Pts.y);
          V.X:=X+BBox[3];
          V.Y:=Y+BBox[4];
          V.Z:=Z+BBox[5];
          Pts:=CCoord.Proj(V);
          X2:=Round(Pts.x);
          Y2:=Round(Pts.y);
         end;
        if X1>X2 then begin R:=X1; X1:=X2; X2:=R; end;
        if Y1>Y2 then begin R:=Y1; Y1:=Y2; Y2:=R; end;
        Rectangle95(Info.DC, X1,Y1, X2+2,Y2+2);
       end
      else
       with Origin do
        for I:=0 to 5 do
         begin
          for J:=0 to 2 do
           begin
            Vs[J].X:=X+BBox[NoCodeCubeX[I,J]];
            Vs[J].Y:=Y+BBox[NoCodeCubeY[I,J]];
            Vs[J].Z:=Z+BBox[NoCodeCubeZ[I,J]];
           end;
          CCoord.Rectangle3D(Vs[0], Vs[1], Vs[2], True);
         end;
    (*if CCoord.Orthogonal then
       begin
        with Origin do
         begin
          V.X:=X+BBox[0];
          V.Y:=Y+BBox[1];
          V.Z:=Z+BBox[2];
          Pts[0]:=CCoord.Proj(V);
          V.X:=X+BBox[3];
          V.Y:=Y+BBox[4];
          V.Z:=Z+BBox[5];
          Pts[1]:=CCoord.Proj(V);
         end;
        if Pts[0].X>Pts[1].X then begin R:=Pts[0].X; Pts[0].X:=Pts[1].X; Pts[1].X:=R; end;
        if Pts[0].Y>Pts[1].Y then begin R:=Pts[0].Y; Pts[0].Y:=Pts[1].Y; Pts[1].Y:=R; end;
        Rectangle16(Info.DC, Pts[0].X,Pts[0].Y, Pts[1].X+2,Pts[1].Y+2);
        Exit;
       end;
      with Origin do
       begin
        V.Z:=Z+BBox[2];
        for R:=0 to 3 do
         begin
          V.X:=X+BBox[3*(R shr 1)];
          V.Y:=Y+BBox[NoCode[R]];
          Pts[R]:=CCoord.Proj(V);
         end;
       end;
      case ModeProj of
       VueXY: begin
               Polygon16(Info.DC, Pts, 4);
               Exit;
              end;
       VueXZ: begin
               Min:=MaxInt;
               Max:=-MaxInt;
               for R:=0 to 3 do
                begin
                 if Pts[R].X>Max then Max:=Pts[R].X;
                 if Pts[R].X<Min then Min:=Pts[R].X;
                end;
               V.Z:=Origin.Z+BBox[5];
               with CCoord.Proj(V) do
                Rectangle16(Info.DC, Min,Y, Max+2,Pts[0].Y+2);
               Exit;
              end;
      end;*)
     end;
   if CCoord.CheckVisible(OriginPt) then
    begin
     X1:=Round(OriginPt.x);
     Y1:=Round(OriginPt.y);
     Ellipse(Info.DC, X1-7, Y1-7, X1+8, Y1+7);
    end;
  end;
end;

(*procedure TTreeMapEntity.DessinePoignee(const Pts0: TPoint);
begin
 ImageList_Draw(GetMapIcons, 10, Info.DC, Pts0.X-8, Pts0.Y-8,
  ILD_NORMAL);
end;*)

function TTreeMapEntity.GetFormName : String;
begin
 Result:=Name;
end;

(*function TTreeMapEntity.AjouterRef(Liste: TList; Niveau: Integer) : Integer;
var
 Form4: TForm4;
 Info: TModelDisplayInfo;
begin
 Result:=0;
 if not HasOrigin then Exit;
 Form4:=GetForm4(Self);
 if (Form4=Nil) or not (mtViewModels in Form4.Toggle4) then Exit;
 if Display3DModel(Form4, Info) then
  with Info do
   Result:=ModelRoot.AjouterRefFS(Liste, Frame, Skin, Origin, Self);
end;*)

function TTreeMapEntity.AddModelTo3DScene : Boolean;
var
 S, MdlPath, MdlBase: String;
 Q, FileObj1: QObject;
 Mdl: QModel;
 Frame1: QFrame;
 Skin1: QImages;
 Root: QMdlObject;
 Component: QComponent;
 L: TQList;
 Model: PModel3DInfo;
 VSrc: vec3_p;
 VDest: vec3_p;
 I, K, Count: Integer;
 ModelOrg: vec3_t;
 Angle: Integer;
 ASin, ACos: Reel;
 SkinDescr: String;

begin
 Result:=False;
 try
  S:=GetFormName;
  if S='' then Exit;
  Q:=CurrentMapView.EntityForms.FindLastShortName(S);
  if Q=Nil then Exit;
  Q.Acces;
  MdlPath:=Q.Specifics.Values['mdl'];
  if MdlPath='' then Exit;

   { loads mdl }
  MdlBase:=Q.Specifics.Values['mdlbase'];
  if MdlBase='' then
   FileObj1:=NeedGameFile(MdlPath)
  else
   FileObj1:=NeedGameFileBase(MdlBase, MdlPath);
  if not (FileObj1 is QModel) then Exit;
  Mdl:=QModel(FileObj1);
  Mdl.Acces;
  Root:=Mdl.GetRoot;
  if Root=Nil then Exit;

   { prepare positionning }
  with Origin do
   begin
    ModelOrg[0]:=X;
    ModelOrg[1]:=Y;
    ModelOrg[2]:=Z;
   end;
  S:=Specifics.Values['angle'];
  if (S<>'') and (S<>'0') and (S<>'360') then
   Angle:=Round(StrToFloatDef(S, 0)) mod 360
  else
   Angle:=0;
  if Angle<>0 then
   begin
    ASin:=Angle*(pi/180);
    ACos:=Cos(ASin);
    ASin:=Sin(ASin);
   end
  else
   begin
    ACos:=0;
    ASin:=0;
   end;

   { list components }
  L:=TQList.Create; try
  Root.BuildRefList(L);
  for I:=0 to L.Count-1 do
   begin
     { find frame & skin }
    Component:=QComponent(L[I]);
    S:=Q.Specifics.Values['mdlframe'];
    if S<>'' then
     Frame1:=Component.GetFrameFromName(S)
    else
     Frame1:=Component.GetFrameFromIndex(Round(Q.GetFloatSpec('mdlframe', 0)));
    if Frame1=Nil then Continue;
    S:=Q.Specifics.Values['mdlskin'];
    if S<>'' then
     Skin1:=Component.GetSkinFromName(S)
    else
     Skin1:=Component.GetSkinFromIndex(Round(Q.GetFloatSpec('mdlskin', 0)));
    if (Skin1=Nil) and (S<>'') and ModeJeuQuake2 then
     begin  { load skin from external file }
      if MdlBase='' then
       begin
        FileObj1:=NeedGameFile(S);
        SkinDescr:=S;
       end
      else
       begin
        FileObj1:=NeedGameFileBase(MdlBase, S);
        SkinDescr:=MdlBase+':'+S;
       end;
      if FileObj1 is QImages then
       Skin1:=QImages(FileObj1);
     end
    else
     if Skin1=Nil then
      SkinDescr:='*'
     else
      SkinDescr:=Format('%s:%s:%s', [MdlBase, MdlPath, Skin1.Name]);

    Count:=Frame1.GetVertices(VSrc);
    GetMem(Model, SizeOf(TModel3DInfo)+Count*SizeOf(vec3_t));
    try
     Model^.VertexCount:=Count;
     PChar(VDest):=PChar(Model)+SizeOf(TModel3DInfo);
     Model^.Vertices:=VDest;
     if Angle=0 then
      for K:=0 to Count-1 do
       begin
        VDest^[0]:=VSrc^[0]+ModelOrg[0];
        VDest^[1]:=VSrc^[1]+ModelOrg[1];
        VDest^[2]:=VSrc^[2]+ModelOrg[2];
        Inc(VSrc);
        Inc(VDest);
       end
     else
      for K:=0 to Count-1 do
       begin
        VDest^[0]:=VSrc^[0]*ACos - VSrc^[1]*ASin + ModelOrg[0];
        VDest^[1]:=VSrc^[0]*ASin + VSrc^[1]*ACos + ModelOrg[1];
        VDest^[2]:=VSrc^[2]+ModelOrg[2];
        Inc(VSrc);
        Inc(VDest);
       end;
      { find alpha }
     Model^.ModelAlpha:=Round(255*Q.GetFloatSpec('mdlopacity', 1));
    except
     FreeMem(Model);
     Raise;
    end;

    Model^.Base:=Component.QuickSetSkin(Skin1, SkinDescr);
    Model^.StaticSkin:=True;
    CurrentMapView.Scene.ModelInfo.Add(Model);
    Result:=True;
   end;

  finally L.Free; end;
 except
  {rien}
 end;
end;

procedure TTreeMapEntity.AddTo3DScene;
var
 Light: Single;
 L4: array[1..4] of Reel;
 L3: array[1..3] of Reel;
 S: String;
 Color: TColorRef;
begin
 if HasOrigin then
  begin
   if (CurrentMapView.Scene.ViewEntities<>veNever) then
    begin
     if (CurrentMapView.Scene.ViewEntities=veModels) and AddModelTo3DScene then
      Exit;
     {FIXME: bounding boxes in 3D view}
    end;
   if CompareText(Copy(Name,1,5), 'light')=0 then
    begin
     Light:=StrToIntDef(Specifics.Values['light'], 0);
     if Light<=0 then
      begin
       S:=Specifics.Values['_light'];
       if S='' then Exit;
       try
        LireValeurs(S, L4);
       except
        Exit;
       end;
       Light:=L4[4];
       Color:=Round(L4[1]) or (Round(L4[2]) shl 8) or (Round(L4[3]) shl 16);
      end
     else
      begin
       Color:=clWhite;
       S:=Specifics.Values['_color'];
       if S<>'' then
        begin
         try
          LireValeurs(S, L3);
          Color:=Round(255*L3[1]) or (Round(255*L3[2]) shl 8) or (Round(255*L3[3]) shl 16);
         except
          {rien}
         end;
        end;
      end;
     CurrentMapView.Scene.AddLight(Origin, Light, Color);
    end;
  end;
end;

(*procedure TTreeMapEntity.Display3DModel(var Info: TModelDisplayInfo) : Boolean;
var
 S, MdlPath, MdlBase: String;
 Q, FileObj1: QObject;
 Mdl: QModel;
 Skin1: QSkin;
begin
 Result:=False;
 try
  S:=GetFormName;
  if S='' then Exit;
  Q:=CurrentMapView.EntityForms.FindLastShortName(S);
  if Q=Nil then Exit;
  Q.Acces;
  MdlPath:=Q.Specifics.Values['mdl'];
  if MdlPath='' then Exit;

   { loads mdl }
  MdlBase:=Q.Specifics.Values['mdlbase'];
  if MdlBase='' then
   FileObj1:=NeedGameFile(MdlPath)
  else
   FileObj1:=NeedGameFileBase(MdlBase, MdlPath);
  if not (FileObj1 is QModel) then Exit;
  Mdl:=QModel(FileObj1);

   { find frame & skin }
  Mdl.Acces;
  Info.ModelRoot:=Mdl.GetRoot;
  if Info.ModelRoot=Nil then Exit;
  S:=Q.Specifics.Values['mdlframe'];
  if S<>'' then
   Info.Frame:=Info.ModelRoot.GetFrameFromName(S)
  else
   Info.Frame:=Info.ModelRoot.GetFrameFromN(Round(Q.GetFloatSpec('mdlframe', 0)));
  if Info.Frame=Nil then Exit;
  S:=Q.Specifics.Values['mdlskin'];
  if S<>'' then
   Skin1:=Info.ModelRoot.GetSkinFromName(S)
  else
   Skin1:=Info.ModelRoot.GetSkinFromN(Round(Q.GetFloatSpec('mdlskin', 0)));
  if Skin1=Nil then
   begin
    Info.SkinImage:=Nil;
    Info.SkinDescr:='';
    if (S<>'') and ModeJeuQuake2 then
     begin  { load skin from external file }
      if MdlBase='' then
       FileObj1:=NeedGameFile(S)
      else
       FileObj1:=NeedGameFileBase(MdlBase, S);
      if FileObj1 is QImages then
       begin
        Info.SkinImage:=QImages(FileObj1);
        Info.SkinDescr:=':'+S;
       end;
     end;
   end
  else
   begin
    Info.SkinImage:=Skin1.SourceImage;
    Info.SkinDescr:=Skin1.BuildSkinDescr;  {':'+MdlPath+':'+Skin1.Name;}
   end;

   { find alpha }
  Info.Alpha:=Round(255*Q.GetFloatSpec('mdlopacity', 1));
  Result:=True;
 except
  {rien}
 end;
end;*)

function TTreeMapEntity.PyGetAttr(attr: PChar) : PyObject;
var
 BBox: TBBoxInfo;
begin
 Result:=inherited PyGetAttr(attr);
 if Result<>Nil then Exit;
 case attr[0] of
  'b': if StrComp(attr, 'bbox')=0 then
        begin
         if GetBBoxInfo(BBox) then
          Result:=Py_BuildValueX('OO', [MakePyVect3(BBox[0], BBox[1], BBox[2]),
                                        MakePyVect3(BBox[3], BBox[4], BBox[5])])
         else
          Result:=PyNoResult;
         Exit;
        end;
 end;
end;

 {------------------------}

class function TTreeMapGroup.TypeInfo: String;
begin
 TypeInfo:=':g';
end;

procedure TTreeMapGroup.EtatObjet;
begin
 inherited;
 E.IndexImage:=iiGroup;
end;

function TTreeMapGroup.IsExplorerItem(Q: QObject) : TIsExplorerItem;
begin
 Result:=ieResult[(Q is TTreeMap) {and not (Q is TFace)}];
end;

procedure TTreeMapGroup.Dessiner;
var
 I, Flags: Integer;
 T: TTreeMap;
 NewPen, OldPen, DeletePen: HPen;
{S: String;}
 C: TColor;
 IsRestrictor: Boolean;
begin
 NewPen:=0;
 DeletePen:=0;
 if Info.PinceauGris <> 0 then
  begin    { if color changes must be made now }
   Flags:=ViewFlags;
   if Flags and vfHidden <> 0 then Exit;
   if Flags and vfGrayedout <> 0 then
    NewPen:=Info.PinceauGris;
  {if Self = Info.SelectionVisuelle then
    begin
     Info.GroupeOuvert:=False;
     NewPen:=GetStockObject(Info.BasePen);
    end;}
   if {not Info.GroupeOuvert and} not Odd(SelMult) then
    begin
     C:=clNone;
     CouleurDessin(C);
     if (C=clNone) and (Negative<>'') then
      C:=MapColors(lcDigger);
     if C<>clNone then
      begin
       DeletePen:=CreatePen(ps_Solid, 0, C);
       NewPen:=DeletePen;
      end;
    end;
  end;
 if NewPen<>0 then
  begin
   OldPen:=Info.PinceauNoir;
   Info.PinceauNoir:=NewPen;
  end
 else
  OldPen:=0;
 IsRestrictor:=Info.Restrictor=Self;
 if IsRestrictor then Info.Restrictor:=Nil;
 for I:=0 to SousElements.Count-1 do
  begin
   T:=TTreeMap(SousElements[I]);
   if not Odd(T.SelMult) or (mdParcourirSel in Info.ModeDessin) then
    T.Dessiner;
  end;
 if IsRestrictor then Info.Restrictor:=Self;
 if OldPen<>0 then
  begin
   SelectObject(Info.DC, OldPen);
   Info.PinceauNoir:=OldPen;
   if DeletePen<>0 then
    DeleteObject(DeletePen);
  end;
{if Self = Info.SelectionVisuelle then
  Info.GroupeOuvert:=True;}
end;

function TTreeMapGroup.GetViewFlags: Integer;
begin
 if Specifics.IndexOfName(';view')<0 then
  Result:=0   { optimized exit path }
 else
  Result:=StrToIntDef(Specifics.Values[';view'], 0);
end;

procedure TTreeMapGroup.SetViewFlags(Flags: Integer);
var
 P: Integer;
begin
 if Flags=0 then
  P:=sp_Supprime
 else
  P:=sp_Auto;
 Action(Self, TSpecificUndo.Create(LoadStr1(590), ';view', IntToStr(Flags), P, Self));
end;

procedure TTreeMapGroup.AddTo3DScene;
begin
 if ViewFlags and vfHideOn3Dview = 0 then
  if Info.ModeDessin * [mdComputePolys, mdComputingPolys] = [mdComputePolys] then
   begin
    Include(Info.ModeDessin, mdComputingPolys);
    inherited;
    Exclude(Info.ModeDessin, mdComputingPolys);
    Compute3DDiggers;
   end
  else
   inherited;
end;

procedure TTreeMapGroup.AnalyseClic;
begin
 if ViewFlags and vfCantSelect = 0 then
  inherited;
end;

{function TTreeMapGroup.SingleLevel: Boolean;
begin
 SingleLevel:=False;
end;}

function ControleSelection(T: TTreeMap) : Boolean;
var
 I: Integer;
begin
 ControleSelection:=True;
 if not Odd(T.SelMult) then
  begin
   if (T.SelMult and smSousSelVide = 0) and (T is TTreeMapGroup) then
    with TTreeMapGroup(T).SousElements do
     for I:=0 to Count-1 do
      if ControleSelection(TTreeMap(Items[I])) then
       Exit;
   ControleSelection:=False;
  end;
end;

procedure TTreeMapGroup.ListePolyedres;
var
 Pile, I: Integer;
 T: TTreeMap;
 Neg: Boolean;
 L: TQList;
 S: String;
begin
 S:=Negative;
{...}
 Neg:=S<>'';
 if (Brushes<0) xor Neg then
  Exit;
 if Neg then
  begin
   Brushes:=MaxInt;
   L:=Negatif;
   Negatif:=Polyedres;
   Polyedres:=L;
  end
 else
  if ((Flags and soIgnoreToBuild <> 0)
  and (ViewFlags and vfIgnoreToBuildMap <> 0))
  or ((Flags and soAddTo3DScene<> 0)
  and (ViewFlags and vfHideOn3DView <> 0)) then
   Exit;
 Pile:=Negatif.Count;
 for I:=0 to SousElements.Count-1 do
  TTreeMap(SousElements[I]).ListePolyedres(Polyedres, Negatif, 0, -1);
 if Odd(SelMult) or Neg then
  Flags:=Flags and not soSelOnly;
 for I:=0 to SousElements.Count-1 do
  begin
   T:=TTreeMap(SousElements[I]);
   if ((Flags and soSelOnly = 0) or ControleSelection(T))
   and (not Odd(T.SelMult) or (Flags and soNonParcourirSel = 0)) then
    T.ListePolyedres(Polyedres, Negatif, Flags and not soDirectDup, Brushes);
  end;
 for I:=Negatif.Count-1 downto Pile do
  Negatif.Delete(I);
end;

procedure TTreeMapGroup.ListeEntites(Entites: TQList);
var
 I: Integer;
begin
 for I:=0 to SousElements.Count-1 do
  TTreeMap(SousElements[I]).ListeEntites(Entites);
end;

procedure TTreeMapGroup.SauverTexte;
var
 I: Integer;
 T: TTreeMap;
begin
 if (Flags and soIgnoreToBuild <> 0)
 and (ViewFlags and vfIgnoreToBuildMap <> 0) then
  Exit;
 if Odd(SelMult) then
  Flags:=Flags and not soSelOnly;
 for I:=0 to SousElements.Count-1 do
  begin
   T:=TTreeMap(SousElements[I]);
   if (Flags and soSelOnly = 0) or ControleSelection(T) then
    T.SauverTexte(Negatif, Texte, Flags, HxStrings);
  end;
end;

procedure TTreeMapGroup.Compute3DDiggers;
var
 Polyedres, Negatifs: TQList;
 I, J: Integer;
 P: TPolyedre;
begin
 Negatifs:=TQList.Create;
 Polyedres:=TQList.Create;
 try
  I:=soAddTo3DScene;
  if not (mdParcourirSel in Info.ModeDessin) then
   Inc(I, soNonParcourirSel);
  ListePolyedres(Polyedres, Negatifs, I, 1);
  for I:=0 to Polyedres.Count-1 do
   begin
    P:=TPolyedre(Polyedres[I]);
    if P.CheckPolyhedron then
     begin
      if P.PythonObj.ob_refcnt = 1 then
       CurrentMapView.Scene.TemporaryStuff.Add(P);
      for J:=0 to P.Faces.Count-1 do
       CurrentMapView.Scene.PolyFaces.Add(P.Faces[J])
     end;
   end;
 finally
  Polyedres.Free;
  Negatifs.Free;
 end;
end;

 {------------------------}

class function TTreeMapBrush.TypeInfo: String;
begin
 TypeInfo:=':b';
end;

procedure TTreeMapBrush.EtatObjet;
begin
 inherited;
 E.IndexImage:=iiBrush;
end;

procedure TTreeMapBrush.CouleurDessin;
begin
 if (TvParent<>Nil) and (FParent is TTreeMap) then
  C:=MapColors(lcBrushEntity);
 inherited;
end;

procedure TTreeMapBrush.ListePolyedres;
begin
 if Brushes>0 then
  inherited ListePolyedres(Polyedres, Negatif, Flags and not soDirectDup, Brushes-1);
end;

procedure TTreeMapBrush.ListeEntites(Entites: TQList);
begin
 Entites.Add(Self);
 inherited;
end;

procedure TTreeMapBrush.SauverTexte;
var
 Polyedres: TQList;
 I: Integer;
 V1, V2: TVect;
 OriginBrush: PVect;
begin
 SauverSpec(Texte, HxStrings, Flags);
 if Flags and soBSP = 0 then
  begin
   Polyedres:=TQList.Create; try
   ListePolyedres(Polyedres, Negatif, Flags and not soDirectDup, 1);
   OriginBrush:=Nil;
   if (Flags and soOutsideWorldspawn <> 0) and (CharModeJeu>=mjQuake2) then
    for I:=Polyedres.Count-1 downto 0 do
     with TPolyedre(Polyedres[I]) do
      if CheckPolyhedron and (Faces.Count>0)
      and (StrToIntDef(PSurface(Faces[0]).F.Specifics.Values['Contents'], 0) and ContentsOrigin <> 0) then
       begin
        V1.X:=MaxInt;
        V1.Y:=MaxInt;
        V1.Z:=MaxInt;
        V2.X:=-MaxInt;
        V2.Y:=-MaxInt;
        V2.Z:=-MaxInt;
        ChercheExtremites(V1, V2);
        if V1.X<V2.X then
         begin
          V1.X:=0.5*(V1.X+V2.X);
          V1.Y:=0.5*(V1.Y+V2.Y);      { center of the 'origin brush' }
          V1.Z:=0.5*(V1.Z+V2.Z);
          OriginBrush:=@V1;
         end;
        Break;
       end;
   for I:=0 to Polyedres.Count-1 do
    TPolyedre(Polyedres[I]).SauverTextePolyedre(Texte, OriginBrush, Flags);
   finally Polyedres.Free; end;
  end;
 Texte.Add('}');
 inherited SauverTexte(Negatif, Texte, Flags or soOutsideWorldspawn, HxStrings);
end;

procedure TTreeMapBrush.AddTo3DScene;
var
 MD: TModeDessin;
begin
 MD:=Info.ModeDessin;
 if mdComputePolys in MD then
  Include(Info.ModeDessin, mdComputingPolys);
 inherited;
 Info.ModeDessin:=MD;
 if mdComputePolys in MD then
  Compute3DDiggers;
end;

function TTreeMapBrush.GetFormName : String;
begin
 Result:=Name;
end;

function TTreeMapBrush.IsExplorerItem(Q: QObject) : TIsExplorerItem;
begin
 Result:=inherited IsExplorerItem(Q) + [ieNoAutoDrop];
end;

function TTreeMapBrush.PyGetAttr(attr: PChar) : PyObject;
var
 Polyedres, Negatifs, Entites: TQList;
begin
 Result:=inherited PyGetAttr(attr);
 if Result<>Nil then Exit;
 case attr[0] of
  'l': if StrComp(attr, 'listpolyhedrons')=0 then
        begin
         Negatifs:=TQList.Create;
         Polyedres:=TQList.Create;
         try
          ListePolyedres(Polyedres, Negatifs, 0, 1);
          Result:=QListToPyList(Polyedres);
         finally
          Polyedres.Free;
          Negatifs.Free;
         end;
         Exit;
        end
       else if StrComp(attr, 'listentities')=0 then
        begin
         Entites:=TQList.Create; try
         ListeEntites(Entites);
         Result:=QListToPyList(Entites);
         finally Entites.Free; end;
         Exit;
        end;
 end;
end;

 {------------------------}

initialization
  RegisterQObject(TTreeMapEntity, 'a');
  RegisterQObject(TTreeMapGroup, 'a');
  RegisterQObject(TTreeMapBrush, 'a');
  Info.ConstruirePolyedres:=True;
end.
