Attribute VB_Name = "mWin32API"
'---------------------------------------------------------------------------
'Copyright 1997-1998 by Brian Kelly
'
'This program is free software; you can redistribute it and/or
'modify it under the terms of the GNU General Public License
'as published by the Free Software Foundation; either version 2
'of the License, or (at your option) any later version.
'
'This program is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
'
'See the GNU General Public License for more details.
'
'You should have received a copy of the GNU General Public License
'along with this program; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
'---------------------------------------------------------------------------
'---------
'mWin32API
'---------
'A handy collection of Win32 API functions, as well as wrapper
'functions and type/constant declarations
Option Explicit

'------------
'ShellExecute
'------------
'Execute a program, open a document, print a file...

Public Enum seWindowStyle
    SW_SHOW = 5
    SW_SHOWDEFAULT = 10
    SW_SHOWMAXIMIZED = 3
    SW_SHOWMINIMIZED = 2
    SW_SHOWMINNOACTIVE = 7
    SW_SHOWNA = 8
    SW_SHOWNOACTIVATE = 4
    SW_SHOWNORMAL = 1
End Enum

Public Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" (ByVal hwnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As seWindowStyle) As Long

'--------------------------------------
'--------------------------------------

'----------------
'GetDesktopWindow
'----------------
'Returns a handle to the desktop
Declare Function GetDesktopWindow Lib "user32" () As Long

Declare Function GetWindowDC Lib "user32" (ByVal hwnd As Long) As Long

Declare Function ReleaseDC Lib "user32" (ByVal hwnd As Long, ByVal hdc As Long) As Long

Declare Function SetMapMode Lib "gdi32" (ByVal hdc As Long, ByVal nMapMode As Long) As Long



'-------------
'GetTextMetric
'-------------
'Acquire System Font Information

Type TEXTMETRIC
        tmHeight As Long
        tmAscent As Long
        tmDescent As Long
        tmInternalLeading As Long
        tmExternalLeading As Long
        tmAveCharWidth As Long
        tmMaxCharWidth As Long
        tmWeight As Long
        tmOverhang As Long
        tmDigitizedAspectX As Long
        tmDigitizedAspectY As Long
        tmFirstChar As Byte
        tmLastChar As Byte
        tmDefaultChar As Byte
        tmBreakChar As Byte
        tmItalic As Byte
        tmUnderlined As Byte
        tmStruckOut As Byte
        tmPitchAndFamily As Byte
        tmCharSet As Byte
End Type

Public Const MM_TEXT = 1

Declare Function GetTextMetrics Lib "gdi32" Alias "GetTextMetricsA" (ByVal hdc As Long, lpMetrics As TEXTMETRIC) As Long

'--------------------------------------
'--------------------------------------

'SHFileOperation Constants
Const FO_DELETE = &H3
Const FOF_ALLOWUNDO = &H40
Const FOF_NOCONFIRMATION = &H10

'Type that defines a Win95 file operation
Private Type SHFILEOPSTRUCT
    hwnd As Long
    wFunc As Long
    pFrom As String
    pTo As String
    fFlags As Integer
    fAnyOperationsAborted As Boolean
    hNameMappings As Long
    lpszProgressTitle As String
End Type

'Declaration for the SHFileOperation API
Private Declare Function SHFileOperation Lib "shell32.dll" Alias "SHFileOperationA" (lpFileOp As SHFILEOPSTRUCT) As Long

'Delete a file (or directory?) using the API
'Pass TRUE to the optional arg to just send to recycle bin
Public Sub FileOperation_Delete(path As String, Optional ToRecycleBin As Boolean)

    Dim FileOp As SHFILEOPSTRUCT
    Dim lReturn As Long
    
    With FileOp
        .wFunc = FO_DELETE
        .pFrom = path
        If ToRecycleBin Then
            .fFlags = FOF_NOCONFIRMATION + FOF_ALLOWUNDO
        Else
            .fFlags = FOF_NOCONFIRMATION
        End If
    End With
    
    lReturn = SHFileOperation(FileOp)

End Sub

'----------------
'SystemFontHeight
'----------------
'Returns the height of the current system font
Public Function SystemFontHeight() As Long

    Dim hdc, hwnd, PrevMapMode As Long
    Dim tm As TEXTMETRIC
    
    SystemFontHeight = -1
    
    hwnd = GetDesktopWindow
    hdc = GetWindowDC(hwnd)
    
    If hdc Then
        PrevMapMode = SetMapMode(hdc, MM_TEXT)
        GetTextMetrics hdc, tm
        PrevMapMode = SetMapMode(hdc, PrevMapMode)
        ReleaseDC hwnd, hdc
        SystemFontHeight = tm.tmHeight
    End If

End Function
