VERSION 5.00
Begin VB.Form fSettings 
   BackColor       =   &H80000004&
   BorderStyle     =   4  'Fixed ToolWindow
   Caption         =   "Settings"
   ClientHeight    =   5010
   ClientLeft      =   45
   ClientTop       =   285
   ClientWidth     =   6855
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   334
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   457
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows Default
   Begin VB.ComboBox cboTDC 
      Height          =   315
      Left            =   3720
      Style           =   2  'Dropdown List
      TabIndex        =   14
      Top             =   1440
      Width           =   2895
   End
   Begin VB.CommandButton btnFrameMove 
      Height          =   300
      Index           =   2
      Left            =   2880
      Picture         =   "fSettings.frx":0000
      Style           =   1  'Graphical
      TabIndex        =   9
      Top             =   3060
      Width           =   375
   End
   Begin VB.CommandButton btnFrameMove 
      Height          =   300
      Index           =   0
      Left            =   2520
      Picture         =   "fSettings.frx":005E
      Style           =   1  'Graphical
      TabIndex        =   8
      Top             =   3060
      Width           =   375
   End
   Begin VB.CheckBox chkListDemos 
      Caption         =   "Use ""listdemos"" feature"
      Height          =   255
      Left            =   3480
      TabIndex        =   22
      Top             =   3915
      Width           =   3255
   End
   Begin VB.CheckBox chkListMaps 
      Caption         =   "Use ""listmaps"" feature"
      Height          =   255
      Left            =   3480
      TabIndex        =   21
      Top             =   3630
      Width           =   3255
   End
   Begin VB.TextBox txtNumServers 
      Height          =   285
      Left            =   6240
      TabIndex        =   23
      Text            =   "10"
      Top             =   4185
      Width           =   495
   End
   Begin VB.CheckBox chkValidateMaps 
      Caption         =   "Validate Maps"
      Height          =   255
      Left            =   3480
      TabIndex        =   20
      Top             =   3345
      Width           =   3255
   End
   Begin VB.ListBox lstFrames 
      Height          =   1410
      Left            =   120
      Style           =   1  'Checkbox
      TabIndex        =   7
      Top             =   3000
      Width           =   2295
   End
   Begin VB.CheckBox chkCommandLine 
      Caption         =   "Command Line Length Warning"
      Height          =   255
      Left            =   3480
      TabIndex        =   19
      Top             =   3060
      Width           =   3255
   End
   Begin VB.CommandButton btnEditorBrowse 
      Caption         =   "Browse..."
      Height          =   300
      Left            =   2400
      TabIndex        =   6
      Top             =   2280
      Width           =   855
   End
   Begin VB.CheckBox chkCFGEditor 
      Caption         =   "Use a different editor for config files:"
      Height          =   255
      Left            =   120
      TabIndex        =   4
      Top             =   1920
      Width           =   3015
   End
   Begin VB.TextBox txtCFGEditor 
      Height          =   285
      Left            =   120
      TabIndex        =   5
      Top             =   2295
      Width           =   2175
   End
   Begin VB.ComboBox cboNukeStyle 
      Height          =   315
      Left            =   120
      Style           =   2  'Dropdown List
      TabIndex        =   3
      Top             =   1440
      Width           =   3135
   End
   Begin VB.CheckBox chkConfirmDelete 
      Caption         =   "Ask Before Deleting QuakeSets"
      Height          =   255
      Left            =   3480
      TabIndex        =   18
      Top             =   2775
      Width           =   2655
   End
   Begin VB.ComboBox cboBaseQuakeSet 
      Height          =   315
      Left            =   120
      Style           =   2  'Dropdown List
      TabIndex        =   2
      Top             =   720
      Width           =   3135
   End
   Begin VB.ComboBox cboRunAction 
      Height          =   315
      Left            =   1680
      Style           =   2  'Dropdown List
      TabIndex        =   1
      Top             =   90
      Width           =   1575
   End
   Begin VB.CommandButton btnDefaultTray 
      Caption         =   "Use Default"
      Height          =   300
      Left            =   5520
      TabIndex        =   13
      Top             =   840
      Width           =   1095
   End
   Begin VB.CommandButton btnChangeIcon 
      Caption         =   "Set Icon..."
      Height          =   300
      Left            =   5520
      TabIndex        =   12
      Top             =   480
      Width           =   1095
   End
   Begin VB.TextBox txtTipText 
      Appearance      =   0  'Flat
      BackColor       =   &H80000018&
      Height          =   225
      Left            =   3720
      TabIndex        =   11
      Text            =   "Customize tip text..."
      Top             =   840
      Width           =   1695
   End
   Begin VB.CheckBox chkYourHead 
      Caption         =   "Helping Head"
      Height          =   255
      Left            =   3480
      TabIndex        =   17
      Top             =   2490
      Width           =   1455
   End
   Begin VB.CheckBox chkCLPreview 
      Caption         =   "Show Command Line Preview"
      Height          =   255
      Left            =   3480
      TabIndex        =   16
      Top             =   2205
      Width           =   2535
   End
   Begin VB.CheckBox chkMinStartup 
      Caption         =   "Minimize on Startup"
      Height          =   255
      Left            =   3480
      TabIndex        =   15
      Top             =   1920
      Width           =   1695
   End
   Begin VB.CheckBox chkSysTray 
      Caption         =   "Show Icon in System Tray"
      Height          =   255
      Left            =   3480
      TabIndex        =   10
      Top             =   120
      Width           =   2175
   End
   Begin VB.CommandButton btnCancel 
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   375
      Left            =   5760
      TabIndex        =   25
      Top             =   4560
      Width           =   975
   End
   Begin VB.CommandButton btnOkay 
      Caption         =   "Okay"
      Default         =   -1  'True
      Height          =   375
      Left            =   4680
      TabIndex        =   24
      Top             =   4560
      Width           =   975
   End
   Begin VB.Label Label7 
      Caption         =   "When I Double-Click the Tray Icon..."
      Height          =   255
      Left            =   3720
      TabIndex        =   31
      Top             =   1200
      Width           =   2895
   End
   Begin VB.Label Label6 
      Caption         =   "Number of Servers to Remember:"
      Height          =   255
      Left            =   3480
      TabIndex        =   30
      Top             =   4200
      Width           =   2535
   End
   Begin VB.Label Label5 
      AutoSize        =   -1  'True
      Caption         =   "Customize Option Frames:"
      Height          =   195
      Left            =   120
      TabIndex        =   29
      Top             =   2760
      Width           =   1830
   End
   Begin VB.Label Label4 
      Caption         =   "When I Nuke a Patch:"
      Height          =   255
      Left            =   120
      TabIndex        =   28
      Top             =   1200
      Width           =   3015
   End
   Begin VB.Label Label3 
      Caption         =   "Base my new QuakeSets on this one:"
      Height          =   255
      Left            =   120
      TabIndex        =   27
      Top             =   480
      Width           =   3015
   End
   Begin VB.Label Label2 
      Caption         =   "When I run Quake..."
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   1575
   End
   Begin VB.Image trayPic 
      Height          =   240
      Left            =   5760
      Stretch         =   -1  'True
      Top             =   120
      Width           =   240
   End
   Begin VB.Label Label1 
      Caption         =   "Tool Tip Text:"
      Height          =   255
      Left            =   3720
      TabIndex        =   26
      Top             =   600
      Width           =   1095
   End
End
Attribute VB_Name = "fSettings"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'---------------------------------------------------------------------------
'Copyright 1997-1998 by Brian Kelly
'
'This program is free software; you can redistribute it and/or
'modify it under the terms of the GNU General Public License
'as published by the Free Software Foundation; either version 2
'of the License, or (at your option) any later version.
'
'This program is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
'
'See the GNU General Public License for more details.
'
'You should have received a copy of the GNU General Public License
'along with this program; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
'---------------------------------------------------------------------------
Option Explicit

Dim frameListClicked As Boolean

Dim helpOnTemp As Boolean

Private Sub btnCancel_Click()

    Unload Me

End Sub

Private Sub btnCancel_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay SETTINGS_BUTTON_CANCEL

End Sub

Private Sub btnChangeIcon_Click()
    
    On Error GoTo Hell
    
    fMain.cd.CancelError = True
    fMain.cd.DialogTitle = "Select a New Tray Icon"
    fMain.cd.filter = "Icon Files (*.ico)|*.ico|All Files (*.*)|*.*"
    fMain.cd.FilterIndex = 1
    fMain.cd.InitDir = appPath
    fMain.cd.MaxFileSize = 30000
    fMain.cd.ShowOpen
    
    trayIconPath = fMain.cd.FileName
    
    trayPic.Picture = LoadPicture(trayIconPath)
    
    Exit Sub
    
Hell:
    Select Case Err.Number
        Case 481:  'Invalid Picture File
            MsgBox "Invalid Icon File", vbInformation, AppName
            btnDefaultTray_Click
        Case 32755:
            btnDefaultTray_Click
        Case Else:
            ReportError Err.Number, Err.Description, "<<Settings - Change Icon Button>>"
    End Select

End Sub

Private Sub btnChangeIcon_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay SET_SHOW_ICON

End Sub

Private Sub btnDefaultTray_Click()

    trayIconPath = TRAY_ICON_DEFAULT
    
    Set trayPic.Picture = fMain.defaultTrayIcon.Picture

End Sub

Private Sub btnDefaultTray_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay SET_SHOW_ICON

End Sub

Private Sub btnEditorBrowse_Click()
    
    On Error GoTo Hell
        
    With fMain.cd
        .CancelError = True
        .DialogTitle = "Select Your Config File Editor"
        .filter = "Applications|*.exe;*.bat;*.com;*.pif|All Files (*.*)|*.*"
        .FilterIndex = 1
        .InitDir = qSets(cqs).quakeDir
        .MaxFileSize = 30000
        .ShowOpen
    
        txtCFGEditor.Text = .FileName
    End With
    
    Exit Sub
    
Hell:
    If Err.Number <> 32755 Then
        ReportError Err.Number, Err.Description, "<Fishing for Quake>"
    End If
    
End Sub

Private Sub btnFrameMove_Click(Index As Integer)

    'Another of Brian's creative hacky-sacks.
    'btnFrameMove(0) is up
    'btnFrameMove(2) is down
    
    MoveFrame Index - 1

End Sub

Private Sub btnOkay_Click()

    If Apply Then
        helpOn = helpOnTemp
        Unload Me
    End If

End Sub

Private Sub btnOkay_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay SETTINGS_BUTTON_OKAY

End Sub

Private Sub cboBaseQuakeSet_GotFocus()

    If helpOn Then HeadSay SET_BASE_QSET

End Sub

Private Sub cboNukeStyle_GotFocus()

    If helpOn Then HeadSay SET_NUKE

End Sub

Private Sub cboRunAction_GotFocus()

    If helpOn Then HeadSay SET_WHENQUAKEGO

End Sub

Private Sub cboTDC_GotFocus()

    If helpOn Then HeadSay SET_DBLCLK_TRAY

End Sub

Private Sub chkCFGEditor_Click()

    Dim b As Boolean
    
    If chkCFGEditor.Value = 1 Then
        b = True
    Else
        b = False
    End If
    
    txtCFGEditor.Enabled = b
    btnEditorBrowse.Enabled = b

End Sub

Private Sub chkCFGEditor_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay SET_DIFF_EDIT

End Sub

Private Sub chkCLPreview_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay SET_SHOW_CMDLN

End Sub

Private Sub chkCommandLine_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay SET_CMDLN_WARN

End Sub

Private Sub chkConfirmDelete_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay SET_ASK_DEL_QSET

End Sub

Private Sub chkListDemos_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay SET_LISTDEMO

End Sub

Private Sub chkListMaps_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay SET_LISTMAPS

End Sub

Private Sub chkMinStartup_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay SET_MINATSTART

End Sub

Private Sub chkSysTray_Click()

    If chkSysTray.Value = 1 Then
        TrayEnable True
    Else
        TrayEnable False
    End If

End Sub

Private Sub chkSysTray_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay SET_SHOW_ICON

End Sub

Private Sub chkValidateMaps_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay SET_VAL_MAPS

End Sub

Private Sub chkYourHead_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay SET_HELPHEAD

End Sub

Private Sub Form_Load()

    Dim i As Integer
    
    frameListClicked = False
    
    Me.Caption = AppName & " Settings"
    Me.Icon = fMain.Icon
    
    cboTDC.AddItem "Show QuakeOn"
    cboTDC.AddItem "Run Current QuakeSet"
    
    cboTDC.ListIndex = trayDoubleClick
    
    cboRunAction.AddItem "Do Nothing"
    cboRunAction.AddItem "Minimize"
    cboRunAction.AddItem "Exit"
    cboRunAction.ListIndex = runAction
    
    cboNukeStyle.AddItem "Send to Recycle Bin"
    cboNukeStyle.AddItem "Nuke It!!!"
    cboNukeStyle.ListIndex = nukeStyle
    
    CenterForm Me
    
    trayPic.Picture = fMain.trayIcon.Picture
    trayPic.BorderStyle = 0
    txtTipText.Text = toolTipMessage
    
    chkSysTray.Value = BoolToCheckBox(trayIconPresent)
    TrayEnable trayIconPresent
    
    chkMinStartup.Value = BoolToCheckBox(minimizeOnStartup)
    chkCLPreview = BoolToCheckBox(showCLPreview)
    chkYourHead.Value = BoolToCheckBox(helpOn)
    chkConfirmDelete.Value = BoolToCheckBox(confirmDelete)
    chkCFGEditor.Value = BoolToCheckBox(diffEdit)
    chkCFGEditor_Click
    chkCommandLine.Value = BoolToCheckBox(commandLineCheck)
    chkValidateMaps.Value = BoolToCheckBox(validateMaps)
    chkListMaps.Value = BoolToCheckBox(listMapsOn)
    chkListDemos.Value = BoolToCheckBox(listDemosOn)
    txtNumServers = numServers
    txtCFGEditor.Text = diffEditPath
    cboBaseQuakeSet.Clear
    cboBaseQuakeSet.AddItem "New, Blank QuakeSet"
    For i = 0 To fMain.lstQuakeSets.ListCount - 1
        cboBaseQuakeSet.AddItem qSets(i).setName
    Next i
    cboBaseQuakeSet.ListIndex = FindInList(cboBaseQuakeSet, baseQuakeSet)
    If cboBaseQuakeSet.ListIndex = -1 Then
        cboBaseQuakeSet.ListIndex = 0
    End If

    LoadFrameOrder

End Sub

Public Sub TrayEnable(te As Boolean)

'    btnChangeIcon.Enabled = te
'    btnDefaultTray.Enabled = te
'    txtTipText.Enabled = te

End Sub

Private Sub Form_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay SETTINGS_GENERAL

End Sub


Private Sub Label2_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay SET_WHENQUAKEGO

End Sub

Private Sub Label3_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay SET_BASE_QSET

End Sub

Private Sub Label4_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay SET_NUKE

End Sub

Private Sub Label6_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay SET_NUM_SERV_REM

End Sub

Private Sub Label7_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay SET_DBLCLK_TRAY

End Sub

Private Sub lstFrames_MouseDown(Button As Integer, Shift As Integer, X As Single, Y As Single)

    frameListClicked = True
    
End Sub

Private Sub lstFrames_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay SET_CUST_FRAME

End Sub

Private Sub trayPic_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay SET_ICON
    
End Sub

Private Sub txtCFGEditor_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay SET_DIFF_EDIT

End Sub

Private Sub txtTipText_Change()
    
    trayPic.ToolTipText = txtTipText.Text
    
End Sub

Public Function Apply() As Boolean

    Dim i As Integer
    Dim s As String
    Dim badness As Boolean

    If frameListClicked Then
        For i = 0 To FRAME_UB
            If Not (lstFrames.Selected(i)) Then
                badness = True
                Exit For
            End If
        Next i
        If badness Then
            s = "You have hidden an option frame.  Any options that are "
            s = s & Chr(13) & "selected on hidden option frames are still used by QuakeOn."
            If MsgBox(s, vbInformation + vbOKCancel, AppName) = vbCancel Then
                Apply = False
                Exit Function
            End If
        End If
    End If

    minimizeOnStartup = CheckBoxToBool(chkMinStartup)
    MenuUpdate fMain.muMinOnStartup, minimizeOnStartup
    toolTipMessage = txtTipText.Text
    
    SetTrayIcon
    
    trayIconPresent = CheckBoxToBool(chkSysTray)
    MenuUpdate fMain.muSysTray, trayIconPresent
    showCLPreview = CheckBoxToBool(chkCLPreview)
    helpOnTemp = CheckBoxToBool(chkYourHead)
    confirmDelete = CheckBoxToBool(chkConfirmDelete)
    
    For i = 0 To 2
        If i = cboRunAction.ListIndex Then
            runAction = i
            fMain.muStartupAction(i).Checked = True
        Else
            fMain.muStartupAction(i).Checked = False
        End If
    Next i
    
    nukeStyle = cboNukeStyle.ListIndex
    diffEdit = CheckBoxToBool(chkCFGEditor)
    diffEditPath = txtCFGEditor.Text
    commandLineCheck = CheckBoxToBool(chkCommandLine)
    validateMaps = CheckBoxToBool(chkValidateMaps)
    listMapsOn = CheckBoxToBool(chkListMaps)
    listDemosOn = CheckBoxToBool(chkListDemos)
    
    numServers = Val(txtNumServers.Text)
    If numServers < 5 Then numServers = 5
    If numServers > 30 Then numServers = 30
    
    trayDoubleClick = cboTDC.ListIndex
    
    MenuUpdate fMain.muHelpOn, helpOn
    baseQuakeSet = cboBaseQuakeSet.List(cboBaseQuakeSet.ListIndex)
    
    SaveFrameOrder
    
    Apply = True
    
End Function

'--------------
'LoadFrameOrder
'--------------
'Loads the current order and selection of frames
Private Sub LoadFrameOrder()

    Dim i As Integer

    For i = 0 To FRAME_UB
        lstFrames.AddItem opFramesNames(frameMap(i))
        If Val(Mid(frameOrder, (i * 3) + 1, 1)) = 0 Then
            lstFrames.Selected(i) = False
        Else
            lstFrames.Selected(i) = True
        End If
    Next i
    
    lstFrames.ListIndex = -1

End Sub

'--------------
'SaveFrameOrder
'--------------
'Saves the new order and selection of frames to the frameOrder variable
Private Sub SaveFrameOrder()

    Dim i As Integer
    Dim j As Integer
    Dim temp As String
    Dim checkCount As Integer

    frameOrder = ""
    
    For i = 0 To FRAME_UB
        
        'IS THIS MENU ITEM SELECTED?
        If lstFrames.Selected(i) Then
            temp = "1"
            checkCount = checkCount + 1
        Else
            temp = "0"
        End If
        
        'WHICH MENU ITEM IS IT, DAMMIT?
        For j = 0 To FRAME_UB
            If lstFrames.List(i) = opFramesNames(j) Then
                temp = temp & Format(j, "0#")
                Exit For
            End If
        Next j
        
        frameOrder = frameOrder & temp
        
    Next i
    
    'THEY HAVE TO HAVE AT LEAST ONE ITEM CHECKED!!!
    If checkCount = 0 Then
        frameOrder = "1" & Right(frameOrder, Len(frameOrder) - 1)
    End If

End Sub

'---------
'MoveFrame
'---------
'Moves an item in the list in the direction specified (-1 = UP, 1 = DOWN)
Private Sub MoveFrame(direction As Integer)

    Dim s As String
    Dim b As Boolean
    Dim oldLoc As Integer
    Dim newLoc As Integer
    
    'WHERE ARE WE?
    oldLoc = lstFrames.ListIndex
    
    If oldLoc = -1 Then Exit Sub
    
    newLoc = oldLoc + direction
    
    'BUG OUT IF WE CAN'T MOVE!
    If (newLoc < 0) Or (newLoc > (lstFrames.ListCount - 1)) Then Exit Sub
    
    'REMEMBER WHAT'S SELECTED
    b = lstFrames.Selected(oldLoc)
    s = lstFrames.List(oldLoc)
    
    'REMOVE THE CURRENT ONE...
    lstFrames.RemoveItem oldLoc
    
    'MOVE IT!
    lstFrames.AddItem s, newLoc
    lstFrames.Selected(newLoc) = b
    lstFrames.ListIndex = newLoc

End Sub

Private Sub txtTipText_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)

    If helpOn Then HeadSay SET_ICON_TIP

End Sub
