Attribute VB_Name = "mUtilities"
'---------------------------------------------------------------------------
'Copyright 1997-1998 by Brian Kelly
'
'This program is free software; you can redistribute it and/or
'modify it under the terms of the GNU General Public License
'as published by the Free Software Foundation; either version 2
'of the License, or (at your option) any later version.
'
'This program is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
'
'See the GNU General Public License for more details.
'
'You should have received a copy of the GNU General Public License
'along with this program; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
'---------------------------------------------------------------------------
Option Explicit

'Here's the damn play sound api
Declare Function PlaySound Lib "winmm.dll" Alias "PlaySoundA" (ByVal lpszName As String, ByVal hModule As Long, ByVal dwFlags As Long) As Long

Public Const SND_ASYNC = &H1
Public Const SND_SYNC = &H0
Public Const SND_MEMORY = &H4
Public Const SND_LOOP = &H8

'------------
'GetTickCount
'------------
'Supposedly, the number of milliseconds that have elapsed
'since Windows started...
Declare Function GetTickCount Lib "kernel32" () As Long

'This holds the logical cursor information
Type POINTAPI
    X As Long
    Y As Long
End Type

'Get the cursor position
Declare Function GetCursorPos Lib "user32" (lpPoint As POINTAPI) As Long

'Special type for use with the MultiDir function
Public Type dirList
    files() As String
    numFiles As Integer
End Type

'----------
'CenterForm
'----------
'Centers a passed form
Public Sub CenterForm(f As Form)
    
    f.Left = (Screen.Width - f.Width) / 2
    f.Top = (Screen.Height - f.Height) / 2

End Sub

'Finds the specified thingie in the specified list.
'Returns the index, don'tcha know?
'CASE INSENSITIVE AS OF 05/20/97, DUDE
Public Function FindInList(o As Object, s As String) As Integer

    Dim i As Integer
    Dim done As Boolean
    
    i = 0
    done = False
    
    'MsgBox "FindInList Called for object:  " & o.name & ", searching for:  " & s
    
    Do Until ((done = True) Or (i = o.ListCount))
        If LCase(o.List(i)) = LCase(s) Then 'we found it!
            done = True
        Else
            i = i + 1
        End If
    Loop
    
    If done = True Then
        FindInList = i
    Else
        FindInList = -1
    End If

End Function

'This function takes a delimited list and adds the items
'to something that can use the AddItem method
'Only works if the delimiter is one character, of course
Public Sub ParseVals(s As String, Delimeter As String, obj As Object)

    Dim i As Integer
    Dim l As Integer
    Dim temp As String
    
    temp = ""
    
    For i = 1 To Len(s)
        If Mid(s, i, 1) = Delimeter Then
            obj.AddItem Trim(temp)
            temp = ""
        Else
            temp = temp & Mid(s, i, 1)
        End If
    Next i
    
    If temp <> "" Then obj.AddItem temp

End Sub

'Converts a list to a delimited string
Public Function ListToDelString(o As Object, Delimeter As String) As String

    Dim i As Integer
    Dim temp As String
    
    For i = 0 To (o.ListCount - 1)
        temp = temp & o.List(i) & Delimeter
    Next i
    
    If temp <> "" Then
        temp = Mid(temp, 1, Len(temp) - Len(Delimeter)) 'remove last delimeter
    End If
    
    ListToDelString = temp
    
End Function

Public Function MultiDir(directory As String, Pattern As String) As dirList

    Dim tempDir As dirList
    Dim currentFile As String
    Dim i As Integer
    Dim cat As String
    Dim cdr As String
    Dim done As Boolean
    
    'INITIALIZE STUFF
    tempDir.numFiles = -1
    done = False
    cdr = Pattern
    
    Do
        i = InStr(1, cdr, ";")
        If i = 0 Then
            cat = cdr
            done = True
        Else
            cat = Left(cdr, i - 1)
            cdr = Right(cdr, Len(cdr) - i)
        End If
        currentFile = Dir(directory & "\" & cat)
        Do Until currentFile = ""
            With tempDir
                .numFiles = .numFiles + 1
                ReDim Preserve .files(.numFiles) As String
                .files(.numFiles) = currentFile
            End With
            currentFile = Dir
        Loop
    Loop Until done
    
    MultiDir = tempDir

End Function

'------------
'BoolToString
'------------
'Converts a boolean value into a string ("true" or "false")
'You may specify the specific strings you want to signify true
'and false, otherwise it will return "true" and "false" (no caps)
Public Function BoolToString(BooleanValue As Boolean, Optional TrueString As String, Optional FalseString As String) As String

    Dim fComp As String
    Dim tComp As String
    
    If BooleanValue Then
        If TrueString = "" Then
            BoolToString = "true"
        Else
            BoolToString = TrueString
        End If
    Else
        If FalseString = "" Then
            BoolToString = "false"
        Else
            BoolToString = FalseString
        End If
    End If

End Function

'------------
'StringToBool
'------------
'Converts a string value to a boolean value
'If the string is "true" then it returns true, otherwise it returns false
'You may specify a "true" string
Public Function StringToBool(BoolString As String, Optional TrueString As String) As Boolean

    If TrueString = "" Then
        If BoolString = "true" Then
            StringToBool = True
        Else
            StringToBool = False
        End If
    Else
        If BoolString = TrueString Then
            StringToBool = True
        Else
            StringToBool = False
        End If
    End If

End Function

'--------------
'BoolToCheckBox
'--------------
'Returns a .Value property for a CheckBox when passed a Boolean value
Public Function BoolToCheckBox(BooleanValue As Boolean) As Integer

    If BooleanValue Then
        BoolToCheckBox = 1
    Else
        BoolToCheckBox = 0
    End If

End Function

'--------------
'CheckBoxToBool
'--------------
'Interprets the .Value property of a CheckBox as a Boolean value
Public Function CheckBoxToBool(CBox As CheckBox) As Boolean

    If CBox.Value = 0 Then
        CheckBoxToBool = False
    Else
        CheckBoxToBool = True
    End If

End Function

'----------
'MenuUpdate
'----------
'This is an older function
'I'm not sure why I wrote it...
Public Sub MenuUpdate(MenuObject As Object, boolVal As Boolean)

    MenuObject.Checked = boolVal

End Sub

'------
'LPrint
'------
'This function opens a passed filename and tags the passed line to the end of it.
'It's nice to have as a completely self-contained function for remote debug traces
Public Sub LPrint(path As String, newLine As String)

    Dim fn As Integer
    
    fn = FreeFile
    Open path For Append As fn
    Print #fn, newLine
    Close fn

End Sub

'-----------
'IsDirectory
'-----------
Public Function IsDirectory(sPath As String) As Boolean

    Dim s As String
    
    If (GetAttr(sPath) And vbDirectory) = vbDirectory Then
        s = TokStrip(sPath, "\", tsLastTok, tsAfterTok)
        If ((s = ".") Or (s = "..")) Then
        Else
            IsDirectory = True
        End If
    Else
        IsDirectory = False
    End If

End Function

'--------
'ListDirs
'--------
Public Function ListDirs(sPath As String, Optional Delimeter As String = ";", Optional ExcludeDir As String = "") As String

    Dim r As String
    Dim t As String
    
    r = ""
    t = Dir(sPath & "\*.*", vbDirectory)
    Do Until t = ""
        If t <> "." Then
            If t <> ".." Then
                If ((GetAttr(sPath & "\" & t) And vbDirectory) = vbDirectory) Then
                    If LCase(t) <> LCase(ExcludeDir) Then
                        r = r & t & Delimeter
                    End If
                End If
            End If
        End If
        t = Dir
    Loop

    If Right(r, 1) = ";" Then r = Left(r, Len(r) - 1)
    
    ListDirs = r

End Function

