Attribute VB_Name = "mPopupWindow"
'---------------------------------------------------------------------------
'Copyright 1997-1998 by Brian Kelly
'
'This program is free software; you can redistribute it and/or
'modify it under the terms of the GNU General Public License
'as published by the Free Software Foundation; either version 2
'of the License, or (at your option) any later version.
'
'This program is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
'
'See the GNU General Public License for more details.
'
'You should have received a copy of the GNU General Public License
'along with this program; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
'---------------------------------------------------------------------------
Option Explicit

Public Const PL_NO_DUPLICATES = 8

Global Const PW_NO_RETURN_VAL = "~~PW_NO_RETURN_VAL~~"

Public Type PopupList
    pName As String     'Identifier for the list
    pList() As String   'The list
End Type

Dim PrivatePopupWindowReturnValue As String

'This function will supposedly launch one of my way cool popup
'windows with items such as you send it.
'I'm gonna need the list.  I also need the left coordinate and
'a vertical coordinate to center the thing on.
Public Function ShowPopupWindow(popList As PopupList, Optional Caption As String = "", Optional DelimitedList As String = "", Optional Delimiter As String = ",") As String

    Dim i As Integer
    Dim cursorLoc As POINTAPI

    'Check cursor location
    Call GetCursorPos(cursorLoc)
    
    'The caption of the form is the name of the popup list.
    'so make sure to give the popup list a name, dammit
    If Caption = "" Then
        fMenu.Caption = popList.pName
    Else
        fMenu.Caption = Caption
    End If
    
    'Gotta clear whatevuh crap is in the list from last time
    fMenu.lstMaps.Clear
    
    'Now is da time on schprockets when we load da list
    If DelimitedList = "" Then
        For i = 0 To UBound(popList.pList)
            fMenu.lstMaps.AddItem popList.pList(i)
        Next i
    Else
        ParseVals DelimitedList, Delimiter, fMenu.lstMaps
    End If
            
    'And this is where we have to size the stoopid window.
    'WHAT A PAIN!!!
    fMenu.Width = 3000
    i = fMenu.lstMaps.ListCount
    If i > ((Screen.Height / 195) - 7) Then i = (Screen.Height / 195) - 12
    fMenu.Height = 800 + (i * 195)
    fMenu.Left = (cursorLoc.X * Screen.TwipsPerPixelX) - 300
    If Screen.Width < (fMenu.Left + fMenu.Width) Then
        fMenu.Left = Screen.Width - fMenu.Width - 50
    End If
    'If fMenu.Height > fMain.Height Then
        fMenu.Top = (cursorLoc.Y * Screen.TwipsPerPixelY) - (fMenu.Height / 2)
        If fMenu.Top < 0 Then fMenu.Top = 20
    'Else
    '    fMenu.Top = fMain.Top + ((fMain.Height - fMenu.Height) / 2)
    'End If
    
    'Okay... you may now show the damn window
    fMenu.Show 1
    
    'And return the answer, oh great wizard!
    ShowPopupWindow = PrivatePopupWindowReturnValue
    
End Function

Public Sub ReturnPopupWindowValue(newValue As String)

    PrivatePopupWindowReturnValue = newValue

End Sub

'NOTE:
'This function does NOT handle empty popup lists.
'It will CRASH if you pass an empty popup list.
Public Function ConcatPopupList(mainML As PopupList, addML As PopupList, Optional allowDuplicates As Integer) As PopupList

    Dim i As Integer
    Dim j As Integer
    Dim okay As Boolean
    Dim offSet As Integer
    Dim tempML As PopupList
    Dim fileCount As Integer
    
    On Error GoTo Hell
    
    ReDim tempML.pList(UBound(mainML.pList) + UBound(addML.pList) + 1) As String
    
    For i = 0 To UBound(mainML.pList)
        tempML.pList(i) = mainML.pList(i)
    Next i
    
    offSet = UBound(mainML.pList) + 1
    
    If allowDuplicates = PL_NO_DUPLICATES Then
        fileCount = offSet
        For i = 0 To UBound(addML.pList)
            okay = True
            For j = 0 To UBound(mainML.pList)
                If LCase(mainML.pList(j)) = LCase(addML.pList(i)) Then okay = False
            Next j
            If okay Then
                tempML.pList(fileCount) = addML.pList(i)
                fileCount = fileCount + 1
            End If
        Next i
        ReDim Preserve tempML.pList(fileCount - 1) As String
    Else
        For i = 0 To UBound(addML.pList)
            tempML.pList(i + offSet) = addML.pList(i)
        Next i
    End If
    
    ConcatPopupList = tempML

    Exit Function
    
Hell:
    Select Case Err.Number
        Case Else:
            ReportError Err.Number, Err.Description, "<Concatenating Popup Lists>"
    End Select

End Function



