Attribute VB_Name = "mIniMaster"
'---------------------------------------------------------------------------
'Copyright 1997-1998 by Brian Kelly
'
'This program is free software; you can redistribute it and/or
'modify it under the terms of the GNU General Public License
'as published by the Free Software Foundation; either version 2
'of the License, or (at your option) any later version.
'
'This program is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
'
'See the GNU General Public License for more details.
'
'You should have received a copy of the GNU General Public License
'along with this program; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
'---------------------------------------------------------------------------
Option Explicit

Private Declare Function GetPrivateProfileSection Lib "kernel32" Alias "GetPrivateProfileSectionA" (ByVal lpAppName As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long

Private Declare Function apiGetPrivateProfileString Lib "kernel32" Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long

Public Function GetKeyFromIniFile(iniFilePath As String, headerVal As String, keyVal As String, Optional defaultValue As String) As String

    Dim l As Long
    Dim tempVal As String
    
    tempVal = String(145, Asc(" "))
    
    l = apiGetPrivateProfileString(headerVal, keyVal, defaultValue, tempVal, Len(tempVal) - 1, iniFilePath)
    
    GetKeyFromIniFile = Left(tempVal, InStr(1, tempVal, Chr(0)) - 1)
    
End Function

Public Function GetSection(iniFilePath As String, sectionName As String)

    Dim l As Long
    Dim i As Integer
    Dim tempVal As String
    
    tempVal = String(32767, Asc(" "))
    
    l = GetPrivateProfileSection(sectionName, tempVal, Len(tempVal) - 1, iniFilePath)
    
    GetSection = Left(tempVal, l)

End Function

Public Function GetKey(iniSection As String, keyVal As String, Optional defaultValue As String = "") As String

    Dim nSection As String
    Dim nKey As String
    Dim i As Integer
    Dim finalValue As String
    
    nSection = Chr(0) & iniSection
    nKey = Chr(0) & keyVal & "="
    
    i = InStr(1, nSection, nKey)
    
    If i = 0 Then
        finalValue = defaultValue
    Else
        nSection = Right(nSection, Len(nSection) - i)
        finalValue = TokStrip(nSection, Chr(0), tsFirstTok, tsBeforeTok)
        finalValue = TokStrip(finalValue, "=", tsFirstTok, tsAfterTok)
    End If
    
    GetKey = finalValue

End Function

Public Function GetIniHeaders(FilePath As String, Delimiter As String, Optional filter As String) As String

    Dim fn As Integer
    Dim temp As String
    Dim headerList As String

    fn = FreeFile
    Open FilePath For Input As fn
    
    Do Until EOF(fn)
        Line Input #fn, temp
        If InStr(1, temp, "[" & filter) = 1 Then
            temp = Mid(temp, 2, Len(temp) - 2)
            'Check for special bracket characters - Gregorious3
            If InStr(temp, "~(") Then temp = ReplaceInstr(temp, "~(", "[")
            If InStr(temp, "~)") Then temp = ReplaceInstr(temp, "~)", "]")
            
            If headerList = "" Then
                headerList = temp
            Else
                headerList = headerList & Delimiter & temp
            End If
        End If
    Loop
    
    Close fn
    
    'Remove filter text if any
    If filter <> "" Then headerList = ReplaceInstr(headerList, filter & " ", "")
    GetIniHeaders = headerList

End Function

Public Function OldGetKey(iniSection As String, keyVal As String, Optional defaultValue As String) As String

    Dim temp As String
    Dim i As Integer
    
    i = InStr(1, iniSection, keyVal)
    
    If i = 0 Then 'we didn't find it, return the default value
        OldGetKey = defaultValue
        Exit Function
    End If
    
    temp = Right(iniSection, Len(iniSection) - i + 1)
    
    i = InStr(1, temp, Chr(0))
    
    If i > 0 Then
        temp = Left(temp, i - 1)
    End If
    
    i = InStr(1, temp, "=")
    If i = 0 Then
        OldGetKey = defaultValue
    Else
        OldGetKey = Right(temp, Len(temp) - i)
    End If

End Function
