VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsSysTray"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Ext_KEY = "SavedWithClassBuilder" ,"Yes"
Attribute VB_Ext_KEY = "Top_Level" ,"Yes"
'---------------------------------------------------------------------------
'Copyright 1997-1998 by Brian Kelly
'
'This program is free software; you can redistribute it and/or
'modify it under the terms of the GNU General Public License
'as published by the Free Software Foundation; either version 2
'of the License, or (at your option) any later version.
'
'This program is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
'
'See the GNU General Public License for more details.
'
'You should have received a copy of the GNU General Public License
'along with this program; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
'---------------------------------------------------------------------------
'--------------
'clsSysTray.bas
'--------------
'This is system tray code I ripped off
'from someone on the 'net (hey, if he didn't want it
'stolen he shouldn't have left it there :)
'---------------------------------------
'Here are Erwin's feelings on the issue:
'---------------------------------------
'WHO, WHAT, WHERE:
'   2 June 1997
'   Erwin Berkouwer
'   erwin@null.net
'   provided 'as is', no warranty, no guarantees
'---
'TACTICS:
'   create object               Dim systray As Object
'                               Set systray = New clsSysTray
'   set icon                    systray.Icon = frmMAIN.Icon
'   set tooltip text            systray.ToolTip = "My System Tray Icon!"
'   set owner control           systray.OwnerControl = frmMAIN.picAnimate
'   activate it                 systray.Add
'---
'   now, when the user clicks on the the created icon, the corresponding MOUSEMOVE event
'   of the owning control is activated. Here a sample of such code: '
'Private Sub picAnimate_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
'    Select Case Hex(X)
'        Case "1E3C"
'            MsgBox "Right-Button-Down"
'        Case "1830"
'            MsgBox "Right-Button-Down LARGE FONTS"
'        Case "1E0F"
'            MsgBox "Left-Button-Down"
'        Case "1E2D"
'            MsgBox "Left-Button-Double-Click"
'        Case "1824"
'            MsgBox "Left-Button-Double-Click LARGE FONTS"
'        Case "1E5A"
'            MsgBox "Right-Button-Double-Click"
'    End Select
'End Sub
'---
'when active, you can do the following:
'--
'modify the icon shown
'SysTray.Icon = frmSetup.Icon
'--
'modify the tooltip text
'sysTray.ToolTip = "Modified Text !"
'---
'remove the icon  (this is not done automatic when your program ends!)
'systray.Remove
'--
Option Explicit

Private Type NOTIFYICONDATA_TYPE
    cbSize As Long
    hwnd As Long
    uID As Long
    uFlags As Long
    uCallbackMessage As Long
    hIcon As Long
    szTip As String * 64
End Type

Private Declare Function Shell_NotifyIcon Lib "shell32.dll" Alias "Shell_NotifyIconA" _
    (ByVal dwMessage As Long, lpData As NOTIFYICONDATA_TYPE) As Long

Private mvarSysTray As NOTIFYICONDATA_TYPE
Private Const NIM_ADD = &H0
Private Const NIM_MODIFY = &H1
Private Const NIM_DELETE = &H2
Private Const NIF_MESSAGE = &H1
Private Const NIF_ICON = &H2
Private Const NIF_TIP = &H4
Private Const WM_MOUSEMOVE = &H200
Private mvarIcon As Object
Private blnIsActive As Boolean 'status flag
Private blnOwnerControlIsSet As Boolean 'status flag
Private blnIconIsSet As Boolean 'status flag
Private mvarOwnerControl As Object 'local copy

Public Property Let OwnerControl(ByVal vData As Object)
    'calling program should set owning control
    If blnIsActive Then
        MsgBox "WARNING: clsSysTray cannot change owner control for an icon when active", vbExclamation
    Else
        Set mvarOwnerControl = vData
        blnOwnerControlIsSet = True
    End If
End Property

Public Property Get OwnerControl() As Object
    'if calling program wants to know it
    Set OwnerControl = mvarOwnerControl
End Property

Public Property Let ToolTip(ByVal vData As String)
    'calling program can set ToolTip (optional)
    If vData = "" Then
        mvarSysTray.szTip = vbNullChar
    Else
        mvarSysTray.szTip = " " & vData & " " & vbNullChar
    End If
    'modify shown text if active
    If blnIsActive Then Shell_NotifyIcon NIM_MODIFY, mvarSysTray
End Property

Public Property Get ToolTip() As String
Attribute ToolTip.VB_UserMemId = 0
    'if calling program wants to know it
    ToolTip = mvarSysTray.szTip
End Property

Public Property Let Icon(ByVal vData As Object)
'calling program should set icon
    mvarSysTray.hIcon = vData
    'set status
    blnIconIsSet = True
    'modify shown icon if active
    If blnIsActive Then Shell_NotifyIcon NIM_MODIFY, mvarSysTray
End Property

Public Property Get Icon() As Object
    'if calling program wants to know it
    Set Icon = mvarIcon
End Property

Public Function Remove() As Boolean
    
    'to remove the icon from the system tray
    'NOT done automaticly if your program ends !
    If blnIsActive = True Then
        Shell_NotifyIcon NIM_DELETE, mvarSysTray
        'set status
        blnIsActive = False
    End If
    
    Remove = True
    
End Function

Public Function Add() As Boolean
    
    'verify environment
    If blnIsActive Then MsgBox "ERROR: clsSysTray is already active", vbExclamation
    If Not blnIconIsSet Then MsgBox "ERROR: clsSysTray cannot activate when the icon has not been set", vbExclamation
    If Not blnOwnerControlIsSet Then MsgBox "ERROR: clsSysTray cannot activate when the owner control has not been set", vbExclamation
    
    'set other variables
    mvarSysTray.cbSize = Len(mvarSysTray)
    mvarSysTray.hwnd = mvarOwnerControl.hwnd
    mvarSysTray.uID = 1&
    mvarSysTray.uFlags = NIF_MESSAGE Or NIF_ICON Or NIF_TIP
    mvarSysTray.uCallbackMessage = WM_MOUSEMOVE
    Shell_NotifyIcon NIM_ADD, mvarSysTray  'set status
    blnIsActive = True
    Add = True
    
End Function

