Attribute VB_Name = "mStrings"
'---------------------------------------------------------------------------
'Copyright 1997-1998 by Brian Kelly
'
'This program is free software; you can redistribute it and/or
'modify it under the terms of the GNU General Public License
'as published by the Free Software Foundation; either version 2
'of the License, or (at your option) any later version.
'
'This program is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
'
'See the GNU General Public License for more details.
'
'You should have received a copy of the GNU General Public License
'along with this program; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
'---------------------------------------------------------------------------
'------------
'mStrings.bas
'------------
'String handling functions
Option Explicit

'-------------------------
'Declarations for TokStrip
'-------------------------
'Enumerated Constants
Public Enum tsStringRef
    tsBeforeTok = 0
    tsAfterTok = 1
End Enum

Public Enum tsTokPosition
    tsFirstTok = 0
    tsLastTok = 1
End Enum

'--------
'TokStrip
'--------
'This function is hard to describe, but I'll try :)
'Given a token string, TokStrip will return:
'The entire string before (or after) the first (or last)
'occurence of the token.  The before/after, first/last can
'be passed through TokStrip constants, defined im the
'general declarations section
Public Function TokStrip(s As String, Token As String, FirstOrLast As tsTokPosition, BeforeOrAfter As tsStringRef) As String

    Dim tokLoc As Integer
    Dim i As Integer

    'First we find the position of the token they want to use...
    If FirstOrLast = tsFirstTok Then
        tokLoc = InStr(1, s, Token)
    Else
        For i = Len(s) To 1 Step -1
            If Mid(s, i, 1) = Token Then
                tokLoc = i
                Exit For
            End If
        Next i
    End If

    'Did we find the token?
    If tokLoc = 0 Then 'we didn't find the token, so we'll just return the string
        TokStrip = s
        Exit Function
    End If

    'Okay... snag the string...
    If BeforeOrAfter = tsBeforeTok Then
        If tokLoc = 1 Then  'There's NOTHING before the token!
            TokStrip = ""
        Else
            TokStrip = Mid(s, 1, tokLoc - 1)
        End If
    Else
        If tokLoc = Len(s) Then  'There's NOTHING after the token!
            TokStrip = ""
        Else
            TokStrip = Mid(s, tokLoc + 1, Len(s) - tokLoc)
        End If
    End If

End Function

'------------
'ReplaceInstr
'------------
'Replaces all occurences of oldStr with newStr in source!
Public Function ReplaceInstr(source As String, oldStr As String, newStr As String) As String

    Dim i As Integer
    Dim done As Boolean
    Dim temp As String
    Dim tempSource As String

    done = False
    temp = ""
    tempSource = source

    Do Until done
        i = InStr(1, tempSource, oldStr)
        If i = 0 Then
            ReplaceInstr = temp & tempSource
            Exit Function
        End If
        temp = temp & Left(tempSource, i - 1) & newStr
        tempSource = Right(tempSource, Len(tempSource) - (i + Len(oldStr) - 1))
    Loop

End Function
