Attribute VB_Name = "mPopupWindow"
'---------------------------------------------------------------------------
'Copyright 1997-1998 by Brian Kelly
'
'This program is free software; you can redistribute it and/or
'modify it under the terms of the GNU General Public License
'as published by the Free Software Foundation; either version 2
'of the License, or (at your option) any later version.
'
'This program is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
'
'See the GNU General Public License for more details.
'
'You should have received a copy of the GNU General Public License
'along with this program; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
'---------------------------------------------------------------------------
Option Explicit

Public Const PL_NO_DUPLICATES = 8

Global Const PW_NO_RETURN_VAL = "~~PW_NO_RETURN_VAL~~"

Public Type PopupList
    pName As String     'Identifier for the list
    pList() As String   'The list
End Type

'NOTE:
'This function does NOT handle empty popup lists.
'It will CRASH if you pass an empty popup list.
Public Function ConcatPopupList(mainML As PopupList, addML As PopupList, Optional allowDuplicates As Integer) As PopupList

    Dim i As Integer
    Dim j As Integer
    Dim okay As Boolean
    Dim offSet As Integer
    Dim tempML As PopupList
    Dim fileCount As Integer
    
    On Error GoTo Hell
    
    ReDim tempML.pList(UBound(mainML.pList) + UBound(addML.pList) + 1) As String
    
    For i = 0 To UBound(mainML.pList)
        tempML.pList(i) = mainML.pList(i)
    Next i
    
    offSet = UBound(mainML.pList) + 1
    
    If allowDuplicates = PL_NO_DUPLICATES Then
        fileCount = offSet
        For i = 0 To UBound(addML.pList)
            okay = True
            For j = 0 To UBound(mainML.pList)
                If LCase(mainML.pList(j)) = LCase(addML.pList(i)) Then okay = False
            Next j
            If okay Then
                tempML.pList(fileCount) = addML.pList(i)
                fileCount = fileCount + 1
            End If
        Next i
        ReDim Preserve tempML.pList(fileCount - 1) As String
    Else
        For i = 0 To UBound(addML.pList)
            tempML.pList(i + offSet) = addML.pList(i)
        Next i
    End If
    
    ConcatPopupList = tempML

    Exit Function
    
Hell:
    Select Case Err.Number
        Case Else:
            ReportError Err.Number, Err.Description, "<Concatenating Popup Lists>"
    End Select

End Function



