Attribute VB_Name = "mApplicationLayer"
'---------------------------------------------------------------------------
'Copyright 1997-1998 by Brian Kelly
'
'This program is free software; you can redistribute it and/or
'modify it under the terms of the GNU General Public License
'as published by the Free Software Foundation; either version 2
'of the License, or (at your option) any later version.
'
'This program is distributed in the hope that it will be useful,
'but WITHOUT ANY WARRANTY; without even the implied warranty of
'MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
'
'See the GNU General Public License for more details.
'
'You should have received a copy of the GNU General Public License
'along with this program; if not, write to the Free Software
'Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
'---------------------------------------------------------------------------
'Here's the QuakeOn application layer
'This is where all the information that needs to be globally
'accessed by everyone resides.
Option Explicit

'**********************************
'** GLOBAL APPLICATION CONSTANTS **
'**********************************

Public Const AppName = "QTray"         'NAME OF THE APPLICATION (MAKES GLOBAL CHANGES)
Public Const VERSION_TYPE = ""  'TYPE OF RELEASE
Public VERSION_INFO As String            'VERSION INFORMATION
Public CRLF As String                    'CARRIAGE-RETURN/LINE FEED

'PopupList Return Error Strings
Public Const MAP_NOT_FOUND = "~~MAP~NOT~FOUND~~"
Public Const DEMOS_NOT_FOUND = "~~DEMOS~NOT~FOUND~~"

Public Const INI_PATH_NOT_SET = "/\INI_PATH_NOT_SET"

'NAME OF TEMPORARY CFG FILES
Public Const TEMP_CFG_NAME = "~quakeon.tmp"
Public Const TEMP_MAP_NAME = "~qo_maps.tmp"
Public Const TEMP_DEM_NAME = "~qo_demo.tmp"
Public Const TEMP_BAT_NAME = "~quakeon.bat"

'Custom Option Types
Public Const OP_CFGFILE = 0
Public Const OP_CMDLINE = 1
Public Const OP_BATCHFILE = 2

'TRAY ICON DEFAULT
Public Const TRAY_ICON_DEFAULT = "**DEFAULT**"

Public Declare Function SetForegroundWindow Lib "user32" (ByVal hwnd As Long) As Long

'****************
'** DATA TYPES **
'****************

Public Type stringList
    topRec As Integer
    l() As String
End Type

'**********************
'** GLOBAL VARIABLES **
'**********************

'Now, let's have a funky-ass array of these QuakeSets
Public qs As QuakeSet

Public cqs As Integer

'The system tray
Public sysTray As Object

'Structure for keeping track of temporary files
Public junkList As stringList

'Useful paths
Public appPath As String
Public iniPath As String
Public myIniPath As String

'User Options
Public setsArrayCount As Integer    'Counter we need for the Popup Menu
Public fileArrayCount As Integer
Public trayIconPath As String       'Filename where the custom icon is
Public toolTipMessage As String     'The text that appears when you move over the tray icon
Public defaultQuakeSet As String    'QuakeSet last used
Public commandLineCheck As Boolean  'Command Line Length Check?
Public listMapsOn As Integer            'Use "listmaps" feature?
Public listDemosOn As Integer       'Use "listdemos" feature?
Public trayDoubleClick As Integer   'what happens in double-click stylie
Public userOps() As customOption    'Users custom option array
Public userOps_UB As Integer        '# items is custom ops array
Public lastIniFile As String        'Use the last ini file!

'The command line that finally gets run when the
'"RUN QUAKE!" Button is pressed!
Public commandLine As String
Public cfgFile As String
Public batFile As String

Public Sub Main()

    'CAN'T RUN IT TWICE!
    If App.PrevInstance Then
        MsgBox "I know you love " & AppName & ", but you may only run one copy at a time.", vbInformation, AppName
        Exit Sub
    End If
    
    'INITIALIZE STUFF
    VERSION_INFO = "Version " & App.Major & "." & Format(App.Minor, "00") & "." & App.Revision & " " & VERSION_TYPE
    CRLF = Chr(13) & Chr(10)
    setsArrayCount = 1             'This is a counter for the PopupMenu
    fileArrayCount = 1
    junkList.topRec = -1
    InitializeOpDefs
    appPath = App.Path
    SetIniPath
    myIniPath = appPath & "\QTray.ini"
    Set sysTray = New clsSysTray
    sysTray.OwnerControl = fMain.trayIcon
    
    'LET THE GAMES BEGIN!
    Load fMain

End Sub

'-----------
'ReportError
'-----------
'A more detailed error message box!
Public Sub ReportError(errorNumber As Long, errorDescription As String, Optional additionalText As String)

    Dim s As String
    Dim extra As String
    
    s = AppName & " Error:"
    s = s & Chr(13) & VERSION_INFO
    s = s & Chr(13) & "Number " & errorNumber
    s = s & Chr(13) & errorDescription
    If additionalText <> "" Then
        s = s & Chr(13) & additionalText
    End If
    
    extra = Chr(13) & "Report to <fragbert@planetquake.com>"
    extra = extra & Chr(13) & "Do you want to copy this message to the clipboard?"
    extra = extra & Chr(13) & "(So you can paste it in your e-mail to me)"
    
    If MsgBox(s & extra, vbExclamation + vbYesNo + vbDefaultButton2, AppName) = vbYes Then
        Clipboard.SetText ReplaceInstr(s, Chr(13), CRLF)
    End If

End Sub

Public Sub SetTrayIcon()

    On Error GoTo Hell

Try_This_Again:
    If trayIconPath = TRAY_ICON_DEFAULT Then
        Set fMain.trayIcon.Picture = fMain.defaultTrayIcon.Picture
    Else
        fMain.trayIcon.Picture = LoadPicture(trayIconPath)
    End If
    
    Exit Sub
    
Hell:
    Select Case Err.Number
        Case 53:  'File not found
            trayIconPath = TRAY_ICON_DEFAULT
            GoTo Try_This_Again
        Case 481:  'Invalid picture file
            trayIconPath = TRAY_ICON_DEFAULT
            GoTo Try_This_Again
        Case Else:
            ReportError Err.Number, Err.Description, "<Setting the Tray Icon>"
    End Select
    
End Sub

'One of the important higher level map reading functions.
'This function takes the path/filename of a PAK file and
'returns a popup list containing the names of the maps within
'that pakfile.  If there are no maps in that PAK file, this
'function returns an empty popup list with MAPS_NOT_FOUND
'as the name.
Public Function PakBSPsToPopupList(fName As String) As PopupList

    Dim i As Integer
    Dim j As Integer
    Dim fPak As Integer
    Dim temp As String
    Dim p As pakDir
    Dim ml As PopupList
    Dim errmsg As String

    On Error GoTo Trap
    
    'Let's open the PAK file
    fPak = FreeFile
    Open fName For Binary As fPak
    
        p = ListPak(fPak, ".bsp")
        
        j = -1
    
        If p.numFiles = 0 Then 'we have no maps in this pak file
            Close fPak
            ml.pName = MAP_NOT_FOUND
            PakBSPsToPopupList = ml
            Exit Function
        Else
            ReDim ml.pList(p.numFiles - 1) As String
        End If
    
        For i = 0 To (p.numFiles - 1)
            temp = BSPInfo(fPak, p.directory(i).Name, p.directory(i).pos)
            If temp <> BSP_ERROR Then
                j = j + 1
                ml.pList(j) = temp
            End If
        Next i
    
    Close fPak
    
    If j < 0 Then
        ml.pName = MAP_NOT_FOUND
        PakBSPsToPopupList = ml
        Exit Function
    Else
        ReDim Preserve ml.pList(j) As String
    End If
    
    PakBSPsToPopupList = ml
    
    Exit Function

Trap:
    Select Case Err.Number
        Case 70:
            errmsg = "The Pak File " & fName
            errmsg = errmsg & " is in use by another program right now."
            errmsg = errmsg & Chr(13) & "Maps and other info in this file will"
            errmsg = errmsg & " not be available to QuakeOn."
            MsgBox errmsg, vbExclamation, AppName
        Case 71, 76:  'Drive not ready or couldn't find PAK file
            'Do nothing
        Case Else:
            ReportError Err.Number, Err.Description, "<Getting Map Names from a Pak File>"
    End Select

    ml.pName = MAP_NOT_FOUND
    PakBSPsToPopupList = ml

End Function

'Another great higher-level map reading function
'This function returns the names of all playable Quake
'maps in a directory in a popup list
'Returns MAP_NOT_FOUND if no maps are there...
Public Function DirBSPsToPopupList(dirName As String) As PopupList
    
    Dim bspFile As Integer
    Dim j As Integer
    Dim temp As String
    Dim ml As PopupList
    Dim currentFile As String
    
    On Error GoTo Trap
    
    j = -1
    
    currentFile = Dir(dirName & "\*.bsp")
    
    Do Until currentFile = ""
        bspFile = FreeFile
        Open dirName & "\" & currentFile For Binary As bspFile
        temp = BSPInfo(bspFile, currentFile)
        If temp <> BSP_ERROR Then
            j = j + 1
            ReDim Preserve ml.pList(j) As String
            ml.pList(j) = temp
        End If
        Close bspFile
        currentFile = Dir
    Loop
    
    If j < 0 Then
        ml.pName = MAP_NOT_FOUND
        DirBSPsToPopupList = ml
        Exit Function
    End If
    
    DirBSPsToPopupList = ml
    
    Exit Function
    
Trap:
    Select Case Err.Number
        Case 52, 68, 71, 76:  'Invalid Device, Drive not ready, couldn't find directory
            ml.pName = MAP_NOT_FOUND
            DirBSPsToPopupList = ml
            Exit Function
        Case Else:
            ReportError Err.Number, Err.Description, "<Adding Maps to List>"
    End Select
    
End Function

Public Function DirPakBspsToPopupList(dirName As String) As PopupList

    Dim currentFile As String
    Dim returnList As PopupList
    Dim tempList As PopupList
    
    On Error GoTo Hell
    
    returnList.pName = MAP_NOT_FOUND
    currentFile = Dir(dirName & "\*.pak")
    
    Do Until currentFile = ""
        tempList = PakBSPsToPopupList(dirName & "\" & currentFile)
        If tempList.pName <> MAP_NOT_FOUND Then
            If returnList.pName <> MAP_NOT_FOUND Then
                returnList = ConcatPopupList(returnList, tempList)
            Else
                returnList = tempList
            End If
        End If
        currentFile = Dir
    Loop
    
    DirPakBspsToPopupList = returnList
    
    Exit Function
    
Hell:
    Select Case Err.Number
        Case 52, 68, 76:  'Bad file, drive stuff
           'Don't do anything... returning the empty list will
           'make the program flow just fine...
        Case Else:
            ReportError Err.Number, Err.Description, "<Getting Map Names from PAK Files>"
    End Select

    DirPakBspsToPopupList = returnList

End Function

Private Sub SetIniPath()

    Dim temp As String
    
    temp = CommandKeyValue("ini")
    
    If temp = "" Then
        iniPath = INI_PATH_NOT_SET
    Else
        If LCase(Right(temp, 4)) <> ".ini" Then
            temp = temp & ".ini"
        End If
        If LCase(temp) = "qtray.ini" Then
            temp = "I'm sorry, but QTray.ini is reserved for me."
            MsgBox temp, vbExclamation, AppName
            End
        End If
        iniPath = App.Path & "\" & temp
    End If

End Sub
