/*
Copyright (C) 2000 Jason Wilkins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "shaders.h"
#include "sh_internal.h"

#define OUT_OF_RANGE "<error: out of range>"



/* sh_string_from_waveform:
 ***************************************************************************/
const char* sh_string_from_waveform(int w)
{
   switch(w) {
      case SH_WAVE_SIN:
         return "sin";

      case SH_WAVE_TRIANGLE:
         return "triangle";

      case SH_WAVE_SQUARE:
         return "square";

      case SH_WAVE_SAWTOOTH:
         return "sawtooth";

      case SH_WAVE_INVSAWTOOTH:
         return "inverseSawtooth";

      case SH_WAVE_NOISE:
         return "noise";

      default:
         return OUT_OF_RANGE;
   }
}



/* sh_string_from_vxmod:
 ***************************************************************************/
const char* sh_string_from_vxmod(int v)
{
   switch(v) {
      case SH_VXMOD_WAVE:
         return "wave";

      case SH_VXMOD_NORMAL:
         return "normal";

      case SH_VXMOD_BULGE:
         return "bulge";

      case SH_VXMOD_MOVE:
         return "move";

      case SH_VXMOD_AUTOSPRITE:
         return "autosprite";

      case SH_VXMOD_AUTOSPRITE2:
         return "autosprite2";

      case SH_VXMOD_PROJECTION_SHADOW:
         return "projectionShadow";

      case SH_VXMOD_TEXT0:
         return "text0";

      case SH_VXMOD_TEXT1:
         return "text1";

#ifdef SH_PHOENIX_QUAKE1_EXT
      case SH_VXMOD_STENCIL_SHADOW_EXT:
         return "stencilShadow";
#endif

      default:
         return OUT_OF_RANGE;
   }
}



/* sh_string_from_cull:
 ***************************************************************************/
const char* sh_string_from_cull(int c)
{
   switch(c) {
      case SH_CULL_FRONT:
         return "front";

      case SH_CULL_BACK:
         return "back";

      case SH_CULL_DISABLE:
         return "disable";

#ifdef SH_PHOENIX_QUAKE1_EXT
      case SH_CULL_BOTH_EXT:
         return "_both";
#endif

      default:
         return OUT_OF_RANGE;
   }
}



/* sh_string_from_sort:
 ***************************************************************************/
const char* sh_string_from_sort(int s)
{
   static char buf[3];

   switch(s) {
      case SH_SORT_PORTAL:
         return "portal";

      case SH_SORT_SKY:
         return "sky";

      case SH_SORT_OPAQUE:
         return "opaque";

      case SH_SORT_BANNER:
         return "banner";

      case SH_SORT_UNDERWATER: 
         return "underwater";

      case SH_SORT_ADDITIVE:   
         return "additive";

      case SH_SORT_NEAREST:
         return "nearest";

      case SH_SORT_SEE_THROUGH:
      case SH_SORT_DECAL:
      case SH_SORT_FOG:        
      case SH_SORT_STENCIL_SHADOW:
      case SH_SORT_NUM_SORTS:
      default:
         if ((s >= 1) && (s <= 16)) {
            sprintf(buf, "%d", s);

            return buf;
         }
         else {
            return OUT_OF_RANGE;
         }
   }
}



/* sh_string_from_blend:
 ***************************************************************************/
const char* sh_string_from_blend(int b)
{
   switch(b) {
      case SH_BLEND_ONE:
         return "GL_ONE";

      case SH_BLEND_ZERO:
         return "GL_ZERO";

      case SH_BLEND_DST_COLOR:
         return "GL_DST_COLOR";

      case SH_BLEND_ONE_MINUS_DST_COLOR:
         return "GL_ONE_MINUS_DST_COLOR";

      case SH_BLEND_SRC_ALPHA:
         return "GL_SRC_ALPHA";

      case SH_BLEND_ONE_MINUS_SRC_ALPHA:
         return "GL_ONE_MINUS_SRC_ALPHA";

      case SH_BLEND_DST_ALPHA:
         return "GL_DST_ALPHA";

      case SH_BLEND_ONE_MINUS_DST_ALPHA:
         return "GL_ONE_MINUS_DST_ALPHA";

      case SH_BLEND_SRC_COLOR:
         return "GL_SRC_COLOR";

      case SH_BLEND_ONE_MINUS_SRC_COLOR:
         return "GL_ONE_MINUS_SRC_COLOR";

      default:
         return OUT_OF_RANGE;
   }
}



/* sh_string_from_alphafunc:
 ***************************************************************************/
const char* sh_string_from_alphafunc(int a)
{
   switch (a) {
      case SH_ALPHAFUNC_GT0:
         return "GT0";

      case SH_ALPHAFUNC_LT128:
         return "LT128";

      case SH_ALPHAFUNC_GE128:
         return "GE128";

      default:
         return OUT_OF_RANGE;
   }
}



/* sh_string_from_depthfunc:
 ***************************************************************************/
const char* sh_string_from_depthfunc(int d)
{
   switch (d) {
      case SH_DEPTHFUNC_LEQUAL:
         return "lequal";

      case SH_DEPTHFUNC_EQUAL:
         return "equal";

      default:
         return OUT_OF_RANGE;
   }
}



/* sh_string_from_rgbagen:
 ***************************************************************************/
const char* sh_string_from_rgbagen(int g)
{
   switch (g) {
      case SH_RGBAGEN_IDENTITY_LIGHTING:
         return "identityLighting";

      case SH_RGBAGEN_IDENTITY:
         return "identity";

      case SH_RGBAGEN_WAVE:
         return "wave";

      case SH_RGBAGEN_ENTITY:
         return "entity";

      case SH_RGBAGEN_ONE_MINUS_ENTITY:
         return "oneMinusEntity";

      case SH_RGBAGEN_VERTEX:
         return "vertex";

      case SH_RGBAGEN_ONE_MINUS_VERTEX:
         return "oneMinusVertex";

      case SH_RGBAGEN_PORTAL:
         return "portal";

      case SH_RGBAGEN_LIGHTING_DIFFUSE:
         return "lightingDiffuse";

      case SH_RGBAGEN_LIGHTING_SPECULAR:
         return "lightingSpecular";

#ifdef SH_PHOENIX_QUAKE1_EXT
      case SH_RGBAGEN_ONE_MINUS_PORTAL_EXT:
         return "_oneMinusPortal";

      case SH_RGBAGEN_CONST_EXT:
         return "_const";
#endif

      default:
         return OUT_OF_RANGE;
   }
}



/* sh_string_from_tcmod:
 ***************************************************************************/
const char* sh_string_from_tcmod(int t)
{
   switch (t) {
      case SH_TCMOD_ROTATE:
         return "rotate";

      case SH_TCMOD_SCALE:
         return "scale";

      case SH_TCMOD_SCROLL:
         return "scroll";

      case SH_TCMOD_STRETCH:
         return "stretch";

      case SH_TCMOD_TRANSFORM:
         return "transform";

      case SH_TCMOD_TURB:
         return "turb";

      default:
         return OUT_OF_RANGE;
   }
}



/* sh_string_from_tcgen:
 ***************************************************************************/
const char* sh_string_from_tcgen(int t)
{
   switch (t) {
      case SH_TCGEN_BASE:
         return "base";

      case SH_TCGEN_LIGHTMAP:
         return "lightmap";

      case SH_TCGEN_ENVIRONMENT:
         return "environment";

      case SH_TCGEN_VECTOR:
         return "vector";

#ifdef SH_PHOENIX_QUAKE1_EXT
      case SH_TCGEN_SKY_EXT:
         return "_sky";

      case SH_TCGEN_Q1TURB_EXT:
         return "_q1turb";
#endif

      default:
         return OUT_OF_RANGE;
   }
}
