/*
Copyright (C) 2000 Jason Wilkins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "shaders.h"
#include "sh_internal.h"



static sh_output_func_t output_func = sh_output_file_func;

// FIXME: this buffer could overflow
size_t _sh_scratch_size = _SH_SCRATCH_START_SIZE;
char   _sh_scratch[_SH_SCRATCH_START_SIZE];



/* sh_output:
 ***************************************************************************/
void sh_output(const char* format, ... )
{
   if (output_func) {
      va_list     argptr;

      va_start(argptr, format);
      vsprintf(_sh_scratch, format, argptr);
      va_end(argptr);

      output_func(_sh_scratch);
   }
}



/* sh_output_set_func:
 ***************************************************************************/
sh_output_func_t sh_output_set_func(sh_output_func_t f)
{
   sh_output_func_t o;
   
   o = output_func;
   output_func = f;

   return o;
}



/***************************************************************************\

string output

\***************************************************************************/

static char* curpos;
static char* endpos;



/* sh_output_string_func:
 ***************************************************************************/
void sh_output_string_func(const char* string)
{
   size_t len  = strlen(string);
   size_t size = endpos - curpos;

   strncpy(curpos, string, size);

   if (len < size) {
      curpos += len;
   }
   else {
      curpos += size;
   }
}



/* sh_output_set_string:
 ***************************************************************************/
void sh_output_set_string(char* string, size_t size)
{
   curpos = string;
   endpos = string + size;
}



/***************************************************************************\

standard file output

\***************************************************************************/

static FILE* _output_file = stdout;



/* sh_output_file_func:
 ***************************************************************************/
void sh_output_file_func(const char* string)
{
   int len = strlen(string);
   fwrite(string, len, 1, _output_file);
}



/* sh_output_set_file:
 ***************************************************************************/
FILE* sh_output_set_file(FILE* f)
{
   FILE* o;
   
   o = _output_file;
   _output_file = f;

   return o;
}


