/*
Copyright (C) 2000 Jason Wilkins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "shaders.h"
#include "shader_internal.h"



static shader_t* _previous_allocation = NULL;

static sh_alloc_func_t _sh_alloc = sh_alloc_static_func;



/* sh_alloc:
 ***************************************************************************/
shader_t* sh_alloc(void)
{
   if (!_previous_allocation) _previous_allocation = _sh_alloc();

   return _previous_allocation;
}



/* _sh_alloc_keep:
 ***************************************************************************/
void _sh_alloc_keep(void)
{
   _previous_allocation = NULL;
}



/* sh_alloc_set_func:
 ***************************************************************************/
sh_alloc_func_t sh_alloc_set_func(sh_alloc_func_t a)
{
   sh_alloc_func_t o;
   
   o = _sh_alloc;
   _sh_alloc = a;

   return o;
}



/***************************************************************************\

static memory manager

\***************************************************************************/

static shader_t static_shader;



/* sh_alloc_static_func:
 ***************************************************************************/
shader_t* sh_alloc_static_func(void)
{
   return &static_shader;
}



/***************************************************************************\

array memory manager

\***************************************************************************/

int       shader_count;
int       shader_array_size;
shader_t* shaders;



/* sh_alloc_array_func:
 ***************************************************************************/
shader_t* sh_alloc_array_func(void)
{
   if (shader_count < shader_array_size) {
      return &shaders[shader_count++];
   }
   else {
      sh_message(SH_MSG_ERROR, "number of shaders exceeds shader_array_size (%d)", shader_array_size);
      return NULL;
   }
}



/* sh_alloc_set_array:
 ***************************************************************************/
shader_t* sh_alloc_set_array(shader_t* array, size_t size)
{
   shader_t* old;

   old               = shaders;
   shaders           = array;
   shader_array_size = size;
   shader_count      = 0;

   return old;
}


