#ifndef SHADER_INTERNAL_INCLUDED
#define SHADER_INTERNAL_INCLUDED

/*
Copyright (C) 2000 Jason Wilkins

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

typedef enum {
   _SH_TOK_EOF = 256,
   _SH_TOK_STRING,
} _SH_TOKEN;

typedef struct sh_token_s {
   char string[SH_TOKEN_LEN+1];
   bool is_newline;
} sh_token_t;



extern int _sh_error_count;
extern int _sh_warning_count;
extern int _sh_compatibility_count;

extern int _sh_line_count;

extern sh_token_t token;

extern bool _sh_parse_stop;



void  _sh_alloc_keep(void);

void      _sh_begin_scan(void);
_SH_TOKEN _sh_scan(void);
void      _sh_end_scan(void);
bool      _sh_skip();



#endif
