// This program requires the Allegro Game Programming Library to compile.

#include <allegro.h>
#include <stdio.h>


BEGIN_GFX_DRIVER_LIST
END_GFX_DRIVER_LIST

BEGIN_COLOR_DEPTH_LIST
COLOR_DEPTH_24
COLOR_DEPTH_32
END_COLOR_DEPTH_LIST





int main(int argc, char* argv[])
{
   BITMAP* color;
   BITMAP* alpha;
   int     x, y;

   if (argc != 4) {
      printf("\nTGA Combiner v0.1\n\n");
      printf("usage: %s <color.tga> <alpha.tga> <output.tga>\n\n", argv[0]);
      printf("This program creates a 32-bit Targa file called\n"
             "output.tga that has RGB components taken from\n"
             "color.tga and the alpha component created by\n"
             "averaging the RGB components of alpha.tga.\n\n");

      return 1;
   }

   allegro_init();

   set_color_depth(32);

   color = load_tga(argv[1], NULL);

   if (!color) {
      printf("Error loading color source '%s'\n", argv[1]);
      return 2;
   }

   alpha = load_tga(argv[2], NULL);

   if (!alpha) {
      printf("Error loading alpha source '%s'\n", argv[2]);
      return 3;
   }

   if ((color->w != alpha->w) || (color->h != alpha->h)) {
      printf("The alpha and color source must be the same dimensions.\n");
      return 4;
   }

   for (y = 0; y < color->h; y++) {
      for (x = 0; x < color->w; x++) {
         int c;
         int ar, ag, ab;
         int a;

         c = getpixel(color, x, y);
         a = getpixel(alpha, x, y);

         c &= 0x00FFFFFF;

         ar = (a & 0x00FF0000) >> 16;
         ag = (a & 0x0000FF00) >> 8;
         ab = (a & 0x000000FF);

         a = (ar + ag + ab) / 3;

         a <<= 24;

         c = c | a;

         putpixel(color, x, y, c);
      }
   }

   save_tga(argv[3], color, NULL);

   return 0;
}
