// fenix@io.com: vertex arrays

#ifndef GL_RVA_INCLUDED
#define GL_RVA_INCLUDED

/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

typedef struct vavertex_s {
   float         x, y, z;       // vertex
   float         s, t;          // texcoord
   signed char   i, j, k;       // normal
   unsigned char n;             // normal index
   unsigned char r, g, b, a;    // color
} vavertex_t;

typedef struct texcoord_s {
   float s, t;
} texcoord_t;

typedef enum {
    R_COLOR3    = 1,
    R_COLOR4    = 2,
    R_TEXCOORD2 = 4,
    R_VERTEX2   = 8,
    R_VERTEX3   = 16
} R_VAFIELD;

typedef enum {
    R_POINTS,
    R_LINES,
    R_LINE_STRIP,
    R_LINE_LOOP,
    R_TRIANGLES,
    R_TRIANGLE_STRIP,
    R_TRIANGLE_FAN,
    R_QUADS,
    R_QUAD_STRIP,
    R_POLYGON
} R_MODE;

extern vavertex_t* global_vertex_array;
extern unsigned*   global_indice_array;
extern int global_vertex_array_size;
extern int global_indice_array_size;
extern texcoord_t* global_lightmap_texcoords;
extern texcoord_t* current_lightmap_texcoords;

void R_InitVertexArrays(void);
void R_VertexArray(vavertex_t* varray, unsigned fields);
void R_DrawArray(R_MODE mode, int first, size_t count);
void SHADER_R_DrawArray(R_MODE mode, int first, size_t count);
void R_DrawElements(R_MODE mode, size_t count, unsigned* indices);
void R_DrawRangeElements(R_MODE, unsigned start, unsigned end, size_t count, unsigned* indices);

void R_Lightmap(texcoord_t* texcoords, int texnum);

#endif
