// fenix@io.com: shaders

#ifndef GL_SHADER_INCLUDED
#define GL_SHADER_INCLUDED

/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "varrays.h"

#define R_SHADER_NAME_LEN      64
#define R_MAX_SHADER_STAGES     8
#define R_MAX_SHADER_ARGS      12
#define R_MAX_TCMODS            8
#define R_MAX_VXMODS            8
#define R_MAX_ANIMMAPS          8
#define R_NOT_FOUND      (-1)
#define R_OUT_OF_MEMORY  (-2)
#define R_UNKNOWN_TYPE   (-3)



typedef struct texture_map_s {
    char name[R_SHADER_NAME_LEN];
    int  index;
} texture_map_t;

typedef struct shader_pic_s {
    int     shader_num;
    int     width, height;
   	float	sl, tl;
    float   sh, th;
    unsigned char r, g, b, a;
} shader_pic_t;



typedef enum {
    R_SIN,
    R_TRIANGLE,
    R_SQUARE,
    R_SAWTOOTH,
    R_INVSAWTOOTH,
    R_NOISE
} R_WAVEFORM;

typedef enum {
   R_IS_LOADED              = 1,
   R_IS_COMPILABLE          = 2,
   R_SHADER_POLYGON_OFFSET  = 4,
   R_SHADER_HAS_SORT        = 8,
   R_SHADER_HAS_CULL        = 16,
   R_SHADER_HAS_SKYPARMS    = 32,
   R_SHADER_HAS_NEARBOX     = 64,
   R_SHADER_HAS_FARBOX      = 128,
   R_SHADER_SAVE_MATRIX     = 256,
   R_SHADER_HAS_FOGPARMS    = 512,
   R_SHADER_ENTITY_MERGABLE = 1024
} R_SHADER_FLAGS;



// skyParms

typedef enum {
   R_SKY_RIGHT,
   R_SKY_LEFT,
   R_SKY_FRONT,
   R_SKY_BACK,
   R_SKY_UP
} R_SKY_BOX;



// cull

typedef enum {
   R_FRONT,
   R_BACK,
   R_FRONT_AND_BACK
} R_POLYGON_FACE;



// deformVertexes

typedef void (*vxmod_func_t)(
   struct vxmod_s* vxmod,
   int             mode,
   vavertex_t*     varray,
   int             first,
   int             count);

typedef struct vxmod_s {
   vxmod_func_t func;

   union {
      struct {
         float      div;
         R_WAVEFORM form;
         float      base;
         float      amp;
         float      phase;
         float      freq;
      } wave;

      struct {
         float      div;
         R_WAVEFORM form;
         float      base;
         float      amp;
         float      phase;
         float      freq;
      } normal;

      struct {
         float width, height;
         float speed;
      } bulge;

      struct {
         float      x, y, z;
         R_WAVEFORM form;
         float      base;
         float      amp;
         float      phase;
         float      freq;
      } move;

      // autosprite has no arguments

      // autosprite2 has no arguments
   } args;
} vxmod_t;



// fogparms



// nomipmaps



// nopicmip



// polygonOffset



// portal



// sort

typedef enum {
   R_SORT_PORTAL     = 1,
   R_SORT_SKY        = 2,
   R_SORT_OPAQUE     = 3,
   R_SORT_BANNER     = 6,
   R_SORT_UNDERWATER = 8,
   R_SORT_ADDITIVE   = 9,
   R_SORT_NEAREST    = 16
} R_SHADER_SORT_PRIORITY;

// map



// clampmap



// AnimMap



// rgbaGen

typedef void (*rgbgen_func_global_t)(struct rgbgen_s*, unsigned char color_out[4]);
typedef void (*rgbgen_func_local_t)(struct rgbgen_s*, vavertex_t*, int, int);

typedef struct rgbgen_s {
   union {
      rgbgen_func_local_t  local;
      rgbgen_func_global_t global;
   } func;

   union {
      // identityLighting has no arguments

      // identity has no arguments

      struct {
         R_WAVEFORM form;
         float      base;
         float      amp;
         float      phase;
         float      freq;
      } wave;

      // entity has no arguments

      // oneMinusEntity has no arguments

      // vertex has no arguments

      // oneMinusVertex has no arguments
   } args;
} rgbgen_t;

typedef void (*alphagen_func_global_t)(struct alphagen_s*, unsigned char color_out[4]);
typedef void (*alphagen_func_local_t)(struct alphagen_s*, vavertex_t*, int, int);

typedef struct alphagen_s {
   union {
      alphagen_func_local_t  local;
      alphagen_func_global_t global;
   } func;

   union {
      struct {
         float dist_to_opaque;
      } portal;

      struct {
         R_WAVEFORM form;
         float      base;
         float      amp;
         float      phase;
         float      freq;
      } wave;
   } args;
} alphagen_t;


typedef void (*rgbagen_func_t)(struct rgbgen_s* rgbgen, struct alphagen_s* alphagen, vavertex_t* varray, int first, int count);



// tcMod

typedef struct texmat_s {
   float m00, m01;
   float m10, m11;
   float t0,  t1;
} texmat_t;

typedef void (*tcmod_func_t)(struct tcmod_s*, vavertex_t*, int, int);

typedef struct tcmod_s {
    tcmod_func_t func;

    union {
       struct {
          float speed;
       } rotate;

       struct {
          float s, t;
       } scale;

       struct {
          float s, t;
       } scroll;
    
       struct {
          R_WAVEFORM form;
          float      base;
          float      amp;
          float      phase;
          float      freq;
       } stretch;

       texmat_t transform;

       struct {
          float      base;
          float      amp;
          float      phase;
          float      freq;
       } turb;

       struct {
          float      div;
          R_WAVEFORM form;
          float      base;
          float      amp;
          float      phase;
          float      freq;
       } wave;
    } args;
} tcmod_t;



// tcGen

typedef void (*tcgen_func_t)(struct tcgen_s*, vavertex_t*, int, int);

typedef struct tcgen_s {
   tcgen_func_t func;

   union {
      struct {
         float sx, sy, sz;
         float tx, ty, tz;
      } vector;
   } args;
} tcgen_t;



typedef int (*parse_func_t)(struct shader_s* shader, struct shader_stage_s* stage, int argc, char* argv[]);

typedef struct stage_map_s {
    int  map_num;
    char bspmap_name[17];
    int  bspmap_clampmap;
    int  bspmap_alpha;
    int  bspmap_mipmaps;
    int  bspmap_picmip;
   qboolean bspmap_unloaded;
} stage_map_t;

typedef struct shader_stage_s {
    unsigned flags;

    unsigned on_fields;
    unsigned off_fields;

    // blendfunc
    int blend_src;
    int blend_dst;

    // alphatest
    int   alpha_test_func;
    float alpha_test_ref;

    // depthfunc
    int depth_test_func;

    // tcMod
    int     num_tcmods;
    tcmod_t tcmods[R_MAX_TCMODS];

    // tcGen
    tcgen_t tcgen;

    // rgbaGen
    rgbgen_t       rgbgen;
    alphagen_t     alphagen;
    rgbagen_func_t rgbagen_func;

    // _filter
    int min_filter;
    int mag_filter;

    // map, clampmap, animmap
    stage_map_t map[R_MAX_ANIMMAPS];
    int         num_maps;
    float       anim_map_interval;
} shader_stage_t;



typedef struct shader_s {
    char name[R_SHADER_NAME_LEN];

    unsigned flags;

    // skyParms
    float cloudheight;
    int   farbox[5];
    int   nearbox[5];

    // cull
    int cull_face;

    // deformVertexes
    int     num_vxmods;
    vxmod_t vxmods[R_MAX_VXMODS];

    // fogparms
    vec3_t fog_color;
    float  fog_distance_to_opaque;

    // sort
    int sort_priority;

    // stages
    int            num_stages;
    shader_stage_t stages[R_MAX_SHADER_STAGES];
} shader_t;

typedef enum {
   R_ONE,
   R_ZERO,
   R_DST_COLOR,
   R_ONE_MINUS_DST_COLOR,
   R_SRC_ALPHA,
   R_ONE_MINUS_SRC_ALPHA,
   R_SRC_COLOR,
   R_ONE_MINUS_SRC_COLOR,
} R_BLEND_FACTOR;

typedef enum {
   R_NEVER,
   R_ALWAYS,
   R_LESS,
   R_LEQUAL,
   R_EQUAL,
   R_GEQUAL,
   R_GREATER,
   R_NOTEQUAL
} R_FUNC;

typedef enum {
   R_HAS_BLENDFUNC        = 1,
   R_HAS_ALPHAFUNC        = 2,
   R_STAGE_SAVE_COLORS    = 32,
   R_STAGE_SAVE_TEXCOORDS = 64,
   R_STAGE_SAVE_ALPHA     = 128,
   R_STAGE_MODULATE       = 256,
   R_DEPTHWRITE           = 512,
   R_DETAIL               = 1024,
   R_STAGE_HAS_FILTER     = 2048
} R_STAGE_FLAGS;

typedef enum {
   R_MAP_WHITEIMAGE,
   R_MAP_LIGHTMAP,
   R_MAP_CHECKER,
   R_MAP_QUESTION,
   R_MAP_EXCLAIM,
   R_MAP_FIRST_USER_MAP
} R_SPECIAL_MAPS;

typedef enum {
   R_NEAREST,
   R_LINEAR,
   R_NEAREST_MIPMAP_NEAREST,
   R_NEAREST_MIPMAP_LINEAR,
   R_LINEAR_MIPMAP_NEAREST,
   R_LINEAR_MIPMAP_LINEAR
} R_FILTER;

void R_InitShaders(void);
void R_Shader(int shader_num);
void R_ShaderName(const char* name);
int  R_RequestShader(const char* name);
void R_LoadShaders(const char* name);
void R_ParseShaders(char* text, size_t size);
void R_ClearShaders(void);
int  R_GetShader(const char* name);
int  R_LoadMapFromLump(const char* name, qboolean mipmap, qboolean picmip, qboolean alpha, qboolean clampmap);
int  R_LoadMapFromTarga(const char* name, qboolean mipmap, qboolean picmip, qboolean alpha, qboolean clampmap);
int  R_SafeLoadMap(const char* name, qboolean mipmap, qboolean picmap, qboolean alpha, qboolean clampmap);
int  R_LoadMap(const char* name, qboolean mipmap, qboolean picmap, qboolean alpha, qboolean clampmap);
void R_Bind(shader_stage_t* stage);
void R_ReloadTexture32(int texnum, unsigned* data, int width, int height, qboolean mipmap, qboolean picmip, qboolean alpha, qboolean clampmap);

void R_SaveST(vavertex_t* varray, int first, int count);
void R_RestoreST(vavertex_t* varray, int first, int count);

void R_SaveRGB(vavertex_t* varray, int first, int count);
void R_RestoreRGB(vavertex_t* varray, int first, int count);

void R_SaveAlpha(vavertex_t* varray, int first, int count);
void R_RestoreAlpha(vavertex_t* varray, int first, int count);

void R_MulTexMatrix(texmat_t* m1, texmat_t* m2, texmat_t* out);
void R_ApplyTexMatrix(texmat_t* m, vavertex_t* varray, int first, int count);

void R_EntityColor(float r, float g, float b, float a);

void R_RequestShaderPic(shader_pic_t* pic, const char* name, float width, float height);

// fenix@io.com: targa loading
// this was copied from gl_warp.h
typedef struct _TargaHeader {
	unsigned char 	id_length, colormap_type, image_type;
	unsigned short	colormap_index, colormap_length;
	unsigned char	colormap_size;
	unsigned short	x_origin, y_origin, width, height;
	unsigned char	pixel_size, attributes;
} TargaHeader;


extern TargaHeader	targa_header;
extern byte			*targa_rgba;

void LoadTGA (FILE *fin);

int GL_LoadTexture32 (char *identifier, int width, int height, int* data, qboolean mipmap, qboolean picmip, qboolean alpha, qboolean clampmap);
// --

extern int       shader_array_size;
extern shader_t* shaders;
extern int       num_shaders;

extern shader_t* current_shader;

extern int            texture_map_array_size;
extern texture_map_t* texture_maps;
extern int            num_texture_maps;

extern qboolean restore_st;

extern const texmat_t identity_texmat;

extern texmat_t shader_texmat;
extern qboolean is_shader_texmat_dirty;

extern cvar_t r_detail;

extern qboolean overbright;

__inline void R_ApplyShaderTexMatrix(vavertex_t* varray, int first, int count)
{
   if (is_shader_texmat_dirty) {
      R_ApplyTexMatrix(&shader_texmat, varray, first, count);
      shader_texmat = identity_texmat;
      is_shader_texmat_dirty = false;
   }
}



#define CLAMP(min, val, max) ((val < min)?(min):((val > max)?(max):(val)))



#endif
