// fenix@io.com: shaders

#ifndef GL_SHADER_INCLUDED
#define GL_SHADER_INCLUDED

/*
Copyright (C) 1996-1997 Id Software, Inc.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  

See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "varrays.h"

#define R_SHADER_NAME_SIZE     64
#define R_MAX_SHADER_STAGES     5
#define R_MAX_SHADER_ARGS      10
#define R_MAX_TCMODS            8
#define R_NOT_FOUND      (-1)
#define R_OUT_OF_MEMORY  (-2)
#define R_UNKNOWN_TYPE   (-3)


typedef enum {
    R_SIN,
    R_TRIANGLE,
    R_SQUARE,
    R_SAWTOOTH,
    R_INVSAWTOOTH   
} R_WAVEFORM;

typedef struct texture_map_s {
    char name[R_SHADER_NAME_SIZE];
    int  index;
} texture_map_t;

typedef struct shader_pic_s {
    int     shader_num;
    int     width, height;
   	float	sl, tl;
    float   sh, th;
} shader_pic_t;

typedef void (*tcmod_func_t)(struct tcmod_s* tcmod, vavertex_t* va, int first, int count);

typedef struct tcmod_s {
    tcmod_func_t func;

    union {
       float rotate;

       struct {
          float s, t;
       } scale;

       struct {
          float s, t;
       } scroll;
    
       struct {
           R_WAVEFORM func;
           float      base;
           float      amp;
           float      phase;
           float      freq;
       } stretch;

       struct {
           float m00, m01;
           float m11, m10;
           float  t0,  t1;
       } transform;

       struct {
           R_WAVEFORM func;
           float      base;
           float      amp;
           float      phase;
           float      freq;
       } turb;
    } args;
} tcmod_t;

typedef int (*parse_func_t)(struct shader_s* shader, struct shader_stage_s* stage, int argc, char* argv[]);

typedef struct shader_command_s {
    char*        name;
    int          min_argc;
    int          max_argc;
    qboolean     is_stage_command;
    parse_func_t parse;
} shader_command_t;

typedef struct shader_stage_s {
    int     flags;
    int     blend_src;
    int     blend_dst;
    tcmod_t tcmods[R_MAX_TCMODS];
    int     num_tcmods;
    int     map;
} shader_stage_t;

typedef struct shader_s {
    char           name[R_SHADER_NAME_SIZE];
    int            num_stages;
    shader_stage_t stages[R_MAX_SHADER_STAGES];
    int            is_loaded;
} shader_t;

typedef enum {
   R_ONE,
   R_ZERO,
   R_DST_COLOR,
   R_ONE_MINUS_DST_COLOR,
   R_SRC_ALPHA,
   R_ONE_MINUS_SRC_ALPHA,
   R_SRC_COLOR,
   R_ONE_MINUS_SRC_COLOR,
} R_BLEND_FACTOR;

typedef enum {
   R_HAS_BLENDFUNC = 1
} R_STAGE_FLAGS;

void R_InitShaders(void);
void R_Shader(int shader_num);
void R_ShaderName(const char* name);
int  R_RequestShader(const char* name);
void R_LoadShaders(const char* name);
void R_ParseShaders(char* text, size_t size);
void R_ClearShaders(void);
int  R_GetShader(const char* name);
int  R_LoadMapFromLump(const char* name, qboolean mipmap, qboolean alpha);

void R_RestoreST(vavertex_t* varray, int first, int count);

// fenix@io.com: targa loading
// this was copied from gl_warp.h
typedef struct _TargaHeader {
	unsigned char 	id_length, colormap_type, image_type;
	unsigned short	colormap_index, colormap_length;
	unsigned char	colormap_size;
	unsigned short	x_origin, y_origin, width, height;
	unsigned char	pixel_size, attributes;
} TargaHeader;


extern TargaHeader	targa_header;
extern byte			*targa_rgba;

void LoadTGA (FILE *fin);

int GL_LoadTexture32 (char *identifier, int width, int height, int* data, qboolean mipmap, qboolean alpha);
// --

extern int       shader_array_size;
extern shader_t* shaders;
extern int       num_shaders;

extern int            texture_map_array_size;
extern texture_map_t* texture_maps;
extern int            num_texture_maps;

extern int current_shader;

extern qboolean restore_st;

#endif
