// These are shaders that are loaded by the initialization
// code for things like the console background, icons, and
// menus



// The alpha component of the console is reduced depending
// on how high the console is.  So, if you want the console
// to to be transparent, make sure to use 'blendfunc blend'
// on at least the first stage.

console
{
        nomipmaps
        nopicmip

        {
                map gfx/phoenix1.tga
                blendfunc blend
                tcMod turb sin 0 .01 0 .1
        }
        {
                map gfx/phoenix2.tga
                blendfunc add
                tcMod scale 1 1.2
                tcMod turb sin 0 .07 0 .2
                tcMod scroll 0 .7
        }
}



// This is the console shader from Quake 3 Arena.  To try it
// out just change its name to 'console' and rename the one
// above to something like 'foobar'

q3console
{
        nomipmaps
        nopicmip

        {
                map gfx/console01.tga
                blendfunc GL_ONE GL_ZERO
                tcMod scroll .02 0
                tcMod scale 2 1
        }
        {
                map gfx/console02.tga
                blendfunc add
                tcMod turb sin 0 .1 0 .1
                tcScale 2 1
                tcMod scroll .2 .1
        }
}



// This is the old, tried and true glquake console for those
// that don't like them new fangled fancy shaders.

q1console
{
        nomipmaps
        nopicmip

        {
                map gfx/conback.lmp
                blendfunc blend
        }
}


