// These are shaders that are loaded by the initialization
// code for things like the console background, icons, and
// menus


// The alpha component of the console is reduced
// depending on how high the console is.  So, if
// you want the console to be transparent, make
// sure to use 'blendfunc blend', and 'alphaGen entity'


// Official Phoenix Quake Console

console
//phoenix_console
{
        nomipmaps
        nopicmip

        {
                map gfx/misc/quake.tga
                blendfunc blend
                tcMod _wave 1 sin 0 .01 0 .1
                rgbGen vertex
                alphaGen vertex
        }
        {
                map gfx/misc/phoenix2.tga
                blendfunc add
                rgbGen identity
                tcMod scale 1.2 1.2
                tcMod _wave 1 sin 0 .07 0 .2
                tcMod scroll 0 .7
        }
}



// This is the console shader from Quake 3 Arena.  To try it
// out just change its name to 'console'

//console
q3console
{
        nopicmip
        nomipmaps

        {
                map gfx/misc/console01.tga
                blendFunc GL_ONE GL_ZERO
                tcMod scroll .01  0
                tcmod scale .5 1
        }
        {
                map gfx/misc/console02.tga
                //map textures/sfx/firegorre3.tga
                blendFunc add
                tcMod turb 0 .1 0 .1
                tcMod scale .5 1
                tcmod scroll 0.1  .05
        }
}



// This is the old, tried and true glquake console for those
// that don't like them new fangled fancy shaders.
//
// You can also use this if you want the console background
// of a mod to show up.

//console
q1console
{
        nomipmaps
        nopicmip

        {
                map gfx/conback.lmp
                blendfunc blend
                rgbGen vertex
                alphaGen vertex
        }
}


// I told Topaz I would do his spiral console the hard way...

//console
topaz_console
{
        nomipmaps
        nopicmip

        {
                map gfx/conback.lmp
                blendfunc blend
                tcMod stretch triangle .6 3 0 .15
                tcMod rotate 50
                rgbGen vertex
                alphaGen vertex
        }
}


// Picture divided into 16x16 squares, each one contains a character

conchars
{
        nomipmaps
        nopicmip

        {
                map gfx/2d/conchars.tga
                blendFunc GL_SRC_ALPHA GL_ONE_MINUS_SRC_ALPHA
                rgbGen vertex
                alphaGen vertex
                _filter GL_NEAREST GL_NEAREST
        }
}


// the line at the bottom of the console

console_line
{
        {
                map $whiteimage
                rgbGen vertex
                alphaGen vertex
                blendfunc blend
        }
}


// appears when there is disk activity

disc
{
        nomipmaps
        nopicmip

        {
                map $gfx.wad#disc
        }
}


// used to fill in around the refresh when the screen
// is shrunk.  Do not make this complicated, it is 
// used to reduce fill-rate, and making this more than
// on pass cancels that out.

backtile
{
        nomipmaps
        nopicmip

        {
                map $gfx.wad#backtile
        }
}


// appears when memory is low

ram
{
        nomipmaps
        nopicmip

        {
                map $gfx.wad#ram
        }
}


// appears when there are network problems

net
{
        nomipmaps
        nopicmip

        {
                map $gfx.wad#net
        }
}


// Icon shown when the frame rate falls below scr_turtle_fps
// You probably shouldn't make this into a very complicated
// shader, because if it appears, things are already too much
// to handle.

turtle
{
        nomipmaps
        nopicmip

        {
                map $gfx.wad#turtle
        }
}


