@REM Scourge done Slick batch file
@ECHO off
@REM Check for the SdS directory
cd ..
ECHO Scourge done Slick by the Quake done Quick team (http://PlanetQuake.com/QdQ/)
IF NOT EXIST sds\sds.bat ECHO You need to call your SdS game subdirectory "sds" to use this batch file
IF NOT EXIST sds\sds.bat GOTO END
cd sds

@REM Initialisation
IF EXIST *.tab del *.tab
IF EXIST put_back.bat CALL put_back
ECHO @ECHO off > put_back.bat
ECHO ECHO Returning paks to library >> put_back.bat
IF EXIST firstper.pak GOTO WHICHQUAKE
IF NOT EXIST pak2.pak GOTO WHICHQUAKE

:GRABFIRSTPER
ECHO I think the sds\pak2.pak file you have is probably a set of first-person
ECHO runs. To enable these to be made into an optional add-on, I'm renaming
ECHO that file to "firstper.pak". Don't worry about it, we should be fine.
rename pak2.pak firstper.pak

:WHICHQUAKE
IF EXIST ..\glquake.exe IF EXIST ..\quake.exe IF EXIST ..\winquake.exe GOTO GQW
IF EXIST ..\glquake.exe IF EXIST ..\quake.exe GOTO GQ
IF EXIST ..\glquake.exe IF EXIST ..\winquake.exe GOTO GW
IF EXIST ..\glquake.exe GOTO GLQUAKE
IF EXIST ..\quake.exe IF EXIST ..\winquake.exe GOTO QW
IF EXIST ..\quake.exe GOTO QUAKE
IF EXIST ..\winquake.exe GOTO WINQUAKE
ECHO Failed to find any of GLQuake, WinQuake and Quake.
GOTO END

:GQW
CHOICE /C:GQW "Run using GLQuake.exe, Quake.exe or WinQuake.exe "
IF errorlevel 3 GOTO WINQUAKE
IF errorlevel 2 GOTO QUAKE
IF errorlevel 1 GOTO GLQUAKE
GOTO END

:GQ
CHOICE /C:GQ "Run using GLQuake.exe or Quake.exe "
IF errorlevel 2 GOTO QUAKE
IF errorlevel 1 GOTO GLQUAKE
GOTO END

:GW
CHOICE /C:GW "Run using GLQuake.exe or WinQuake.exe "
IF errorlevel 2 GOTO WINQUAKE
IF errorlevel 1 GOTO GLQUAKE
GOTO END

:QW
CHOICE /C:QW "Run using Quake.exe or WinQuake.exe? "
IF errorlevel 2 GOTO WINQUAKE
IF errorlevel 1 GOTO QUAKE
GOTO END

:GLQUAKE
ECHO ' ' > glquake.tab
ECHO ' ' > glorwinq.tab
IF EXIST ..\hipnotic\gl_fixed.cfg GOTO GLFIXED
SdSfixGL.exe
:GLFIXED
GOTO COUNTPAKS

:WINQUAKE
ECHO ' ' > winquake.tab
ECHO ' ' > glorwinq.tab
GOTO COUNTPAKS

:QUAKE
ECHO ' ' > quake.tab
GOTO COUNTPAKS

:COUNTPAKS
IF NOT EXIST ..\id1\pak0.pak GOTO COUNTHIPNOTIC
CALL counter
IF NOT EXIST ..\id1\pak1.pak GOTO COUNTHIPNOTIC
CALL counter
IF NOT EXIST ..\id1\pak2.pak GOTO COUNTHIPNOTIC
CALL counter
IF NOT EXIST ..\id1\pak3.pak GOTO COUNTHIPNOTIC
CALL counter
IF NOT EXIST ..\id1\pak4.pak GOTO COUNTHIPNOTIC
CALL counter
IF NOT EXIST ..\id1\pak5.pak GOTO COUNTHIPNOTIC
CALL counter
IF NOT EXIST ..\id1\pak6.pak GOTO COUNTHIPNOTIC
CALL counter
IF NOT EXIST ..\id1\pak7.pak GOTO COUNTHIPNOTIC
CALL counter
IF NOT EXIST ..\id1\pak8.pak GOTO COUNTHIPNOTIC
CALL counter

:COUNTHIPNOTIC

IF NOT EXIST ..\hipnotic\pak0.pak GOTO COUNTSDS
CALL counter
IF NOT EXIST ..\hipnotic\pak1.pak GOTO COUNTSDS
CALL counter
IF NOT EXIST ..\hipnotic\pak2.pak GOTO COUNTSDS
CALL counter
IF NOT EXIST ..\hipnotic\pak3.pak GOTO COUNTSDS
CALL counter
IF NOT EXIST ..\hipnotic\pak4.pak GOTO COUNTSDS
CALL counter
IF NOT EXIST ..\hipnotic\pak5.pak GOTO COUNTSDS
CALL counter
IF NOT EXIST ..\hipnotic\pak6.pak GOTO COUNTSDS
CALL counter
IF NOT EXIST ..\hipnotic\pak7.pak GOTO COUNTSDS
CALL counter
IF NOT EXIST ..\hipnotic\pak8.pak GOTO COUNTSDS
CALL counter

:COUNTSDS

IF NOT EXIST pak0.pak GOTO CHECK
CALL counter
IF NOT EXIST pak1.pak GOTO CHECK
CALL counter
IF NOT EXIST pak2.pak GOTO CHECK
CALL counter
IF NOT EXIST pak3.pak GOTO CHECK
CALL counter
IF NOT EXIST pak4.pak GOTO CHECK
CALL counter
IF NOT EXIST pak5.pak GOTO CHECK
CALL counter
IF NOT EXIST pak6.pak GOTO CHECK
CALL counter
IF NOT EXIST pak7.pak GOTO CHECK
CALL counter
IF NOT EXIST pak8.pak GOTO CHECK
CALL counter

:CHECK
IF EXIST 9.tab IF EXIST glorwinq.tab GOTO PROBLEM
GOTO OPTIONS

:OPTIONS
IF NOT EXIST firstper.pak GOTO OPTIONPATCH
CHOICE Do you want to use the first-person runs add-on
IF errorlevel 2 GOTO OPTIONPATCH
CALL move_pak firstper
IF EXIST 9.tab IF EXIST glorwinq.tab GOTO PROBLEM

:OPTIONPATCH
IF EXIST patch.pak CALL move_pak patch
IF EXIST 9.tab IF EXIST glorwinq.tab GOTO PROBLEM

:OPTIONSDSLITE
IF NOT EXIST sdslite.pak GOTO OPTIONMARINEVOCALS
CHOICE Do you want to use the SdSlite add-on
IF errorlevel 2 GOTO OPTIONMARINEVOCALS
CALL move_pak sdslite
IF EXIST 9.tab IF EXIST glorwinq.tab GOTO PROBLEM

:OPTIONMARINEVOCALS
IF NOT EXIST voxjo.pak GOTO RUN
CHOICE Do you want to use the alternative marine vocals add-on
IF errorlevel 2 GOTO RUN
CALL move_pak voxjo
IF EXIST 9.tab IF EXIST glorwinq.tab GOTO PROBLEM

:RUN
cd ..
IF EXIST sds\quake.tab GOTO RUNQUAKE
IF EXIST sds\winquake.tab GOTO RUNWINQUAKE
IF EXIST sds\glquake.tab GOTO RUNGLQUAKE

:RUNGLQUAKE
ECHO Starting GLQuake on SdS
ECHO (Note that GLQuake v0.96 will not display sprites!)
glquake -hipnotic -game sds -zone 512 %1 %2 %3 %4 %5 %6 %7 %8 %9
PAUSE
GOTO HAVERUN

:RUNWINQUAKE
ECHO Starting WinQuake on SdS
winquake -hipnotic -game sds -zone 512 %1 %2 %3 %4 %5 %6 %7 %8 %9
PAUSE
GOTO HAVERUN

:RUNQUAKE
ECHO Starting DOS Quake on SdS
quake -hipnotic -game sds -zone 512 %1 %2 %3 %4 %5 %6 %7 %8 %9
GOTO HAVERUN

:PROBLEM
ECHO You are trying to run GLQuake or WinQuake with more than the maximum
ECHO number of *.pak files allowed. These versions of Quake will only work if
ECHO you use no more than eight *.pak files altogether in your id1\,
ECHO hipnotic\ and sds\ directories.
ECHO ----
ECHO There are four ways you may be able to solve this problem:
ECHO 1. If you have some unnecessary *.paks for such things as a crosshair
ECHO    in your id1\ or hipnotic\ directories, move them out temporarily.
ECHO    Files such as id1\pak2.pak and upwards, or hipnotic\pak1.pak and
ECHO    upwards are probably suitable candidates.
ECHO 2. Each SdS add-on (the first-person runs, the SdSlite runs, the
ECHO    alternative marine vocals, etc) uses one *.pak file. Try selecting
ECHO    less of these options simultaneously.
ECHO 3. Run using normal Quake, not WinQuake or GLQuake. This version can
ECHO    handle any number of *.pak files.
ECHO 4. (For the Quake techie only.) Unpak the paks, or repak several small
ECHO    paks into one larger one, using a tool such as QPed or AdQuEdit.
ECHO ----
ECHO Sorry for the inconvenience. Hope one of these ideas helps!
ECHO ----
GOTO END

:HAVERUN
ECHO Scourge done Slick 1998

:END
IF EXIST sds\sds.bat cd sds
IF EXIST put_back.bat CALL put_back
IF EXIST put_back.bat del put_back.bat
IF EXIST *.tab del *.tab

