#include "g_local.h"
#include "impulse.h"

impulse_export_t impglobals;
game_import_t gi;
impulse_import_t ii;

cvar_t *deathmatch;
cvar_t *sv_cheats;

impulse_export_t *GetImpulseAPI( impulse_import_t _ii );

void ImpulseInit();
void ImpulseShutdown();
void ImpulseCommand( int impulse, edict_t *ent );
void Cmd_Quadize( edict_t *ent );
void Cmd_GiveStuff( edict_t *ent );

impulse_export_t *GetImpulseAPI( impulse_import_t _ii )
{
	ii = _ii;
	gi = ii.gi;

	impglobals.apiversion = IMPULSE_API_VERSION;
	impglobals.ImpulseInit = ImpulseInit;
	impglobals.ImpulseShutdown = ImpulseShutdown;
	impglobals.ImpulseCommand = ImpulseCommand;
	return &impglobals;
}

void ImpulseInit()
{
	deathmatch = gi.cvar( "deathmatch", "0", CVAR_SERVERINFO|CVAR_LATCH );
	sv_cheats = gi.cvar( "sv_cheats", "0", CVAR_SERVERINFO|CVAR_LATCH );
//	gi.cprintf( ent, PRINT_HIGH, "==== QuakeCommands Lib init ====\n" );
}

void ImpulseShutdown()
{
//	gi.bprintf( PRINT_HIGH, "==== QuakeCommands Lib shutdown ====\n" );
}

//Copied from q_devels.c
void stuffcmd(edict_t *e, char *s) 
{
        gi.WriteByte (11);
        gi.WriteString (s);
        gi.unicast (e, true);
}

void ImpulseCommand( int impulse, edict_t *ent )
{
	//gi.cprintf( ent, PRINT_HIGH, "Impulse %i executed.\n", impulse );

/*	if( impulse == 11 || impulse == 255 ) {
		if (deathmatch->value && !strcmp( sv_cheats->string, "1" ))
		{
			gi.cprintf( ent, PRINT_HIGH, "You must run the server with '+set cheats 1' to enable this command.\n");
			return;
		}
	}*/

	switch( impulse ) {
	case 1:		stuffcmd( ent, "use Blaster\n" );
				break;
	case 2:		stuffcmd( ent, "use Shotgun\n" );
				break;
	case 3:		stuffcmd( ent, "use Super Shotgun\n" );
				break;
	case 4:		stuffcmd( ent, "use Machinegun\n" );
				break;
	case 5:		stuffcmd( ent, "use Chaingun\n" );
				break;
	case 6:		stuffcmd( ent, "use Grenade Launcher\n" );
				break;
	case 7:		stuffcmd( ent, "use Rocket Launcher\n" );
				break;
	case 8:		stuffcmd( ent, "use HyperBlaster\n" );
				break;
	case 9:		stuffcmd( ent, "use Railgun\n" );
				break;
	case 10:		stuffcmd( ent, "use BFG10K\n" );
				break;
	case 11:		Cmd_GiveStuff( ent );
				break;
	case 255:		Cmd_Quadize( ent );
				break;
	default:		gi.cprintf( ent, PRINT_HIGH, "This impulse not supported.\n" );
				break;
	}
}

void Cmd_Quadize( edict_t *ent )
{
	if (deathmatch->value && !strcmp( sv_cheats->string, "1" ))
	{
		gi.cprintf( ent, PRINT_HIGH, "You must run the server with '+set cheats 1' to enable this command.\n");
		return;
	}

	if (ent->client->quad_framenum > ii.level->framenum)
		ent->client->quad_framenum += 300;
	else
		ent->client->quad_framenum = ii.level->framenum + 300;

	gi.sound(ent, CHAN_ITEM, gi.soundindex("items/damage.wav"), 1, ATTN_NORM, 0);
}

void Cmd_GiveStuff( edict_t *ent )
{
	if (deathmatch->value && !strcmp( sv_cheats->string, "1" ))
	{
		gi.cprintf( ent, PRINT_HIGH, "You must run the server with '+set cheats 1' to enable this command.\n");
		return;
	}

	stuffcmd( ent, "give all\n" );
}

