#include "g_local.h"
#include "impulse.h"

impulse_export_t impglobals;
game_import_t gi;
impulse_import_t ii;

impulse_export_t *GetImpulseAPI( impulse_import_t _ii );

void ImpulseInit();
void ImpulseShutdown();
void ImpulseCommand( int impulse, edict_t *ent );

impulse_export_t *GetImpulseAPI( impulse_import_t _ii )
{
	ii = _ii;
	gi = ii.gi;

	impglobals.apiversion = IMPULSE_API_VERSION;
	impglobals.ImpulseInit = ImpulseInit;
	impglobals.ImpulseShutdown = ImpulseShutdown;
	impglobals.ImpulseCommand = ImpulseCommand;
	return &impglobals;
}

void ImpulseInit()
{
//	gi.cprintf( ent, PRINT_HIGH, "==== Echo Impulse Lib init ====\n" );
}

void ImpulseShutdown()
{
//	gi.bprintf( PRINT_HIGH, "==== Echo Impulse Lib shutdown ====\n" );
}

void ImpulseCommand( int impulse, edict_t *ent )
{
	gi.cprintf( ent, PRINT_HIGH, "Impulse %i executed.\n", impulse );
}
