// Copyright (C) 1999-2000 Id Software, Inc.
//
// Quake III Radio Version 1.1
// by Sven Jacobs (Sven.Jacobs@gmx.de) 
//
// g_radio.c -- server side radio stuff

#include "g_local.h"


//////////
// MAIN //
//////////

/*
==================
G_RadioTo
==================
*/
void G_RadioTo( gentity_t *ent, gentity_t *other, int mode, int color, const char *name, const char *message ) {
	if (!other) {
		return;
	}
	if (!other->inuse) {
		return;
	}
	if (!other->client) {
		return;
	}
	if ((g_radioDead.integer == 0) && (other->health <= 0))	// no radio msgs to dead players
		return;

	if ( mode == RADIO_TEAM  && !OnSameTeam(ent, other) ) {
		return;
	}
	// no chatting to players in tournements
	if ( g_gametype.integer == GT_TOURNAMENT
		&& other->client->sess.sessionTeam == TEAM_FREE
		&& ent->client->sess.sessionTeam != TEAM_FREE ) {
		return;
	}
	
	trap_SendServerCommand( other-g_entities, va("%s \"%i\" \"%s\" \"%s%c%c RADIO: %s\"", 
		mode == RADIO_TEAM ? "tradio" : "radio", ent->client->ps.clientNum, message,
		name, Q_COLOR_ESCAPE, color, ent->client->radioTxtMsg ));
}

/*
==================
G_Radio
==================
*/
void G_Radio( gentity_t *ent, gentity_t *target, int mode, char *message, qboolean setLastRadioTime ) {
	int			j;
	gentity_t	*other;
	int			color;
	char		name[64];
	char		location[64];

	// check if user is flooding
	if ((ent->client->lastRadioTime > 0) && ((level.time - ent->client->lastRadioTime) < g_radioFlood.integer)) {
		return;
	}
	
	// are dead allowed to send messages?
	if ((g_radioDead.integer == 0) && (ent->health <= 0))
		return;
	
	if ( g_gametype.integer < GT_TEAM && mode == RADIO_TEAM ) {
		mode = RADIO_ALL;
	}

	switch ( mode ) {
	default:
	case RADIO_ALL:
		
		G_LogPrintf( "%s RADIO %s\n", ent->client->pers.netname, message );
		Com_sprintf (name, sizeof(name), "%s%c%c", ent->client->pers.netname, Q_COLOR_ESCAPE, COLOR_WHITE );
		color = COLOR_GREEN;
		
		break;
	case RADIO_TEAM:
		
		G_LogPrintf( "%s RADIO_TEAM %s\n", ent->client->pers.netname, message );
		if (Team_GetLocationMsg(ent, location, sizeof(location)))
			Com_sprintf (name, sizeof(name), "(%s%c%c) (%s)", 
				ent->client->pers.netname, Q_COLOR_ESCAPE, COLOR_WHITE, location);
		else
			Com_sprintf (name, sizeof(name), "(%s%c%c)", 
				ent->client->pers.netname, Q_COLOR_ESCAPE, COLOR_WHITE );
		color = COLOR_CYAN;
		
		break;
	case RADIO_TELL:
				
		if (target && g_gametype.integer >= GT_TEAM &&
			target->client->sess.sessionTeam == ent->client->sess.sessionTeam &&
			Team_GetLocationMsg(ent, location, sizeof(location)))
			Com_sprintf (name, sizeof(name), "[%s%c%c] (%s)", ent->client->pers.netname, Q_COLOR_ESCAPE, COLOR_WHITE, location );
		else
			Com_sprintf (name, sizeof(name), "[%s%c%c]", ent->client->pers.netname, Q_COLOR_ESCAPE, COLOR_WHITE );
		color = COLOR_MAGENTA;
		
		break;
	}

	// add the radio sprite above head of player
	ent->client->ps.eFlags &= ~(EF_AWARD_IMPRESSIVE | EF_AWARD_EXCELLENT | EF_AWARD_GAUNTLET | EF_AWARD_RADIO);
	ent->client->ps.eFlags |= EF_AWARD_RADIO;
	ent->client->rewardTime = level.time + REWARD_SPRITE_TIME;

	// setting lastRadioTime
	// used for flood preventing
	if ( setLastRadioTime ) 
		ent->client->lastRadioTime = level.time;
	
	if ( target ) {
		G_RadioTo( ent, target, mode, color, name, message );
		return;
	}

	// send it to all the apropriate clients
	for (j = 0; j < level.maxclients; j++) {
		other = &g_entities[j];
		G_RadioTo( ent, other, mode, color, name, message );
	}
}



//////////////
// COMMANDS //
//////////////

/*
==================
Cmd_Radio_f
==================
*/
void Cmd_Radio_f( gentity_t *ent, int mode, qboolean arg0 ) {
	char		*p;
	
	if ( trap_Argc () < 2 && !arg0 ) {
		return;
	}

	if (arg0)
	{
		p = ConcatArgs( 0 );
	}
	else
	{
		p = ConcatArgs( 1 );
	}
	
	G_Radio( ent, NULL, mode, p, qtrue );
}


/*
==================
Cmd_RadioTell_f
==================
*/
void Cmd_RadioTell_f( gentity_t *ent ) {
	int			targetNum;
	gentity_t	*target;
	char		*p;
	char		arg[MAX_TOKEN_CHARS];

	if ( trap_Argc () < 2 ) {
		return;
	}

	trap_Argv( 1, arg, sizeof( arg ) );
	targetNum = atoi( arg );
	if ( targetNum < 0 || targetNum >= level.maxclients ) {
		return;
	}

	target = &g_entities[targetNum];
	if ( !target || !target->inuse || !target->client ) {
		return;
	}

	p = ConcatArgs( 2 );

	G_LogPrintf( "RADIO_TELL: %s to %s: %s\n", ent->client->pers.netname, target->client->pers.netname, p );
	G_Radio( ent, target, RADIO_TELL, p, qfalse );
	G_Radio( ent, ent, RADIO_TELL, p, qtrue );
}


/*
==================
Cmd_GetRadioTxtMsg_f
==================
*/
void Cmd_GetRadioTxtMsg_f( gentity_t *ent, qboolean arg0 ) {
	char		*p;
	char		arg[MAX_TOKEN_CHARS];
	int			clientNum;
	
	if ( trap_Argc () < 3 ) {
		return;
	}

	trap_Argv( 1, arg, sizeof( arg ) );
	clientNum = atoi( arg );
	if ( clientNum < 0 || clientNum >= level.maxclients ) {
		return;
	}

	p = ConcatArgs( 2 );
	
	//G_Printf("clientNum: %i ent->s.clientNum: %i p: %s\n", clientNum, ent->s.clientNum, p);
	
	if ( clientNum == ent->s.clientNum )
		Q_strncpyz( ent->client->radioTxtMsg, p, sizeof( ent->client->radioTxtMsg ) );
}
