#include <math.h>
#include <stdio.h>
#include <errno.h>
double atanh(double farg)
{
	if (farg < 0.0)
		farg = -farg;
	if (farg == 0.0 || farg > 1.0) {
		errno = ERANGE;
		return 0.0;
	}
	return 0.5 * log( (1.0 + farg) / (1.0 - farg) );
}

#ifdef STANDALONE
/*
Correct output:
J:\lcc\lib\src>atanh
[0.1] 0.100335347731076
[0.2] 0.202732554054082
[0.3] 0.309519604203112
[0.4] 0.423648930193602
[0.5] 0.549306144334055
[0.6] 0.693147180559945
[0.7] 0.867300527694053
[0.8] 1.098612288668110
[0.9] 1.472219489583220
*/
int main()
{
        int i=1;
        double r;

        while (i < 10) {
                r= atanh((double)i/10.0);
                printf("[%3.1f] %10.15f\n",(double)i/10.0,r);
                i++;
        }
} 
#endif
