// GENERIC UNREAL TOURNAMENT PPM INFO SCRIPT
// author: Potempkin
// e-mail: pc@potempkin.clara.net
// date:   march 1st 2000

//=============================================================================
// XXXXMeshInfo.
//=============================================================================
class XXXXMeshInfo extends CustomMeshInfo;

// The line above tells UT that this script inherits from and expands upon the CustomMeshInfo class.
// All instances of 'XXXX' should be replaced with the mesh name
// which is the name given to the mesh when 3ds2unr converts your model.
// The two lines below are processed when you make a .u package containing your model.
// Values on the second line may be used to orientate the mesh with the collsion box if neccessary.

#exec MESH IMPORT MESH=XXXX ANIVFILE=MODELS\XXXX_a.3d DATAFILE=MODELS\XXXX_d.3d X=0 Y=0 Z=0 UNMIRROR=0 LODPARAMS=8 
#exec MESH ORIGIN MESH=XXXX X=0 Y=0 Z=0 YAW=0 ROLL=0 PITCH=0

// What the above commands mean:
// #exec MESH IMPORT		-- tells engine to compile a mesh
// MESH=XXXX			-- name of mesh to process
// ANIVFILE=MODELS\XXXX_a.3d	-- location of animation/frame file
// DATAFILE=MODELS\XXXX_d.3d	-- location of data file (vertex order and mapping)
// X=0 Y=0 Z=0			-- no idea! probably sets local origin at 0,0,0
// UNMIRROR=0			-- flag to mirror mesh left/right (ignore it)
// LODPARAMS=8			-- Level of detail type
// #exec MESH ORIGIN		-- origin co-ordiantes (to line up with collision box)
// X=0 Y=0 Z=0			-- values to move mesh to match collision box if neccessary
// YAW=0 ROLL=0 PITCH=0		-- rotation. a value of 256 is equivlant to a complete rotation


// --- ANIMATIONS ---
// There is no set order or framecount for animations. The engine looks for the start frame and framecount of the 
// named sequence it expects to find. There are 65 animation sequences in all. You only need to animate 33 of them
// plus 16 single frame sequences. The order presented below is one that I found made a lot of sense when animating.
// Those used to making PPMs with restrictions on sequence frame counts may find comfort in this generic layout ;0)
// What the commands mean:
// #exec MESH SEQUENCE 		-- process an animated mesh
// MESH=XXXX			-- name of mesh
// SEQ=BREATH1			-- name of animation sequence (based on conventions declared elsewhere)
// STARTFRAME=0			-- start frame (note zero is the first frame of your animation)
// NUMFRAMES=10			-- total frames in animation sequence
// RATE=12			-- frames per second/animation rate. not needed for single frames

// --- STANDING (little or no foot movement) ---
#exec MESH SEQUENCE MESH=XXXX SEQ=All       STARTFRAME=0   NUMFRAMES=399		//total framecount
#exec MESH SEQUENCE MESH=XXXX SEQ=BREATH1   STARTFRAME=0   NUMFRAMES=10	  RATE=12	//idle (default)
#exec MESH SEQUENCE MESH=XXXX SEQ=BREATH1L  STARTFRAME=0   NUMFRAMES=10	  RATE=12	//"
#exec MESH SEQUENCE MESH=XXXX SEQ=BREATH3   STARTFRAME=0   NUMFRAMES=10	  RATE=14	//"
#exec MESH SEQUENCE MESH=XXXX SEQ=BREATH2   STARTFRAME=10  NUMFRAMES=8	  RATE=10	//random idle 1
#exec MESH SEQUENCE MESH=XXXX SEQ=BREATH2L  STARTFRAME=10  NUMFRAMES=8	  RATE=10	//"
#exec MESH SEQUENCE MESH=XXXX SEQ=LOOK      STARTFRAME=18  NUMFRAMES=18   RATE=12 	//random idle 2
#exec MESH SEQUENCE MESH=XXXX SEQ=AIMDNSM   STARTFRAME=36  NUMFRAMES=1			//aim small gun down
#exec MESH SEQUENCE MESH=XXXX SEQ=AIMUPSM   STARTFRAME=37  NUMFRAMES=1			//aim small gun up
#exec MESH SEQUENCE MESH=XXXX SEQ=AIMDNLG   STARTFRAME=38  NUMFRAMES=1			//aim big gun down
#exec MESH SEQUENCE MESH=XXXX SEQ=AIMUPLG   STARTFRAME=39  NUMFRAMES=1			//aim big gun up
#exec MESH SEQUENCE MESH=XXXX SEQ=STILLFRRP STARTFRAME=40  NUMFRAMES=10	  RATE=18	//fire ripper
#exec MESH SEQUENCE MESH=XXXX SEQ=STILLLGFR STARTFRAME=50  NUMFRAMES=10	  RATE=18	//fire big gun
#exec MESH SEQUENCE MESH=XXXX SEQ=STILLSMFR STARTFRAME=60  NUMFRAMES=10	  RATE=18	//fire small gun
#exec MESH SEQUENCE MESH=XXXX SEQ=COCKGUN   STARTFRAME=70  NUMFRAMES=12	  RATE=10	//random idle 3
#exec MESH SEQUENCE MESH=XXXX SEQ=COCKGUNL  STARTFRAME=70  NUMFRAMES=12	  RATE=8	//"
#exec MESH SEQUENCE MESH=XXXX SEQ=CHAT1     STARTFRAME=82  NUMFRAMES=16	  RATE=10	//chatting
#exec MESH SEQUENCE MESH=XXXX SEQ=THRUST    STARTFRAME=98  NUMFRAMES=22	  RATE=14	//taunt (pelvic thrust)
#exec MESH SEQUENCE MESH=XXXX SEQ=TAUNT1    STARTFRAME=98  NUMFRAMES=22	  RATE=14	//"
#exec MESH SEQUENCE MESH=XXXX SEQ=VICTORY1  STARTFRAME=120 NUMFRAMES=14   RATE=14	//taunt (victory gesture)
#exec MESH SEQUENCE MESH=XXXX SEQ=WAVE	    STARTFRAME=134 NUMFRAMES=16   RATE=20	//taunt (wave)
#exec MESH SEQUENCE MESH=XXXX SEQ=DODGEF    STARTFRAME=150 NUMFRAMES=1			//dodge forward
#exec MESH SEQUENCE MESH=XXXX SEQ=DODGEB    STARTFRAME=151 NUMFRAMES=1			//dodge back
#exec MESH SEQUENCE MESH=XXXX SEQ=DODGEL    STARTFRAME=152 NUMFRAMES=1			//dodge left
#exec MESH SEQUENCE MESH=XXXX SEQ=DODGER    STARTFRAME=153 NUMFRAMES=1			//dodge right
#exec MESH SEQUENCE MESH=XXXX SEQ=GUTHIT    STARTFRAME=154 NUMFRAMES=1			//pain lower
#exec MESH SEQUENCE MESH=XXXX SEQ=HEADHIT   STARTFRAME=155 NUMFRAMES=1			//pain upper
#exec MESH SEQUENCE MESH=XXXX SEQ=RIGHTHIT  STARTFRAME=156 NUMFRAMES=1			//pain right
#exec MESH SEQUENCE MESH=XXXX SEQ=LEFTHIT   STARTFRAME=157 NUMFRAMES=1			//pain left

// --- LOCOMOTION ---
#exec MESH SEQUENCE MESH=XXXX SEQ=WALKSM    STARTFRAME=158 NUMFRAMES=12	  RATE=13	//walk with small gun
#exec MESH SEQUENCE MESH=XXXX SEQ=WALK      STARTFRAME=158 NUMFRAMES=12	  RATE=13	//"
#exec MESH SEQUENCE MESH=XXXX SEQ=WALKLG    STARTFRAME=170 NUMFRAMES=12	  RATE=13	//walk with big gun
#exec MESH SEQUENCE MESH=XXXX SEQ=WALKSMFR  STARTFRAME=182 NUMFRAMES=12	  RATE=13	//walk firing small/big gun
#exec MESH SEQUENCE MESH=XXXX SEQ=WALKLGFR  STARTFRAME=182 NUMFRAMES=12	  RATE=13	//"
#exec MESH SEQUENCE MESH=XXXX SEQ=TURNLG    STARTFRAME=194 NUMFRAMES=3	  RATE=16   	//turn on spot
#exec MESH SEQUENCE MESH=XXXX SEQ=TURNSM    STARTFRAME=194 NUMFRAMES=3	  RATE=16   	//"
#exec MESH SEQUENCE MESH=XXXX SEQ=RUNSM     STARTFRAME=197 NUMFRAMES=10	  RATE=14	//run with small gun
#exec MESH SEQUENCE MESH=XXXX SEQ=RUNSMFR   STARTFRAME=207 NUMFRAMES=10	  RATE=14	//run firing small gun
#exec MESH SEQUENCE MESH=XXXX SEQ=RUNLG     STARTFRAME=217 NUMFRAMES=10	  RATE=14	//run with long gun
#exec MESH SEQUENCE MESH=XXXX SEQ=RUNLGFR   STARTFRAME=227 NUMFRAMES=10	  RATE=14	//run firing long gun
#exec MESH SEQUENCE MESH=XXXX SEQ=STRAFEL   STARTFRAME=237 NUMFRAMES=10	  RATE=14	//strafe to left
#exec MESH SEQUENCE MESH=XXXX SEQ=STRAFER   STARTFRAME=247 NUMFRAMES=10	  RATE=14	//strafe to right
#exec MESH SEQUENCE MESH=XXXX SEQ=BACKRUN   STARTFRAME=257 NUMFRAMES=10	  RATE=14	//run backwards
#exec MESH SEQUENCE MESH=XXXX SEQ=DuckWlkL  STARTFRAME=267 NUMFRAMES=12   RATE=13	//crouched walk
#exec MESH SEQUENCE MESH=XXXX SEQ=DuckWlkS  STARTFRAME=267 NUMFRAMES=12   RATE=13	//"
#exec MESH SEQUENCE MESH=XXXX SEQ=DUCK	    STARTFRAME=279 NUMFRAMES=12   RATE=13 	//crouch idle
#exec MESH SEQUENCE MESH=XXXX SEQ=LANDLGFR  STARTFRAME=291 NUMFRAMES=1			//land holding big gun
#exec MESH SEQUENCE MESH=XXXX SEQ=LANDSMFR  STARTFRAME=292 NUMFRAMES=1			//land holding small gun
#exec MESH SEQUENCE MESH=XXXX SEQ=JUMPLGFR  STARTFRAME=293 NUMFRAMES=1			//jump holding big gun
#exec MESH SEQUENCE MESH=XXXX SEQ=JUMPSMFR  STARTFRAME=294 NUMFRAMES=1			//jump holding small gun
#exec MESH SEQUENCE MESH=XXXX SEQ=TREADLG   STARTFRAME=295 NUMFRAMES=10	  RATE=12	//tread water
#exec MESH SEQUENCE MESH=XXXX SEQ=TREADSM   STARTFRAME=295 NUMFRAMES=10	  RATE=12	//"
#exec MESH SEQUENCE MESH=XXXX SEQ=SWIMLG    STARTFRAME=305 NUMFRAMES=10	  RATE=13	//swim
#exec MESH SEQUENCE MESH=XXXX SEQ=SWIMSM    STARTFRAME=305 NUMFRAMES=10	  RATE=13	//"

// --- ANIMATIONS WHICH ROTATE THE MESH ---
#exec MESH SEQUENCE MESH=XXXX SEQ=DEAD1     STARTFRAME=315 NUMFRAMES=12   RATE=16	//death -- fall sideways
#exec MESH SEQUENCE MESH=XXXX SEQ=DEAD2     STARTFRAME=327 NUMFRAMES=12   RATE=16	//death -- fall back
#exec MESH SEQUENCE MESH=XXXX SEQ=DEAD3     STARTFRAME=327 NUMFRAMES=12   RATE=14	//"
#exec MESH SEQUENCE MESH=XXXX SEQ=DEAD9     STARTFRAME=339 NUMFRAMES=10	  RATE=14	//!!pain!! spasms
#exec MESH SEQUENCE MESH=XXXX SEQ=DEAD9B    STARTFRAME=349 NUMFRAMES=10   RATE=14	//death -- drop forward
#exec MESH SEQUENCE MESH=XXXX SEQ=DEAD4     STARTFRAME=359 NUMFRAMES=14	  RATE=14   	//death -- backflip death
#exec MESH SEQUENCE MESH=XXXX SEQ=DEAD5     STARTFRAME=373 NUMFRAMES=16	  RATE=14	//death -- DECAPITATION
#exec MESH SEQUENCE MESH=XXXX SEQ=DeathEnd  STARTFRAME=326 NUMFRAMES=1			//dead (frame from dead1 used)
#exec MESH SEQUENCE MESH=XXXX SEQ=DeathEnd2 STARTFRAME=338 NUMFRAMES=1			//dead (frame from dead3 used)
#exec MESH SEQUENCE MESH=XXXX SEQ=DeathEnd3 STARTFRAME=338 NUMFRAMES=1			//dead (frame from dead4 used
#exec MESH SEQUENCE MESH=XXXX SEQ=FLIP      STARTFRAME=389 NUMFRAMES=10	  RATE=14	//forward sommersault

// While the walking, running, and swimming rates work for my models they are dependant on stride length
// All other rates are untested but are educated guesses as to what might work well.
// The animation list was based on the Skaarj player which doubles up many sequences successfully.
// If you're unsure how to represent a sequence then play a Practice Session with the Skaarj as your player
// and type 'behindview 1' at the console to see it in third person.
// You can lower the game speed to study animations though you should not use this to judge walk and run rates.


// --- MESHMAP ---
// These two lines are concerned with texture mapping
// You should use the lines created by 3ds2unr

#exec MESHMAP NEW   MESHMAP=XXXX MESH=XXXX
#exec MESHMAP SCALE MESHMAP=XXXX X=0.1 Y=0.1 Z=0.2


// --- SOUNDS ---
// Play sounds during named animation sequences
// Nothing needs to be altered here except MESH=[Yourmesh]

#exec MESH NOTIFY MESH=XXXX SEQ=Dead1 		TIME=0.6  FUNCTION=LandThump
#exec MESH NOTIFY MESH=XXXX SEQ=Dead2 		TIME=0.55 FUNCTION=LandThump
#exec MESH NOTIFY MESH=XXXX SEQ=Dead3 		TIME=0.35 FUNCTION=LandThump
#exec MESH NOTIFY MESH=XXXX SEQ=Dead4 		TIME=0.58 FUNCTION=LandThump
#exec MESH NOTIFY MESH=XXXX SEQ=Dead5 		TIME=0.65 FUNCTION=LandThump
#exec MESH NOTIFY MESH=XXXX SEQ=Dead9B 		TIME=0.7  FUNCTION=LandThump
#exec MESH NOTIFY MESH=XXXX SEQ=Walk 		TIME=0.3  FUNCTION=playfootstep
#exec MESH NOTIFY MESH=XXXX SEQ=Walk 		TIME=0.8  FUNCTION=playfootstep
#exec MESH NOTIFY MESH=XXXX SEQ=WalkSm  	TIME=0.3  FUNCTION=playfootstep
#exec MESH NOTIFY MESH=XXXX SEQ=WalkSm  	TIME=0.8  FUNCTION=playfootstep
#exec MESH NOTIFY MESH=XXXX SEQ=WalkLg  	TIME=0.3  FUNCTION=playfootstep
#exec MESH NOTIFY MESH=XXXX SEQ=WalkLg  	TIME=0.8  FUNCTION=playfootstep
#exec MESH NOTIFY MESH=XXXX SEQ=WalkLgFr 	TIME=0.3  FUNCTION=playfootstep
#exec MESH NOTIFY MESH=XXXX SEQ=WalkLgFr 	TIME=0.8  FUNCTION=playfootstep
#exec MESH NOTIFY MESH=XXXX SEQ=WalkSmFr 	TIME=0.3  FUNCTION=playfootstep
#exec MESH NOTIFY MESH=XXXX SEQ=WalkSmFr 	TIME=0.8  FUNCTION=playfootstep
#exec MESH NOTIFY MESH=XXXX SEQ=RunLg 		TIME=0.25 FUNCTION=playfootstep
#exec MESH NOTIFY MESH=XXXX SEQ=RunLg 		TIME=0.75 FUNCTION=playfootstep
#exec MESH NOTIFY MESH=XXXX SEQ=RunSm 		TIME=0.25 FUNCTION=playfootstep
#exec MESH NOTIFY MESH=XXXX SEQ=RunSm 		TIME=0.75 FUNCTION=playfootstep
#exec MESH NOTIFY MESH=XXXX SEQ=RunLgFr 	TIME=0.25 FUNCTION=playfootstep
#exec MESH NOTIFY MESH=XXXX SEQ=RunLgFr 	TIME=0.75 FUNCTION=playfootstep
#exec MESH NOTIFY MESH=XXXX SEQ=RunSmFr 	TIME=0.25 FUNCTION=playfootstep
#exec MESH NOTIFY MESH=XXXX SEQ=RunSmFr 	TIME=0.75 FUNCTION=playfootstep
#exec MESH NOTIFY MESH=XXXX SEQ=BackRun 	TIME=0.25 FUNCTION=playfootstep
#exec MESH NOTIFY MESH=XXXX SEQ=BackRun 	TIME=0.75 FUNCTION=playfootstep
#exec MESH NOTIFY MESH=XXXX SEQ=StrafeL 	TIME=0.25 FUNCTION=playfootstep
#exec MESH NOTIFY MESH=XXXX SEQ=StrafeL 	TIME=0.75 FUNCTION=playfootstep
#exec MESH NOTIFY MESH=XXXX SEQ=StrafeR 	TIME=0.25 FUNCTION=playfootstep
#exec MESH NOTIFY MESH=XXXX SEQ=StrafeR 	TIME=0.75 FUNCTION=playfootstep


//There are no default properties defined for this class


defaultproperties
{
}
