--ChilliSkinner - 3DStudio MAXScript Utility to aid model skinning
--Copyright (C) 2000 Colin 'Chilli' Semple - Chilliweb Software - Chilli@Chilliweb.co.uk
--Version 1.0  1/6/00

--This program is free software; you can redistribute it and/or modify it under the terms of the
--GNU General Public License as published by the Free Software Foundation; either version 2
--of the License, or (at your option) any later version. This program is distributed in the hope that
--it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of 
--MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
--General Public License for more details. You should have received a copy of the GNU General
--Public License along with this program; if not, write to the Free Software Foundation, Inc., 
--59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. 


global nScaling =2.0 
global nGridSize =100.0
global StoreGrid = bigmatrix 100 100
global ObjStore=#()
global nNextTop=0.0  
global nNextLeft=0.0  
global nNumObjs= 0.0 
global nNumFac= 0.0
global nPiecesPlaced =0
global nWidth=140
global nTolerence=0.04 

rollout EgoStroke "About..."
(
	Bitmap ChilliLogo Filename:"Chillilogo.bmp"
	Label Align1 "Version 1.0"
	Label Align2 "GNU General Public License"
	Label Align3 "www.chilliweb.co.uk/chilliskinner"
	Label Align4 "Chilli@ChilliWeb.co.uk"
	Label Align5 "Big thankyou goes out to:"
	Label Align6 "Nathan 'Azm0' Fletcher"
	Label Align7 "James 'Pete' Chapman"
)

rollout Status1 "Status"
(
	ProgressBar ProgressB color:green value:100 width:nWidth
)

rollout Part1 "Part 1"
(
	Spinner  spTolerence "Tolerance= " range:[0,10,0.04] enabled:True width:nWidth type:#float scale:0.005
	on spTolerence changed tmp do nTolerence=tmp
	
	button ccDetach "1 - Poly Finder/Detacher" width:nWidth
	on ccDetach pressed do
	(
		ShowStatus Green 0
		FaceFinder $
		ShowStatus Green 100
	)

	button ccClone "2 - Clone & Hide" width:nWidth 
	on ccClone pressed do
	(
		ShowStatus Green 0
		Make_copy()
		ShowStatus Green 100
	)	
	
	button ccAlign "3 - Align Polys #Z" width:nWidth 
	on ccAlign pressed do
	(
		local eFlag=False
		ShowStatus Green 0
		for Obj in Objects do
		(
			if Obj.IsHidden!=True do
			(
				nResult=AlignPoly Obj
				if nResult==0 do
				(
					eFlag=True
				)
			)
		)
		max tool zoomextents all
		if eFlag==True do
		(
			ShowStatus Red 100
		)
		if eFalg==False do
		(
			ShowStatus Green 100
		)
	)

	button ccOptim "4a - Optimise Polys" width:nWidth 
	on ccOptim pressed do
	(
		ShowStatus Green 0
		OptimiseAll()		
		ShowStatus Green 100
	)	
	
	button ccScaleCalc "4b - Autocalc Scaling" width:nWidth 
	on ccScaleCalc pressed do
	(
		ShowStatus Green 0
		TotalGridArea()
		ShowStatus Green 100
	)	
	
	Spinner  spScaling "Scaling= " range:[1,100,2] enabled:True width:90 type:#float scale:0.1
	on spScaling changed tmp do nScaling=tmp	
	
	button ccArrange "4c - Arrange Polys" width:nWidth
	on ccArrange pressed do
	(
		ShowStatus Green 0
		nReturn=Posit()
		if nReturn==-1 do
		(
			ShowStatus Green 100
		)
		if nReturn==0 do
		(
			ShowStatus Red 200
			print "debug:  pieces placed out of total"
			print nPiecesPlaced+1
			print nNumObjs			
		)
		max tool zoomextents all
	)
)

rollout Part2 "Part 2"
(
	button ccAttach1 "5 - Attach Src Objs" width:nWidth 
	on ccAttach1 pressed do
	(
		ShowStatus Green 0
		attach_all_1()
		ShowStatus Green 100
	)
	
	button ccPlanar "6 - Apply Planar Map" width:nWidth
	on ccPlanar pressed do
	(
		ShowStatus Green 0
		b=$
		ApplyPlanarMap b #z	
		ShowStatus Green 100
	)
 
	button ccToggle "7 - Toggle Objs" width:nWidth 
	on ccToggle pressed do
	(	
		ShowStatus Green 0
		max select all
		obj=$
		max unhide all
		max hide selection
		max tool zoomextents all		
		ShowStatus Green 100
	)
	
	button ccAttach2 "8 - Attach Tgt Objs" width:nWidth 
	on ccAttach2 pressed do
	(	
		ShowStatus Green 0
		attach_all_2()
		ShowStatus Green 100
	)
	
	button ccMorph "9 - Morph Src Tgt" width:nWidth 
	on ccMorph pressed do
	(
		ShowStatus Green 0
		Morph_All()
		max tool zoomextents all
		ShowStatus Green 100
	)

	button ccWeld "10 - Weld Vertices" width:nWidth 
	on ccWeld pressed do
	(
		ShowStatus Green 0
		Weld_All()
		ShowStatus Green 100
	)

	button ccClose "11 - You're Finished!" width:nWidth 
	on ccClose pressed do
	(
		CloseRolloutFloater ChilliFloater
	)
)


-- create the rollout window and add the  rollout
if ChilliFloater != undefined do
(
	closerolloutfloater ChilliFloater
)		
ChilliFloater = newRolloutFloater "ChilliSkinner" 200 450 
addRollout EgoStroke ChilliFloater
EgoStroke.open=False
addRollout Status1 ChilliFloater
addRollout Part1 ChilliFloater
Part1.open=True
addRollout Part2 ChilliFloater
Part2.open=False


-----------------------------------------


--finds extreme vertices for obj, returns vertex
Fn ExtremeVertex obj XYZ highlow =
(
	local HighVert =obj.verts[1]
	local CurrVert =0.0
	local fnResult =0.0
	local nNumVerts =0.0
	local VertArray=#()
	nNumVerts=Obj.Numverts
	
	for CurrVert in Obj.Verts do
	(
		case of
		(
			(XYZ == "X"):
			(
				case of
				(
					(highlow=="HIGH"): 
					(
						if CurrVert.pos.X > HighVert.pos.X do HighVert=CurrVert
					)
					(highlow=="LOW"): 
					(
					if CurrVert.pos.X < HighVert.pos.X do HighVert=CurrVert
					)
				)
			)
			(XYZ == "Y"):
			(
				case of
				(
					(highlow=="HIGH"):
					(
						if CurrVert.pos.Y > HighVert.pos.Y do HighVert=CurrVert
					)
					(highlow=="LOW"):
					(
						if CurrVert.pos.Y < HighVert.pos.Y do HighVert=CurrVert
					)
				)
			)
			(XYZ == "Z"):
			(
				case of
				(
					(highlow=="HIGH"):
					(
						if CurrVert.pos.Z > HighVert.pos.Z do HighVert=CurrVert
					)
					(highlow=="LOW"):
					(
						if CurrVert.pos.Z < HighVert.pos.Z do HighVert=CurrVert
					)
				)
			)
		)
	)
	fnResult=HighVert
	return fnResult
)



--Find the rectangular area of a piece assuming that the piece is oriented in the Z plane
Fn PieceArea objPiece =
(
	HighY=ExtremeVertex ObjPiece "Y" "HIGH"
	LowY=ExtremeVertex ObjPiece "Y" "LOW"
	HighX=ExtremeVertex ObjPiece "X" "HIGH"
	LowX=ExtremeVertex ObjPiece "X" "LOW"
	return ((HighX.pos.x - LowX.pos.x) * (HighY.pos.y - LowY.pos.y))
)


-- Fills matrix with zeros
fn EmptyArray =
(
	local xCounter =0.0 
	local yCounter =0.0 

	for yCounter= 1 to nGridSize do
	(
		for xCounter= 1 to nGridSize do
		(
			StoreGrid[yCounter][xCounter]=0
		)
	)
)


--Finds total area of all rectangles
Fn TotalGridArea =
(
    local nTotalArea = 0.0

    For obj in objects do
	(
		if obj.IsHidden==False do
		(
        	nTotalArea += PieceArea(obj) 
		)
	)
	nScaling = Sqrt(nTotalArea) /100.0
	Part1.spScaling.value=(nScaling + (nscaling * 0.2))
)


--Find next largest poly
Fn FindNextLargestPiece =
(
	local nLargestArea =0.0
	local objLargestPiece =0.0
	
	For obj in objects do
	(	
		if obj.IsHidden==False do
		(
			local ObjExists=false
			--check if weve already done this piece
			for ObjStored in ObjStore do
			(
				if obj==ObjStored then ObjExists=true
			)
			if	ObjExists==false do
			(
				if PieceArea(obj) >= nLargestArea do
				(
					nLargestArea=PieceArea(obj)
					ObjLargestPiece=obj
				)
			)
		)
	)
	append ObjStore ObjLargestPiece
	return ObjLargestPiece
)


--See if there is space for the piece in question
Fn CheckSpace ObjPiece matTopRow matTopCol FillArray= 
(    
    local nPieceRight =0.0
    local nPieceTop =0.0
    local nPieceBottom =0.0
    local nPieceLeft=0.0
	local nRow =0.0
    local nCol =0.0
	local matBottomRow =0.0
	local matBottomCol =0.0
	local nWidth =0.0
	local nHeight =0.0
		
	nPieceRight=ExtremeVertex ObjPiece "X" "HIGH"
	nPieceBottom=ExtremeVertex ObjPiece "Y" "LOW"
	nPieceLeft=ExtremeVertex ObjPiece "X" "LOW"
	nPieceTop=ExtremeVertex ObjPiece "Y" "HIGH"
	
	nWidth=ceil(nPieceRight.pos.x - nPieceLeft.pos.x)
	nHeight=ceil(nPieceTop.pos.y - nPieceBottom.pos.y)	

	matBottomRow=matTopRow + ceil(nHeight/nScaling)
	matBottomCol=matTopCol + ceil(nWidth/nScaling)

    If matBottomCol > nGridSize Or matBottomRow > nGridSize do ( return 0 )
    
    For nRow = matTopRow To matBottomRow do
	(
        For nCol = matTopCol To matBottomCol do
		(
			if FillArray==True do
			( 
				StoreGrid[nRow][nCol]=nPiecesplaced+101
			)	
			if FillArray==False do
			( 	
 				if StoreGrid[nRow][nCol] > 0 do ( return 0 )
			)

		)
	)
	return -1
)


--Find somewhere to put the piece
Fn FindHole objPiece =
(
	local nRow =0.0
	local nCol =0.0
	local nReturn =0.0
	local nButtOutCount=0.0

	For nRow = 1 To nGridSize do
	(
 	   For nCol = 1 To nGridSize do
		(
        	If StoreGrid[nRow][nCol] == 0 do
			(
				nReturn=CheckSpace objPiece nRow nCol False
				if nReturn == -1 do
				(
    	     		nNextTop = nRow 
        	    	nNextLeft = nCol 
	            	return -1
				)
			)
			if nRow==nGridSize and nCol==nGridSize do
			( 
			print "Insufficient Space for piece"
			return 0 
			)
		)
	)
	return 0
)


--Moves object
fn MoveObject ObjNextPiece NewX NewY =
(
	HighY=ExtremeVertex ObjNextPiece "Y" "HIGH"
	LowX=ExtremeVertex ObjNextPiece "X" "LOW"

	CurrX=ObjNextPiece.pos.x
	CurrY=ObjNextPiece.pos.y

	DiffY=HighY.pos.y-CurrY
	if CurrY>HighY.pos.y do
	(
		DiffY=CurrY-HighY.pos.y
	)

	DiffX=LowX.pos.x-CurrX
	if CurrX>LowX.pos.x do
	(
		DiffX=CurrX-LowX.pos.x
	) 

	NewMaxY=(((NewY*nScaling)+DiffY)-nScaling) * -1
	NewMaxX=((NewX*nScaling)+DiffX)-nScaling
	
	ObjNextPiece.pos=[NewMaxX,NewMaxY,0]
	
	update (objnextpiece)
)


fn posit = 
(
	local objLastPiece =0.0
	local nNextPiece =0.0

	nNextLeft =0.0
	nNextTop =0.0
	local nReturn =0.0
	local objLast =0.0
	
	nPiecesPlaced=0.0
	nNumObjs=0.0
	ObjStore=#()
		
	for Obj in Objects do
	(
		if Obj.IsHidden==False do
		(
			nNumObjs+=1
		)
	)
	
	EmptyArray()  -- fill matrix with zeros

	While nPiecesPlaced < nNumObjs do
	(
		objNextPiece = FindNextLargestPiece()
				
	    nReturn=FindHole objNextPiece  
		
		if nReturn == 0 do 
		( 
			print "Abnormal Exit"
			return 0 
		)
		CheckSpace objNextPiece nNextTop nNextLeft True		
		MoveObject ObjNextPiece nNextLeft nNextTop
		--ObjNextPiece.name=(nPiecesPlaced+1) as String
		nPiecesplaced+=1
		ShowStatus Green ((100.0/nNumObjs)*(nPiecesPlaced+1))
	)
	return -1
)


fn RoundUp Num=
(
	return ceil(Num*1000.0)/1000.0
)


fn AlignPoly Obj=
(
	local OffsetY=#()
	local OffsetX=#()
	local X=0.0
	local Y=0.0
	local E1=0.0
	local E2=0.0
	local E3=0.0
	local V1=0.0
	local V2=0.0
	local V3=0.0
	local AngleV1=0.0
	local TDist1=0.0
	local TDist2=0.0
	local TDiff1=0.0
	local TDiff2=0.0
	local CorrectDist=0.0
	local CosineV1=0.0
	local SineV1=0.0
	local eFlag=False
	
	V1=getvert Obj 1 
	V2=getvert Obj 2 
	RefVert=getvert Obj 3
	E1=distance V1 V2
	
	append OffsetY 0
	append OffsetX 0
	append OffsetY 0
	append OffsetX E1
		
	for Vertcount=3 to Obj.numverts do
	(
		nVert=getvert Obj Vertcount 
		E2=distance v2 nVert
		E3=distance v1 nVert
	
		if E1==0 or E2==0 or E3==0 do
		(
			print "Debug Info"
			print "Vertices at same exact postion"
			print "Object Name"
			print Obj.name
			print "Vertex Number"
			print Vertcount
			eFlag=True
		)
			
		fFlag=False
		CosineV1 = (E1 * E1 + E3 * E3 - E2 * E2) / (2 * E1 * E3)		

		Case Of
		(
			(RoundUp(CosineV1)==-1):
			(
				Y=0
				X=E3 * -1.0
			)
			(RoundUp(CosineV1)==1.0):
			(
				Y=0
				X=E3
			)
			(RoundUp(CosineV1)!=(-1.0) and RoundUp(CosineV1)!=1.0):
			(
				X = CosineV1 * E3
				SineV1=sqrt(1-(CosineV1 * CosineV1))
				Y=SineV1 * E3
			)
		)
			
		append OffsetY Y
		append OffsetX X
	)
	
	
	If eFlag==True do
	(
		messagebox "Error - An poly has been found with at least two vertices in identical postions.  This will not be aligned.  See listener for info on the failed Poly.  Use 'weld vertices' to fix and 'Align' again."
		return 0
	)
	
	--place points
	for f=1 to Obj.numverts do
	(
		if f>3 do
		(
			
			OldVertPos=getvert Obj f
			CorrectDist=distance RefVert OldVertPos
			NewRefVert=getvert Obj 3
			TDist1=distance NewRefVert [OffsetX[f],OffsetY[f],0]
			TDist2=distance NewRefVert [OffsetX[f],OffsetY[f] * -1,0]
			
			if TDist1>10000.0 or TDist2>10000.0 do
			(
				print "debug Info"
				print "test distances >10000"
				return 0
			)
			
			if RoundUp(TDist1)>=RoundUp(CorrectDist) do
			(
				TDiff1=RoundUp(TDist1) - RoundUp(CorrectDist)
			)
			if RoundUp(TDist1)<=RoundUp(CorrectDist) do
			(
				TDiff1= RoundUp(CorrectDist) - RoundUp(TDist1)
			)	
			if RoundUp(TDist2)>=RoundUp(CorrectDist) do
			(
				TDiff2=RoundUp(TDist2) - RoundUp(CorrectDist)
			)
			if RoundUp(TDist2)<=RoundUp(CorrectDist) do
			(
				TDiff2= RoundUp(CorrectDist) - RoundUp(TDist2)
			)				
			if TDiff2 < TDiff1 do
			(
				OffsetY[f] = OffsetY[f] * -1		
			)
			
		)
		setvert Obj f [OffsetX[f],OffsetY[f],0]
	)
	update Obj
)


fn ApplyPlanarMap obj direction = 
( 
	local oldcoordsys, normalize_pos 
	obj.numtverts=obj.numverts 
	buildTVFaces obj 
	oldcoordsys=set coordsys local 
	for v = 1 to obj.numverts do 
	( 
		normalize_pos=((getvert obj v)-obj.min)/(obj.max-obj.min) 
		case direction of 
		(
			#x:
			( 
				tmp=normalize_pos.x 
				normalize_pos.x=normalize_pos.y 
				normalize_pos.y=normalize_pos.z 
				normalize_pos.z=tmp 
			) 
			#y:
			( 
				tmp=normalize_pos.y 
				normalize_pos.y=normalize_pos.z 
				normalize_pos.z=tmp 
			) 
		) 
		settvert obj v normalize_pos 
	) 
	for f = 1 to obj.numfaces do 
	(
		setTVFace obj f (getface obj f) 
	)
	set coordsys oldcoordsys 
	update obj 
) 


fn attach_all_1 =
(
	for obj in objects do
		(
		if obj!=objects[1] and obj.IsHidden==False do
			(
			attach obj objects[1]
			)
		)
	objects[1].name="Source"
	select objects[1]
)


fn attach_all_2 =
(
	for obj in objects do
		(
		if obj!=objects[2] and obj.IsHidden==False do
			(
			attach obj objects[2]
			)
		)
	objects[2].name="Target"
	select objects[2]
)


fn Weld_All =
(	
	max select all
	b=$			
	converttomesh(b)
	max modify mode 
	subobjectlevel=1
	max select all
	meshops.weld b
	subobjectlevel=0
)


fn Morph_All =
(	
	Max unhide all
	b=$source
	createmorphobject b
	c=$target
	createmorphobject c
	addmorphtarget b.morph c 2
	delete c
)


fn Make_Copy =
(	
	max select all	
	b=$	
 	copy b
	max hide inv
	max select all
)


fn IsSibling Obj Face1 Face2=
(	
	local FnResult=False
	
	Face1Verts=getface Obj Face1
	F1Vert1=Face1Verts.x
	F1Vert2=Face1Verts.y
	F1Vert3=Face1Verts.z

	Face2Verts=getface Obj Face2
	F2Vert1=Face2Verts.x
	F2Vert2=Face2Verts.y
	F2Vert3=Face2Verts.z

	if F1Vert1==F2Vert1 or F1Vert1==F2Vert2 or F1Vert1==F1Vert3 do
	(
		return FnResult=True
	)
	if F1Vert2==F2Vert1 or F1Vert2==F2Vert2 or F1Vert2==F2Vert3 do
	(
		return FnResult=True
	)
	if F1Vert3==F2Vert1 or F1Vert3==F2Vert2 or F1Vert3==F2Vert3 do
	(
		return FnResult=True
	)	
	return FnResult
)


fn DetachPoly m=
(
	ofs = getFaceSelection m					-- original selected faces
	ofvs = for f in ofs collect getFace m f  	-- original face verts
	
	-- build an old-to-new vertex map
	vmap = #()
	i = 0
	for f in ofvs do
	(
		if vmap[f.x] == undefined do vmap[f.x] = (i += 1)
		if vmap[f.y] == undefined do vmap[f.y] = (i += 1)
		if vmap[f.z] == undefined do vmap[f.z] = (i += 1)
	)
	
	-- build the new vertex coord array
	nv = #()
	for i in 1 to vmap.count do
		if vmap[i] != undefined do nv[vmap[i]] = getVert m i
	
	-- build the new face array
	nf = for f in ofvs collect [vmap[f.x], vmap[f.y], vmap[f.z]]
	
	mesh vertices:nv faces:nf
)


fn SiblingAppend PolyGroup Obj Face2=
(
	aflag=false								
	for FaceN =1 to polygroup.count do
	(
		aflag=IsSibling Obj PolyGroup[FaceN] Face2
		if aflag==true do
		(	
			return True
		)
	)
	return False
)



fn CheckForFace ObjPolys Face1 =
(
	local ff=#()
	--step through items in Objpolys 
	
	for ObjPolysN =1 to ObjPolys.count do
	(
		ff=ObjPolys[ObjPolysN]
		
		for FaceN =1 to ff.count do
		(
			gg=ff[FaceN]
			if gg==Face1 do 
			(
				return True
			)
		)
	)
	return False
)


fn FaceFinder Obj =
(
	local PolyGroup=#()  --empty array
	local ObjPolys=#()
	local aflag=false
	local BeenThere=False
	local PBarInc=0.0	
	local NumFac=0.0
	
	local xxx=0.0
	local tttmp=0.0
	
	ConvertToMesh Obj
	
	NumFac=Obj.numfaces
	PBarInc=(100.0/NumFac)

	for Face1 = 1 to NumFac do
	(
		ShowStatus Green (Face1 * PBarInc)
		
		BeenThere=CheckForFace ObjPolys Face1
		
		if BeenThere==False do
		(
			F1Norm=getFaceNormal Obj Face1  		--Get Face1 Normal
			PolyGroup=#()							--Start new PolyGroup

			append PolyGroup (Face1) 				--Add Face1 To PolyGroup
			ObjNumFaces=Obj.numfaces
			for Face2 =1 to ObjNumFaces do
			(
				if CheckForFace ObjPolys Face2==False do
				(
					F2Norm=getFaceNormal Obj Face2	--Get Face2 Normal
					if F2Norm.x >= (F1Norm.x-nTolerence) and F2Norm.x <= (F1Norm.x+nTolerence) and F2Norm.y >= (F1Norm.y-nTolerence) and F2Norm.y <= (F1Norm.y+nTolerence) and F2Norm.z >= (F1Norm.z-nTolerence) and F2Norm.z <= (F1Norm.z+nTolerence) do
					(	
						if SiblingAppend PolyGroup Obj Face2==True do
						(
							append PolyGroup (Face2)						
						)					
					)
				) 
			)
			append ObjPolys PolyGroup
		)
	)   
	
	max modify mode
	subobjectlevel=3
	
	for FaceN in ObjPolys do
	(
		setfaceselection obj FaceN 
		DetachPoly $
		update obj 
	)


	subobjectlevel=0.0
	tmp=$
	delete tmp
	max utility mode
)


--rotates object to find position where bounding box has smallest area
fn OptimiseObj Obj=
(
	local Degs=0.0
	local Optim=0.0
	local BestSoFar=0.0
	local tmp=0.0
	
	BestSoFar=piecearea Obj
	for Degs=1 to 720 do
	(
		rotate Obj 0.5 [0,0,1]
		tmp=Piecearea Obj
		if tmp<=BestSoFar do
		(
			BestSoFar=tmp
			Optim=Degs
		)
	)
	rotate Obj (Optim * 0.5) [0,0,1]
	Update Obj
)


--Optimise function, call OptimiseObj for each unhidden object
fn OptimiseAll=
(
	local PBarInc=0.0	
	local NumFac=0.0
	local ObjCount=0.0
	
	NumFac=(Objects.count/2.0)
	PBarInc=(100.0/NumFac)
	
	for Obj in Objects do
		(
		if Obj.IsHidden!=True do
		(
			OptimiseObj Obj
			ObjCount=ObjCount+=1
		)
		ShowStatus Green (ObjCount*PBarInc)
	)
)


fn ShowStatus Colour Valu =
(
	if Valu!=200 do Status1.ProgressB.value=valu
	Status1.ProgressB.color=colour
)

