{
// maps will be loaded and saved from <basepath>/maps
"basepath"                      "..\base"

// you are using your local machine to bsp, set rshcmd to ""
// and remotebasebath to the same thing as basepath.
// if you are using a remote unix host, remotebasepath
// will usually be different.
"rshcmd"                        ""
"remotebasepath"                "..\base"

// the entity classes are found by parsing through
// all the files in <entitypath>, looking for
// /*SINED comments
"entitypath"            "..\base\code\game\*.cpp"

// the models can be directly spawned by SinEd
"modelpath"            "*.def"

// the "textures" menu is filled with all of the directories
// found under <texturepath>.  All texture references from maps
// have <texturepath> implicitly prepended.
// The textures directory can be duplicated on a local harddrive
// for better performance.
"texturepath"           "\tools\sin\base\textures\"

// every five minutes, the editor will autosave a map if it is dirty.
// this should be on a local drive, so multiple people editing
// maps don't collide
"autosave"                   "c:\autosave.map"

"mrusize" "32"
"linewidth" "1"
"detailwidth" "1"

"surfacefile"            "\tools\sin\base\scripts\sample.txt"
"mapdirname" "."

// the "bsp" menu in QuakeEd is filled with the following bsp_* commands
// when selected, the value string will be expanded then executed in the
// background.
// ! will be replaced with <rshcmd>
// $ will be replaced with <remotebasepath>/maps/<mapdirname>/<currentmap>
// @ is changed to a quote(in case you need one in the command line)

"bsp_Relight_Qrad"  "! qbsp3 -onlyents $ && ! qrad3 $"
"bsp_novis"             "! qbsp3 $"
"bsp_Entities"          "! qbsp3 -onlyents $"
"bsp_FullVis (nowater)"   "! qbsp3 -nowater $ && ! qvis3 $ && ! qrad3 $"
"bsp_FullVis"           "! qbsp3 $ && ! qvis3 $ && ! qrad3 $"
"bsp_FullVis (no qrad)"         "! qbsp3 $ && ! qvis3 $"
"bsp_FullVis (qrad -extra)"   "! qbsp3 $ && ! qvis3 $ && ! qrad3 -extra $"
"bsp_FullVis (qrad -maxlt -extra)"   "! qbsp3 $ && ! qvis3 $ && ! qrad3 -maxlight 1 -extra $"
"bsp_FullVis (nodetail, qrad -extra)"   "! qbsp3 -nodetail $ && ! qvis3 $ && ! qrad3 -extra $"
"bsp_FastVis"           "! qbsp3 $ && ! qvis3 -fast $ && ! qrad3 $"
"bsp_FastVis (nowater)"   "! qbsp3 -nowater $ && ! qvis3 -fast $ && ! qrad3 $"
}

//
// key config entity
//

//
// name conversions supported
//
//   {"backspace"     , VK_BACK       },
//   {"tab"           , VK_TAB        },
//   {"return"        , VK_RETURN     },
//   {"shift"     , VK_SHIFT          },
//   {"control"   , VK_CONTROL        },
//   {"alt"       , VK_MENU           },
//   {"pause"         , VK_PAUSE      },
//   {"capslock"      , VK_CAPITAL    },
//   {"escape"        , VK_ESCAPE     },
//   {"space"         , VK_SPACE      },
//   {"pageup"          , VK_PRIOR    },
//   {"pagedown"          , VK_NEXT   },
//   {"end"           , VK_END        },
//   {"home"          , VK_HOME       },
//   {"left"     , VK_LEFT            },
//   {"up"       , VK_UP              },
//   {"right"    , VK_RIGHT           },
//   {"down"     , VK_DOWN            },
//   {"printscreen"   , VK_SNAPSHOT   },
//   {"insert"        , VK_INSERT     },
//   {"delete"        , VK_DELETE     },
//   {"kpad0"        , VK_NUMPAD0     },
//   {"kpad1"        , VK_NUMPAD1     },
//   {"kpad2"        , VK_NUMPAD2     },
//   {"kpad3"        , VK_NUMPAD3     },
//   {"kpad4"        , VK_NUMPAD4     },
//   {"kpad5"        , VK_NUMPAD5     },
//   {"kpad6"        , VK_NUMPAD6     },
//   {"kpad7"        , VK_NUMPAD7     },
//   {"kpad8"        , VK_NUMPAD8     },
//   {"kpad9"        , VK_NUMPAD9     },
//   {"padstar"     , VK_MULTIPLY     },
//   {"kpadplus"     , VK_ADD         },
//   {"comma"         , VK_COMMA      },
//   {"kpadminus"    , VK_SUBTRACT    },
//   {"kpadperiod"   , VK_DECIMAL     },
//   {"kpadslash"    , VK_DIVIDE      },
//   {"F1"            , VK_F1         },
//   {"F2"            , VK_F2         },
//   {"F3"            , VK_F3         },
//   {"F4"            , VK_F4         },
//   {"F5"            , VK_F5         },
//   {"F6"            , VK_F6         },
//   {"F7"            , VK_F7         },
//   {"F8"            , VK_F8         },
//   {"F9"            , VK_F9         },
//   {"F10"           , VK_F10        },
//   {"F11"           , VK_F11        },
//   {"F12"           , VK_F12        },
//   {"numlock"       , VK_NUMLOCK    },
//   {"period"        , VK_PERIOD     },
//   {"scrolllock"    , VK_SCROLL     }

{
   "KEY_MOVE_FORWARD"               "up"
   "KEY_MOVE_BACKWARD"              "down"
   "KEY_MOVE_LEFT"                  "comma"
   "KEY_MOVE_RIGHT"                 "period"
   "KEY_MOVE_UP"                    "D"
   "KEY_MOVE_DOWN"                  "C"
   "KEY_TURN_LEFT"                  "left"
   "KEY_TURN_RIGHT"                 "right"
   "KEY_TURN_UP"                    "A"
   "KEY_TURN_DOWN"                  "Z"
   "KEY_GRID_1"                     "1"
   "KEY_GRID_2"                     "2"
   "KEY_GRID_4"                     "3"
   "KEY_GRID_8"                     "4"
   "KEY_GRID_16"                    "5"
   "KEY_GRID_32"                    "6"
   "KEY_GRID_64"                    "7"
   "KEY_DRAG_EDGES"                 "E"
   "KEY_DRAG_VERTICES"              "V"
   "KEY_VIEW_ENTITY"                "N"
   "KEY_VIEW_CONSOLE"               "O"
   "KEY_VIEW_TEXTURE"               "T"
   "KEY_SELECTION_CLONE"            "space"
   "KEY_SELECTION_EXACT_CLONE"      "x
   "KEY_SELECTION_DELETE"           "backspace"
   "KEY_SELECTION_DESELECT"         "escape"
   "KEY_VIEW_CENTER"                "end"
   "KEY_VIEW_ZOOMIN"                "delete"
   "KEY_VIEW_ZOOMOUT"               "insert"
   "KEY_VIEW_DOWNFLOOR"             "pagedown"
   "KEY_VIEW_UPFLOOR"               "pageup"
   "KEY_CLIPPER_EXECUTE"            "return"
   "KEY_NAT_TOGGLE"                 "K"
   "KEY_SET_LIGHT_COLOR"            "P"
   "KEY_TOGGLE_XY"                  "numlock"
   "KEY_SELECTION_FLIP"             "F"
   "KEY_VIEW_HIDENONSELECTED"       "H"
   "KEY_CLIPPER_SPLIT"              "tab"
   "KEY_CLIPPER_FLIP"               "~"
   "KEY_ENTITY_MERGE"               "m"
   "KEY_CREATE_LAST_ENTITY"         "\\"
   "KEY_SHOW_GRID"                  "o"
   "KEY_VIEW_INSPECTOR"             "s"
   "KEY_SHOW_INUSE"                 "u"
   "KEY_SET_SWL"                    "w"
}