/*****************************************************************************/
/*SINED info_monster_spawnspot (1 0 0) (-16 -16 0) (16 16 64)

Potential spawn location for a monster.

"spawngroup" - the name of the group of spawn spots that this one belongs to.
Monsters use spawngroup to choose which spawn spots to spawn at.

"angle"  - the orientation for the monster to spawn in.
"angles" - the full ( x, y, z ) orientation for the monster to spawn in.
"anim"  - the animation that the monster should use when spawning here.

/*****************************************************************************/

/*****************************************************************************/
/*SINED func_areaportal (0 0 0) ?

This is a non-visible object that divides the world into
areas that are seperated when this portal is not activated.
Usually enclosed in the middle of a door.

/*****************************************************************************/

/*****************************************************************************/
/*SINED info_navbeacon (0 0.8 0) (-16 -16 0) (16 16 64)
/*****************************************************************************/

/*****************************************************************************/
/*SINED func_box (0 .5 .8) ?

  Explodable box that falls when boxes below it are destroyed.  
"items" - List of classnames to spawn when the box is destroyed.  Separate
each classname by spaces (E.g. Adrenaline RocketLauncher).  Default is NULL.
"angles" - Orientation of the item that is spawned.
"health" - Health of the box ( default is 60 )
/*****************************************************************************/

/*****************************************************************************/
/*SINED func_camera (1 0 0) ? ORBIT START_ON PAN

Camera used for cinematic sequences.  Start

"target" points to the target to orbit or follow.  If it points to a path, the camera will follow the path.
"distance" the distance to follow or orbit if the target is not a path. (default 128).
"speed" specifies how fast to move on the path or orbit.  (default 1).
"fov" specifies fov of camera, default 90.
"yaw" specifies yaw of camera, default 0.
"height" specifies height of camera from origin, default 128.
"panspeed" speed at which to pan ( 7 degrees per second )
"panmax" maximum angle offset for panning ( 45 degrees )
"nextcamera" a link to the next camera in a chain of cameras
"overlay" an overlay to use while looking through the camera
"thread" a thread label that will be fired when the camera is looked through

ORBIT tells the camera to create a circular path around the object it points to.  It the camera points to a path, it will loop when it gets to the end of the path.
START_ON causes the camera to be moving as soon as it is spawned.
PAN camera should pan from right to left

/*****************************************************************************/

/*****************************************************************************/
/*SINED console (0 .5 .8) ? NOUSE SCROLL MENU NOPVS
"consolename" (required) con<consolename>. All console names must start with con.
"virtualwidth" virtual width of the coordinate system (arbitrary units).
"virtualheight" virtual height of the coordinate system (arbitrary units).
"fraction" (0.0 - 1.0) This is the fraction of the console you want the scrolling part to take up on the screen (1 is 100%).
"scroll" 0:off / 1:on (if you want a scrolling console that takes user input).
"menu" 0:off / 1:on (if you want a user controlled menu).
"rows" number of rows for scrolling console.
"cols" number of columns for scrolling console.
"menufile" name of file that contains the menu layout commands for this console.

NOUSE - Set this if you don't want the user to be able to "use" the console.
SCROLL - Shortcut for setting up the "scroll" mode. (this is redundant with
the scroll key/value)
MENU - Shortcut for setting up the "menu" mode. (this is redundant with the
menu key/value)
NOPVS - When sending console states over the net, don't use the PVS.  (i.e.
all state changes for this console alway get sent over.  !!!Warning!!! uses
a lot of network bandwidth if you have multiple consoles that do this, it
could overflow the network buffer ).

/*****************************************************************************/

/*****************************************************************************/

/*****************************************************************************/
/*SINED func_rotatingdoor (0 .5 .8) ? START_OPEN OPEN_DIRECTION DOOR_DONT_LINK NOT_PLAYERS NOT_MONSTERS TOGGLE AUTO_OPEN TARGETED
if two doors touch, they are assumed to be connected and operate as a unit.

TOGGLE causes the door to wait in both the start and end states for a trigger event.
DOOR_DONT_LINK is for when you have two doors that are touching but you want to operate independently.

START_OPEN causes the door to move to its destination when spawned, and operate in reverse.  It is used to temporarily or permanently close off an area when triggered (not usefull for touch or takedamage doors).
OPEN_DIRECTION indicates which direction to open when START_OPEN is set.
AUTO_OPEN causes the door to open when a player is near instead of waiting for the player to use the door.
TARGETED door is only operational from triggers or script

"message"		is printed when the door is touched if it is a trigger door and it hasn't been fired yet
"openangle"    how wide to open the door
"angle"			determines the opening direction.  point toward the middle of the door (away from the hinge)
"targetname"	if set, no touch field will be spawned and a remote button or trigger field activates the door.
"health"			if set, door must be shot open
"time"			move time (0.3 default)
"wait"			wait before returning (3 default, -1 = never return)
"dmg"				damage to inflict when blocked (0 default)
"key"          The item needed to open this door (default nothing)

"sound_stop"		Specify the sound that plays when the door stops moving (default global door_stop)
"sound_move"		Specify the sound that plays when the door opens or closes (default global door_moving)
"sound_message"	Specify the sound that plays when the door displays a message
"sound_locked"	   Specify the sound that plays when the door is locked
  
/*****************************************************************************/

/*****************************************************************************/
/*SINED func_door (0 .5 .8) ? START_OPEN x DOOR_DONT_LINK NOT_PLAYERS NOT_MONSTERS TOGGLE AUTO_OPEN TARGETED
if two doors touch, they are assumed to be connected and operate as a unit.

TOGGLE causes the door to wait in both the start and end states for a trigger event.
DOOR_DONT_LINK is for when you have two doors that are touching but you want to operate independently.

START_OPEN causes the door to move to its destination when spawned, and operate in reverse.  It is used to temporarily or permanently close off an area when triggered (not usefull for touch or takedamage doors).
OPEN_DIRECTION indicates which direction to open when START_OPEN is set.
AUTO_OPEN causes the door to open when a player is near instead of waiting for the player to use the door.
TARGETED door is only operational from triggers or script

"message"		is printed when the door is touched if it is a trigger door and it hasn't been fired yet
"angle"			determines the opening direction.  point toward the middle of the door (away from the hinge)
"targetname"	if set, no touch field will be spawned and a remote button or trigger field activates the door.
"health"			if set, door must be shot open
"speed"			move speed (100 default)
"time"			move time (1/speed default, overides speed)
"wait"			wait before returning (3 default, -1 = never return)
"lip"				lip remaining at end of move (8 default)
"dmg"				damage to inflict when blocked (0 default)
"key"          The item needed to open this door (default nothing)

"sound_stop"		Specify the sound that plays when the door stops moving (default global door_stop)
"sound_move"		Specify the sound that plays when the door opens or closes (default global door_moving)
"sound_message"	Specify the sound that plays when the door displays a message
"sound_locked"	   Specify the sound that plays when the door is locked
  
/*****************************************************************************/

/*****************************************************************************/
/*SINED func_scriptdoor (0 .5 .8) ? START_OPEN x DOOR_DONT_LINK NOT_PLAYERS NOT_MONSTERS TOGGLE AUTO_OPEN TARGETED
if two doors touch, they are assumed to be connected and operate as a unit.

TOGGLE causes the door to wait in both the start and end states for a trigger event.
DOOR_DONT_LINK is for when you have two doors that are touching but you want to operate independently.

START_OPEN causes the door to move to its destination when spawned, and operate in reverse.  It is used to temporarily or permanently close off an area when triggered (not usefull for touch or takedamage doors).
OPEN_DIRECTION indicates which direction to open when START_OPEN is set.
AUTO_OPEN causes the door to open when a player is near instead of waiting for the player to use the door.
TARGETED door is only operational from triggers or script

"message"		is printed when the door is touched if it is a trigger door and it hasn't been fired yet
"angle"			determines the opening direction.  point toward the middle of the door (away from the hinge)
"targetname"	if set, no touch field will be spawned and a remote button or trigger field activates the door.
"health"			if set, door must be shot open
"speed"			move speed (100 default)
"time"			move time (1/speed default, overides speed)
"wait"			wait before returning (3 default, -1 = never return)
"dmg"				damage to inflict when blocked (0 default)
"key"          The item needed to open this door (default nothing)
"initthread"   code to execute to setup the door (optional)
"openthread"   code to execute when opening the door (required)
"closethread"  code to execute when closing the door (required)

"sound_stop"		Specify the sound that plays when the door stops moving (default global door_stop)
"sound_move"		Specify the sound that plays when the door opens or closes (default global door_moving)
"sound_message"	Specify the sound that plays when the door displays a message
"sound_locked"	   Specify the sound that plays when the door is locked
  
/*****************************************************************************/

/*****************************************************************************/
/*SINED func_earthquake (.5 .5 .8) (-8 -8 -8) (8 8 8)
 Causes an earthquake
"duration" is the duration of the earthquake.  Default is 0.8 seconds.
/*****************************************************************************/

/*****************************************************************************/
/*SINED func_exploder (0.4 0 0) (0 0 0) (8 8 8) x x x BIG_EXPLOSION

  Spawns an explosion when triggered.  Triggers any targets.

  "dmg" specifies how much damage to cause. Default indicates 120.
  "volume" volume at which to play explosions (default 1.0)
  "attenuation" attenuation for explosions (default normal)
  "key" The item needed to activate this. (default nothing)
/*****************************************************************************/

/*****************************************************************************/
/*SINED func_multi_exploder (0.4 0 0) ? x RANDOM_TIME RANDOM_SCALE BIG_EXPLOSION

  Spawns an explosion when triggered.  Triggers any targets.
  size of brush determines where explosions will occur.

  "dmg" specifies how much damage to cause from each explosion. (Default 120)
  "delay" delay before exploding (Default 0 seconds)
  "duration" how long to explode for (Default 1 second)
  "wait" time between each explosion (default 0.25 seconds)
  "volume" volume to play explosion sound at (default 0.5)
  "attenuation" attenuation for explosions (default normal)
  "random" random factor (default 0.25)
  "key" The item needed to activate this. (default nothing)

  RANDOM_TIME adjusts the wait between each explosion by the random factor
  RANDOM_SCALE adjusts the size of each explosion by the random factor

/*****************************************************************************/

/*****************************************************************************/
/*SINED info_grav_pathnode (0 0 .5) (-16 -16 0) (16 16 32) HEADNODE FORCE
 "radius" Radius of the effect of the pull (Default is 256)
 "speed"  Speed of the pull (Use negative for a repulsion) (Default is 100)

  Set HEADNODE to signify the head of the path.
  Set FORCE if you want un-fightable gravity ( i.e. can't go backwards )
/*****************************************************************************/

/*****************************************************************************/
/*SINED lensflare (0 1 0) (-8 -8 -8) (8 8 8)
   
"color"      (r g b) 3 values between 0 and 1.0 (Default is 1.0 1.0 1.0)
"light"      If set,make the flare emit a dynamic light. (Default is not set)
"radius"     Radius of the dynamic light (Default is 200) 
"scale"      Factor to scale the lensflare (Default is 0.5)
"sprite"     Sprite model to use for the flare (Default is sprites/glow.spr")
"lightstyle" Lightstyle of the lensflare (Default is none)
/*****************************************************************************/

/****************************************************************************
/*SINED func_launcher (0 1 0) ? 
Creates an object that launches projectiles. 

"projectile" Sets the projectile that you want to launch (Examples: Rocket, Spear, etc...)
"launchsound" Sets the launching sound.
/*****************************************************************************/

/****************************************************************************
/*SINED inventory_genericpulsepart (.3 1 .3) (-8 -8 0) (8 8 16) NOT_SOLID NOT_DAMAGABLE
Pulse Weapon Part - Will always spawn as the next piece that the user needs
to complete the weapon.  When the user picks up 3 of these, they will get the PulseRifle
/*****************************************************************************/

/*****************************************************************************/
/*SINED light_ramp (0 .5 .8) (-8 -8 -8) (8 8 8) TOGGLE

Non-displayed light that ramps its intensity from one level to another when trigger.

time			How many seconds the ramping will take (default 1.0)
startlevel	Value between 0 and 2.0 (default 0)
endlevel		Value between 0 and 2.0 (default 1.0)
"key"       The item needed to activate this. (default nothing)

/*****************************************************************************/

/*****************************************************************************/
/*SINED trigger_lightramp (0 1 0) (-8 -8 -8) (8 8 8) TOGGLE

Ramps light values on surface based light sources.
Set style to the identifier contained in groupname in the surfaces to control.

time			How many seconds the ramping will take (default 1.0)
startlevel	Value between 0 and 2.0 (default 0)
endlevel		Value between 0 and 2.0 (default 1.0)
"key"       The item needed to activate this. (default nothing)

Default style is 0.

/*****************************************************************************/

/*****************************************************************************/
/*SINED light (0 1 0) (-8 -8 -8) (8 8 8) START_OFF

Non-displayed light.

Default light value is 300.
Default style is 0.

If targeted, will toggle between on and off.
Default _cone value is 10 (used to set size of light for spotlights)
"on_style" light style to set to when "on" (default is "m")
"off_style" light style to set to when "off" (default is "a")
"key"      The item needed to activate this. (default nothing)

/*****************************************************************************/

/*****************************************************************************/
/*SINED trigger_SetLightStyle (0 1 0) (-8 -8 -8) (8 8 8) START_OFF

Used for controlling surface based light sources.

Set style to the identifier contained in groupname in the surfaces to control.

Default style is 0.

If targeted, will toggle between on and off.

"on_style" light style to set to when "on" (default is "m")
"off_style" light style to set to when "off" (default is "a")
"key"      The item needed to activate this. (default nothing)

/*****************************************************************************/

/*****************************************************************************/
/*SINED func_group (0 0 0) ?

Used to group brushes together just for editor convenience.

/*****************************************************************************/

/*****************************************************************************/
/*SINED func_remove (0 0.5 0) ?

Used for lighting and such

/*****************************************************************************/

/*****************************************************************************/
/*SINED info_null (0 0.5 0) (-4 -4 -4) (4 4 4)

Used as a positional target for spotlights, etc.

/*****************************************************************************/

/*****************************************************************************/
/*SINED info_notnull (0 0.5 0) (-4 -4 -4) (4 4 4)

Used as a positional target for lightning.

/*****************************************************************************/

/*****************************************************************************/
/*SINED func_electrocute (0 .5 .8) ?
"radius" - range of the effect (Default is 500)
"key"    The item needed to activate this. (default nothing)
  Electrocutes everything it can see if it is in the water
/*****************************************************************************/

/*****************************************************************************/
/*SINED func_spawn(0 .5 .8) (-8 -8 -8) (8 8 8)
"modelname" The name of the .def file you wish to spawn. (Required)
"spawntargetname" This will be the targetname of the spawned model. (default is null)
"key"       The item needed to activate this. (default nothing)
"attackmode" Attacking mode of the spawned actor (default 0)
/*****************************************************************************/

/*****************************************************************************/
/*SINED func_respawn(0 .5 .8) (-8 -8 -8) (8 8 8) 
When the thing that is spawned is killed, this func_respawn will get 
triggered.
"modelname"   The name of the .def file you wish to spawn. (Required)
"spawntargetname" This will be the targetname of the spawned model. (default is null)
"key"         The item needed to activate this. (default nothing)
/*****************************************************************************/

/*****************************************************************************/
/*SINED func_spawnoutofsight(0 .5 .8) (-8 -8 -8) (8 8 8) 
Will only spawn something out of sight of its targets.
"modelname"   The name of the .def file you wish to spawn. (Required)
"spawntargetname" This will be the targetname of the spawned model. (default is null)
"key"         The item needed to activate this. (default nothing)
/*****************************************************************************/

/*****************************************************************************/
/*SINED func_spawnchain(0 .5 .8) (-8 -8 -8) (8 8 8) 
Tries to spawn something out of the sight of players.  If it fails, it will
trigger its targets. 
"modelname"   The name of the .def file you wish to spawn. (Required)
"spawntargetname" This will be the targetname of the spawned model. (default is null)
"key"         The item needed to activate this. (default nothing)
/*****************************************************************************/

/*****************************************************************************/
/*SINED func_wall (0 .5 .8) ?

This is just a solid wall if not inhibitted

/*****************************************************************************/

/*****************************************************************************/
/*SINED func_illusionary (0 .5 .8) ?

A simple entity that looks solid but lets you walk through it.

/*****************************************************************************/

/*****************************************************************************/
/*SINED func_breakawaywall (0 .5 .8) ? x x NOT_PLAYERS MONSTERS PROJECTILES

Special walltype that removes itself when triggered.  Will also trigger
any func_areaportals that it targets.

"key"          The item needed to activate this. (default nothing)

If NOT_PLAYERS is set, the trigger does not respond to players
If MONSTERS is set, the trigger will respond to monsters
If PROJECTILES is set, the trigger will respond to projectiles (rockets, grenades, etc.)

/*****************************************************************************/

/*****************************************************************************/
/*SINED func_explodingwall (0 .5 .8) ? RANDOMANGLES LANDSHATTER NOT_PLAYERS MONSTERS PROJECTILES INVISIBLE ACCUMALATIVE TWOSTAGE

Blows up on activation or when attacked

"explosions"   number of explosions to spawn ( default 1 )
"land_angles"  The angles you want this piece to\
               orient to when it lands on the ground
"land_radius"  The distance of the ground the piece\
               should be when on the ground ( default 0 )
"anglespeed"   Speed at which pieces rotate ( default 100 ) \
               if RANDOMANGLES ( default is 600 )
"key"          The item needed to activate this. (default nothing)

IF RANDOMANGLES is set, object randomly spins while in the air.
IF LANDSHATTER is set, object shatters when it hits the ground.
IF TWOSTAGE is set, object can be shattered once it lands on the ground.
IF ACCUMALATIVE is set, damage is accumlative not threshold
IF INVISIBLE is set, these are invisible and not solid until triggered
If NOT_PLAYERS is set, the trigger does not respond to players
If MONSTERS is set, the trigger will respond to monsters
If PROJECTILES is set, the trigger will respond to projectiles (rockets, grenades, etc.)

/*****************************************************************************/

/*****************************************************************************/
/*SINED detail (0.5 0 1.0) ?

Used to fake details before the Quake 2 merge.

/*****************************************************************************/

/*****************************************************************************/
/*SINED misc_oxygen (1 0 0) ? VISIBLE

Touching this entity will reset the drowning time - only
responds to players.

"key" The item needed to activate this. (default nothing)
/*****************************************************************************/

/*****************************************************************************/
/*SINED misc_teleporter (1 0 0) ? VISIBLE x NOT_PLAYERS NOT_MONSTERS NOT_PROJECTILES

Touching this entity will teleport players to the targeted object.

"key" The item needed to activate this. (default nothing)

If NOT_PLAYERS is set, the teleporter does not teleport players
If NOT_MONSTERS is set, the teleporter does not teleport monsters
If NOT_PROJECTILES is set, the teleporter does not teleport projectiles (rockets, grenades, etc.)

/*****************************************************************************/

/*****************************************************************************/
/*SINED misc_teleporter_dest (1 0 0) (-32 -32 0) (32 32 8)

Point teleporters at these.

/*****************************************************************************/

/*****************************************************************************/
/*SINED waypoint (0 0.5 0) (-8 -8 -8) (8 8 8)

Used as a positioning device for objects

/*****************************************************************************/

/*****************************************************************************/
/*SINED func_shatter (0 .5 .8) ? x x NOT_PLAYERS NOT_MONSTERS NOT_PROJECTILES HURT_SHATTER THRESHOLD

For shattering objects.  Triggers only when a threshold of damage is exceeded.
Will also trigger any targeted func_areaportals when not invisible.

"health" specifies how much damage must occur before trigger fires.  Default is 20.
"percentage" specifies how much of the thing to shatter. Default is 50
"minsize" specifies minsize for tesselation, default based off size
"maxsize" specifies maxsize for tesselation, default based off size
"thickness" specifies thickness for tesselation, default same as minsize
"key"     The item needed to activate this. (default nothing)
"noise" sound to play when shattered, defaults to nothing

HURT_SHATTER - when the thing gets hurt, spawn pieces of itself
THRESHOLD - damage threshold behavior

If NOT_PLAYERS is set, the trigger does not respond to damage caused by players
If NOT_MONSTERS is set, the trigger does not respond to damage caused by monsters
If NOT_PROJECTILES is set, the trigger does not respond to damage caused by projectiles

/*****************************************************************************/

/*****************************************************************************/
/*SINED func_glass (0 .5 .8) ? x x NOT_PLAYERS NOT_MONSTERS NOT_PROJECTILES HURT_SHATTER THRESHOLD

For glass objects.  Shatters when the accumulated damage is exceeded, or when activated

"health" specifies how much damage must occur before the glass shatters.  Default is 60.
"percentage" specifies how much of the thing to shatter. Default is 50
"minsize" specifies minsize for tesselation, default based off size
"maxsize" specifies maxsize for tesselation, default based off size
"thickness" specifies thickness for tesselation, default same as minsize
"key"     The item needed to activate this. (default nothing)
"noise" sound to play when shattered, defaults to glass breaking

If NOT_PLAYERS is set, the trigger does not respond to events caused by players
If NOT_MONSTERS is set, the trigger does not respond to events caused by monsters
If NOT_PROJECTILES is set, the trigger does not respond to events caused by projectiles

/*****************************************************************************/

/*****************************************************************************/
/*SINED func_clipbox (0 .5 .8) (-16 -16 -16) (16 16 16)

Invisible bounding box used like a clip brush.  This is mainly used for blocking
off areas or improving clipping without having to recompile the map.  Because of
this, it will most likely only be spawned via script.
age is exceeded, or when activated

"mins" min point of the clip.
"maxs" max point of the clip.
"type" -
0 Monster and Player clip
1 Monster clip
2 Player clip

/*****************************************************************************/

/*****************************************************************************/
/*SINED func_throwobject (0 .5 .8) (0 0 0) (0 0 0) 

This is an object you can pickup and throw at people
/*****************************************************************************/

/*****************************************************************************/
/*SINED info_pathnode (1 0 0) (-24 -24 0) (24 24 32) FLEE DUCK COVER DOOR JUMP LADDER

FLEE marks the node as a safe place to flee to.  Actor will be removed when it reaches a flee node and is not visible to a player.

DUCK marks the node as a good place to duck behind during weapon fire.

COVER marks the node as a good place to hide behind during weapon fire.

DOOR marks the node as a door node.  If an adjacent node has DOOR marked as well, the actor will only use the path if the door in between them is unlocked.

JUMP marks the node as one to jump from when going to the node specified by target.
"target" the pathnode to jump to.

/*****************************************************************************/

/*****************************************************************************/
/*SINED info_player_start (1 0 0) (-16 -16 0) (16 16 64)

The normal starting point for a level.

/*****************************************************************************/

/*****************************************************************************/
/*SINED info_player_deathmatch (1 0 1) (-16 -16 0) (16 16 64)

potential spawning position for deathmatch games

/*****************************************************************************/

/*****************************************************************************/
/*SINED info_player_coop (1 0 1) (-16 -16 0) (16 16 64)

potential spawning position for coop games

/*****************************************************************************/

/*****************************************************************************/
/*SINED info_player_intermission (1 0 1) (-16 -16 0) (16 16 64)

viewing point in between deathmatch levels

/*****************************************************************************/

/*****************************************************************************/
/*SINED misc_medkit (1.0 0.2 0.2)
Heals whoever uses it to their max health.
/*****************************************************************************/

/*****************************************************************************/
/*SINED func_scriptobject (0 .5 .8) ? NOT_SOLID 

/*****************************************************************************/

/*****************************************************************************/
/*SINED func_scriptmodel (0 .5 .8) (0 0 0) (0 0 0) NOT_SOLID

/*****************************************************************************/

/*****************************************************************************/
/*SINED func_scriptorigin (0 .5 .8) (-8 -8 -8) (8 8 8)

Used as an alternate origin for objects.  Bind the object to the func_scriptorigin
in order to simulate changing that object's origin.
/*****************************************************************************/

/*****************************************************************************/
/*SINED func_volumetric (0 .5 .8) ?

Use this to make non-solid volumes.  You still need to set up the surface
properties with the "add" flag.
/*****************************************************************************/

/*****************************************************************************/
/*SINED func_shield (0 0 .5)
 "health" Health of the shield (Default is 100)
 "hitalpha" Alpha when the shield is hit or touched
 "clearalpha" Alpha when the shield is not hit or touched
/*****************************************************************************/

/*****************************************************************************/
/*SINED func_beam (0 .8 .5) (-8 -8 -8) (8 8 8) START_ON ANIMATE FAST ROLL RANDSTART ELECTRIC RANDALPHA 

This creates a beam effect from the origin to the target's origin. If no
target is specified, uses angles and projects beam out from there.

"model" Specifies the model to use as the beam
"overlap" Specifies the amount of overlap each beam link should have. Use this to fill 
in the cracks when using electric on beams. (Default is 0)
"minoffset" Amount of electrical variation at the endpoints of beam (Default is 5)
"maxoffset" Amount of electrical variation in the middle of beam (Default is 25)
"color" Vector specifiying the red,green, and blue components. (Default is "1 1 1")
"alpha" Alpha of the beam (Default is 1.0)
"damage" Amount of damage the beam inflicts if beam hits someone (Default is 0)
"angles" Sets the angle of the beam if no target is specified. 
"life" Deactivates the beam life seconds after the beam is activated.  If not set, beam
will not be deactivated.
"beamstyle" Sets the style for this beam to cycle through.  This applies only
to beams without models. sample styles (121 blood, 120 gunsmoke, 123 orangeglow, 124 blueyellow, 
125 debris trail, 128 oil, 129 waterspray 130 blue-yellow-blue) See global0.scr for 
more style numbers

START_ON  - Starts the beam on
ANIMATE   - Plays animation of the model
FAST      - Plays the animation at 20 frames/sec
ROLL      - Rolls the beam
RANDSTART - Starts each segment of the beam's animation on a different frame
ELECTRIC  - Applies a random electric efffect to the beam
RANDALPHA - Randomly generate the alpha for the beam

If the model field is not set, then a straight beam will be created using the color
specified. color, minoffset, maxoffset ,ANIMATE, FAST, ROLL, RANDSTART, 
ELECTRIC, and RANDALPHA are not applicable if the model is not set.

/*****************************************************************************/

/*****************************************************************************/
/*SINED fx_fire (0 .8 .5) (-8 -8 -8) (8 8 8) SINGLE STAR PARALLEL

This creates a fire sprite, it defaults to the cross shape

SINGLE - Only one sprite orientated
STAR - 4 sprites in a star shape

If you want flickering

Set style to the identifier contained in groupname in the surfaces to control.

"on_style" light style to set to when "on" (default is a flicker)
"off_style" light style to set to when "off" (default is "a")

/*****************************************************************************/

/*****************************************************************************/
/*SINED trigger_multiple (.5 .5 .5) ? x x NOT_PLAYERS MONSTERS PROJECTILES

Variable sized repeatable trigger.  Must be targeted at one or more entities.

If "health" is set, the trigger must be killed to activate each time.
If "delay" is set, the trigger waits some time after activating before firing.

"thread" name of thread to trigger.  This can be in a different script file as well\
by using the '::' notation.

"wait" : Seconds between triggerings. (.2 default)
"cnt" how many times it can be triggered (infinite default)

If NOT_PLAYERS is set, the trigger does not respond to players
If MONSTERS is set, the trigger will respond to monsters
If PROJECTILES is set, the trigger will respond to projectiles (rockets, grenades, etc.)

set "message" to text string

/*****************************************************************************/

/*****************************************************************************/
/*SINED trigger_once (.5 .5 .5) ? notouch x NOT_PLAYERS MONSTERS PROJECTILES

Variable sized trigger. Triggers once, then removes itself.  
You must set the key "target" to the name of another object in the 
level that has a matching 

If "health" is set, the trigger must be killed to activate it.
If "delay" is set, the trigger waits some time after activating before firing.

"targetname".  If "health" is set, the trigger must be killed to activate.

"thread" name of thread to trigger.  This can be in a different script file as well\
by using the '::' notation.

if "killtarget" is set, any objects that have a matching "target" will be
removed when the trigger is fired.

if "angle" is set, the trigger will only fire when someone is facing the 
direction of the angle.  Use "360" for an angle of 0.

"key" The item needed to activate this. (default nothing)

If NOT_PLAYERS is set, the trigger does not respond to players
If MONSTERS is set, the trigger will respond to monsters
If PROJECTILES is set, the trigger will respond to projectiles (rockets, grenades, etc.)

set "message" to text string

/*****************************************************************************/

/*****************************************************************************/
/*SINED trigger_relay (.5 .5 .5) (-8 -8 -8) (8 8 8) x x NOT_PLAYERS MONSTERS PROJECTILES

This fixed size trigger cannot be touched, it can only be fired by other events.
It can contain killtargets, targets, delays, and messages.

If NOT_PLAYERS is set, the trigger does not respond to events triggered by players
If MONSTERS is set, the trigger will respond to events triggered by monsters
If PROJECTILES is set, the trigger will respond to events triggered by projectiles (rockets, grenades, etc.)

/*****************************************************************************/

/*****************************************************************************/
/*SINED trigger_damagethreshold (0 .5 .8) ? x INVISIBLE NOT_PLAYERS MONSTERS ACCUMULATIVE

Triggers only when a threshold of damage is exceeded.
When used in conjunction with func_breakawaywall, allows
walls that may be destroyed with a rocket blast.  Will also trigger
any targeted func_areaportals when not invisible.

INVISIBLE tells the trigger to not be visible.

"health" specifies how much damage must occur before trigger fires.
Default is 60.

"cnt" specifies how many times the trigger can fire before it will remove itself.
-1 sepecies infinite firing.  Default is 1.

"key" The item needed to activate this. (default nothing)

If NOT_PLAYERS is set, the trigger does not respond to damage caused by players
If MONSTERS is set, the trigger will respond to damage caused by monsters

/*****************************************************************************/

/*****************************************************************************/
/*SINED trigger_secret (.5 .5 .5) ? notouch x NOT_PLAYERS MONSTERS PROJECTILES
Secret counter trigger.  Automatically sets and increments script variables \
level.total_secrets and level.found_secrets.

set "message" to text string

"key" The item needed to activate this. (default nothing)

"thread" name of thread to trigger.  This can be in a different script file as well \
by using the '::' notation.  (defaults to "global/universal_script.scr::secret")

If NOT_PLAYERS is set, the trigger does not respond to players
If MONSTERS is set, the trigger will respond to monsters
If PROJECTILES is set, the trigger will respond to projectiles (rockets, grenades, etc.)

/*****************************************************************************/

/*****************************************************************************/
/*SINED trigger_push (.5 .5 .5) ? x x NOT_PLAYERS NOT_MONSTERS NOT_PROJECTILES

Pushes entities as if they were caught in a heavy wind.

"speed" indicates the rate that entities are pushed (default 1000).

"angle" indicates the direction the wind is blowing (-1 is up, -2 is down)

"key" The item needed to activate this. (default nothing)

"target" if target is set, then a velocity will be calculated based on speed

If NOT_PLAYERS is set, the trigger does not push players
If NOT_MONSTERS is set, the trigger will not push monsters
If NOT_PROJECTILES is set, the trigger will not push projectiles (rockets, grenades, etc.)

/*****************************************************************************/

/*****************************************************************************/
/*SINED trigger_pushany (.5 .5 .5) ? x x NOT_PLAYERS NOT_MONSTERS NOT_PROJECTILES

Pushes entities as if they were caught in a heavy wind.

"speed" indicates the rate that entities are pushed (default 1000).
"angles" indicates the direction of the push
"key" The item needed to activate this. (default nothing)
"target" if target is set, then a velocity will be calculated based on speed

If NOT_PLAYERS is set, the trigger does not push players
If NOT_MONSTERS is set, the trigger will not push monsters
If NOT_PROJECTILES is set, the trigger will not push projectiles (rockets, grenades, etc.)

/*****************************************************************************/

/*****************************************************************************/
/*SINED trigger_speaker (0.3 0.1 0.6) (-8 -8 -8) (8 8 8) AMBIENT-ON RELIABLE NOT_PLAYERS MONSTERS PROJECTILES AMBIENT-OFF x TOGGLE

play a sound when it is used

AMBIENT-ON specifies an ambient sound that starts on
RELIABLE should only be set for crucial voice-overs or sounds
AMBIENT-OFF specifies an ambient sound that starts off

if (AMBIENT-?) is not set, then the sound is sent over explicitly this creates more net traffic

"volume" how loud 0-4 (1 default full volume, ambients do not respond to volume)
"noise" sound to play
"channel" channel on which to play sound (0 auto, 1 weapon, 2 voice, 3 item, 4 body, 8 don't use PHS) (voice is default)
"pitch" the pitch of the sample ( default 1, no pitch-shift )
"fadetime" fade the sound in over a time period in seconds ( default 0, no fade )
"timeofs" start time offset in milli-seconds into this sound ( default 0, no timeofs )
"attenuation" attenuation factor (0 becomes 1 for non-ambients, 2 for ambients)
   -1 - none, send to whole level
    0 - default (normal or ambient)
    1 - normal fighting sounds
    2 - idle monster sounds
    3 - ambient sounds
"key"          The item needed to activate this. (default nothing)
"thread" name of thread to trigger.  This can be in a different script file as well\
by using the '::' notation.

Normal sounds play each time the target is used.

Ambient Looped sounds have an attenuation of 2 by default, volume 1, and the use function toggles it on/off.
Multiple identical ambient looping sounds will just increase volume without any speed cost.
The attenuation factor can be over-ridden by specifying an attenuation factor.

If NOT_PLAYERS is set, the trigger does not respond to players
If MONSTERS is set, the trigger will respond to monsters
If PROJECTILES is set, the trigger will respond to projectiles (rockets, grenades, etc.)

/*****************************************************************************/

/*****************************************************************************/
/*SINED trigger_randomspeaker (0.3 0.1 0.6) (-8 -8 -8) (8 8 8) x RELIABLE NOT_PLAYERS MONSTERS PROJECTILES x x

play a sound at random times

RELIABLE should only be set for crucial voice-overs or sounds

"mindelay" minimum delay between sound triggers (default 3)
"maxdelay" maximum delay between sound triggers (default 10)
"volume" how loud 0-4 (1 default full volume)
"noise" sound to play
"channel" channel on which to play sound (0 auto, 1 weapon, 2 voice, 3 item, 4 body, 8 don't use PHS) (voice is default)
"pitch" the pitch of the sample ( default 1, no pitch-shift )
"fadetime" fade the sound in over a time period in seconds ( default 0, no fade )
"timeofs" start time offset in milli-seconds into this sound ( default 0, no timeofs )
"attenuation" attenuation factor
   -1 - none, send to whole level
    0 - default (normal)
    1 - normal fighting sounds
    2 - idle monster sounds
    3 - ambient sounds
"key"          The item needed to activate this. (default nothing)

Normal sounds play each time the target is used.

If NOT_PLAYERS is set, the trigger does not respond to players
If MONSTERS is set, the trigger will respond to monsters
If PROJECTILES is set, the trigger will respond to projectiles (rockets, grenades, etc.)

/*****************************************************************************/

/*****************************************************************************/
/*SINED trigger_changelevel (0.5 0.5 0.5) ? NO_INTERMISSION x NOT_PLAYERS MONSTERS PROJECTILES

When the player touches this, he gets sent to the map listed in the "map" variable.
Unless the NO_INTERMISSION flag is set, the view will go to the info_intermission
spot and display stats.

"spawnspot"  name of the spawn location to start at in next map.
"key"          The item needed to activate this. (default nothing)
"thread" This defaults to "LevelComplete" and should point to a thread that is called just
before the level ends.

If NOT_PLAYERS is set, the trigger does not respond to players
If MONSTERS is set, the trigger will respond to monsters
If PROJECTILES is set, the trigger will respond to projectiles (rockets, grenades, etc.)

/*****************************************************************************/

/*****************************************************************************/
/*SINED trigger_use (0.5 0.5 0.5) ? VISIBLE x NOT_PLAYERS MONSTERS

Activates targets when 'used' by an entity
"key"          The item needed to activate this. (default nothing)
"thread" name of thread to trigger.  This can be in a different script file as well\
by using the '::' notation.

If NOT_PLAYERS is set, the trigger does not respond to players
If MONSTERS is set, the trigger will respond to monsters

/*****************************************************************************/

/*****************************************************************************/
/*SINED trigger_useonce (0.5 0.5 0.5) ? VISIBLE x NOT_PLAYERS MONSTERS

Activates targets when 'used' by an entity, but only once
"key"          The item needed to activate this. (default nothing)
"thread" name of thread to trigger.  This can be in a different script file as well\
by using the '::' notation.

If NOT_PLAYERS is set, the trigger does not respond to players
If MONSTERS is set, the trigger will respond to monsters

/*****************************************************************************/

/*****************************************************************************/
/*SINED trigger_hurt (0.5 0.5 0.5) ? x x NOT_PLAYERS NOT_MONSTERS PROJECTILES

"damage" amount of damage to cause. (default 10)
"key"          The item needed to activate this. (default nothing)

If NOT_PLAYERS is set, the trigger does not hurt players
If NOT_MONSTERS is set, the trigger does not hurt monsters
If PROJECTILES is set, the trigger will hurt projectiles (rockets, grenades, etc.)

/*****************************************************************************/

/*****************************************************************************/
/*SINED trigger_damagetargets (0.5 0.5 0.5) ? SOLID x NOT_PLAYERS NOT_MONSTERS PROJECTILES

"damage" amount of damage to cause. If no damage is specified, objects\
are damaged by the current health+1

"key"          The item needed to activate this. (default nothing)

if a trigger_damagetargets is shot at and the SOLID flag is set,\
the damage is passed on to the targets

If NOT_PLAYERS is set, the trigger does not hurt players
If NOT_MONSTERS is set, the trigger does not hurt monsters
If PROJECTILES is set, the trigger will hurt projectiles (rockets, grenades, etc.)

/*****************************************************************************/

/*****************************************************************************/
/*SINED trigger_damagetargetsfixed (0.5 0.5 0.5) (-8 -8 -8) (8 8 8) SOLID x NOT_PLAYERS NOT_MONSTERS PROJECTILES

"damage" amount of damage to cause. If no damage is specified, objects\
are damaged by the current health+1

"key"          The item needed to activate this. (default nothing)

if a trigger_damagetargetsfixed is shot at and the SOLID flag is set,\
the damage is passed on to the targets

If NOT_PLAYERS is set, the trigger does not hurt players
If NOT_MONSTERS is set, the trigger does not hurt monsters
If PROJECTILES is set, the trigger will hurt projectiles (rockets, grenades, etc.)

/*****************************************************************************/

/*****************************************************************************/
/*SINED trigger_particles (0.3 0.1 0.6) (-8 -8 -8) (8 8 8)  x NOSOUND NOT_PLAYERS MONSTERS PROJECTILES RANDSTYLE BRIGHT 

spawn some particles when triggered

"count" number of particles to spawn ( default 10 )
"noise" sound to play when triggered ( defaults to random spark sounds )
"angles" specifies direction to spawn particles
"key"   The item needed to activate this. (default nothing)
"particlestyle" style of particles ( default 122 (sparks) )
sample styles (121 blood, 120 gunsmoke, 123 orangeglow, 124 blueyellow, 125 debris trail, 128 oil, 129 waterspray)

If NOSOUND is set, no sound will be played
If NOT_PLAYERS is set, the trigger does not respond to players
If MONSTERS is set, the trigger will respond to monsters
If PROJECTILES is set, the trigger will respond to projectiles (rockets, grenades, etc.)
If RANDSTYLE is set, the particles will be set to random colors in the particlestyle
if BRIGHT is set, particles will be drawn extra bright
/*****************************************************************************/

/*****************************************************************************/
/*SINED trigger_randomparticles (0.3 0.1 0.6) (-8 -8 -8) (8 8 8) START_ON NOSOUND NOT_PLAYERS MONSTERS PROJECTILES RANDSTYLE BRIGHT 

START_ON start the effect on

spawn some particles randomly
triggering the object 

"count" number of particles to spawn ( default 10 )
"noise" sound to play when triggered ( default none )
"mindelay" minimum delay between particle triggers (default 3)
"maxdelay" maximum delay between particle triggers (default 10)
"key"      The item needed to activate this. (default nothing)
"particlestyle" style of particles ( default 122 (sparks) )
sample styles (121 blood, 120 gunsmoke, 123 orangeglow, 124 blueyellow, 125 debris trail )

If NOSOUND is set, no sound will be played
If NOT_PLAYERS is set, the trigger does not respond to players
If MONSTERS is set, the trigger will respond to monsters
If PROJECTILES is set, the trigger will respond to projectiles (rockets, grenades, etc.)
If RANDSTYLE is set, the particles will be set to random colors in the particlestyle
if BRIGHT is set, particles will be drawn extra bright
/*****************************************************************************/

/*****************************************************************************/
/*SINED trigger_thread (.5 .5 .5) ? notouch x NOT_PLAYERS MONSTERS PROJECTILES

Variable sized trigger. After firing cnt times, removes itself.  

"thread" name of thread to trigger.  This can be in a different script file as well\
by using the '::' notation.

You must set the key "target" to the name of another object in the 
level that has a matching name

"cnt" how many times it can be triggered ( default 1 )
"targetname".  If "health" is set, the trigger must be killed to activate.

if "killtarget" is set, any objects that have a matching "target" will be
removed when the trigger is fired.

if "angle" is set, the trigger will only fire when someone is facing the 
direction of the angle.  Use "360" for an angle of 0.

"key" The item needed to activate this. (default nothing)

If NOT_PLAYERS is set, the trigger does not respond to players
If MONSTERS is set, the trigger will respond to monsters
If PROJECTILES is set, the trigger will respond to projectiles (rockets, grenades, etc.)

set "message" to text string

/*****************************************************************************/

/*****************************************************************************/
/*SINED trigger_camerause (0.5 0.5 0.5) ? VISIBLE x NOT_PLAYERS MONSTERS

Activates 'targeted' camera when 'used'
If activated, toggles through cameras
"key"          The item needed to activate this. (default nothing)
"thread" name of thread to trigger.  This can be in a different script file as well\
by using the '::' notation.

If NOT_PLAYERS is set, the trigger does not respond to players
If MONSTERS is set, the trigger will respond to monsters

/*****************************************************************************/

/*****************************************************************************/
/*SINED trigger_mutate (0.5 0.5 0.5) ? x x NOT_PLAYERS NOT_MONSTERS
mutates whatever triggers it.

"key"          The item needed to activate this. (default nothing)

If NOT_PLAYERS is set, the trigger does not activate on players
If NOT_MONSTERS is set, the trigger does not activate on monsters

/*****************************************************************************/

/*****************************************************************************/
/*SINED trigger_exit (0.5 0.5 0.5) ?

When the player touches this, an exit icon will be displayed in his hud.
This is to inform him that he is near an exit.

/*****************************************************************************/

/*****************************************************************************/
/*SINED worldspawn (0 0 0) ? CINEMATIC

Only used for the world.
"sky"			environment map name
"skyaxis"	vector axis for rotating sky
"skyrotate"	speed of rotation in degrees/second
"cdtrack"	music cd track number
"gravity"	800 is default gravity
"message"	text to print at user logon
"skipthread" thread that is activated to skip this level (if cinematic)

/*****************************************************************************/

